/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteErrorOnRebalanceTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)gridName));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setPageSize(1024).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setRebalanceMode(CacheRebalanceMode.ASYNC);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setIndexingSpi((IndexingSpi)new ErrorOnRebalanceIndexingSpi());
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    @Test
    public void testErrorOnRebalance() throws Exception {
        IgniteEx srv0 = this.startGrid(0);
        srv0.active(true);
        IgniteCache cache0 = srv0.cache("default");
        for (int i = 0; i < 5; ++i) {
            cache0.put((Object)i, (Object)i);
        }
        IgniteEx srv1 = this.startGrid(1);
        U.sleep((long)3000L);
        this.info("Stop node0.");
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        this.info("Restart node0.");
        srv0 = this.startGrid(0);
        this.awaitPartitionMapExchange();
        srv1.cluster().setBaselineTopology(srv1.cluster().topologyVersion());
        this.awaitPartitionMapExchange();
        IgniteCache cache02 = srv0.cache("default");
        IgniteCache cache1 = srv1.cache("default");
        HashMap<Integer, Object> map0 = new HashMap<Integer, Object>();
        HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
        for (int i = 0; i < 5; ++i) {
            map0.put(i, cache02.localPeek((Object)i, new CachePeekMode[0]));
            map1.put(i, cache1.localPeek((Object)i, new CachePeekMode[0]));
        }
        IgniteErrorOnRebalanceTest.assertEquals(map0, map1);
    }

    static class ErrorOnRebalanceIndexingSpi
    extends IgniteSpiAdapter
    implements IndexingSpi {
        volatile boolean err = true;

        ErrorOnRebalanceIndexingSpi() {
        }

        static ErrorOnRebalanceIndexingSpi spi(Ignite node) {
            return (ErrorOnRebalanceIndexingSpi)node.configuration().getIndexingSpi();
        }

        public Iterator<Cache.Entry<?, ?>> query(@Nullable String cacheName, Collection<Object> params, @Nullable IndexingQueryFilter filters) {
            return null;
        }

        public void store(@Nullable String cacheName, Object key, Object val, long expirationTime) {
            if (this.err && this.ignite.name().endsWith("IgniteErrorOnRebalanceTest1")) {
                this.ignite.log().warning("Test error on store [cache=" + cacheName + ", key=" + key + ']');
                throw new IgniteSpiException("Test error");
            }
        }

        public void remove(@Nullable String cacheName, Object key) {
        }

        public void spiStart(@Nullable String igniteInstanceName) {
        }

        public void spiStop() {
        }
    }
}

