/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.PA;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteDynamicSqlRestoreTest
extends GridCommonAbstractTest
implements Serializable {
    public static final String TEST_CACHE_NAME = "test";
    public static final String TEST_INDEX_OBJECT = "TestIndexObject";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setAutoActivationEnabled(false);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testMergeChangedConfigOnCoordinator() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        this.fillTestData((Ignite)ig);
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject add column (c int)")).getAll();
        this.stopAllGrids();
        ig = this.startGrid(1);
        this.startGrid(0);
        ig.cluster().active(true);
        try (IgniteDataStreamer s = ig.dataStreamer(TEST_CACHE_NAME);){
            s.allowOverwrite(true);
            for (int i = 0; i < 50; ++i) {
                s.addData((Object)i, null);
            }
        }
        this.stopAllGrids();
        IgniteEx ig0 = this.startGrid(0);
        IgniteEx ig1 = this.startGrid(1);
        ig0.cluster().active(true);
        try (IgniteDataStreamer s = ig1.dataStreamer(TEST_CACHE_NAME);){
            s.allowOverwrite(true);
            for (int i = 0; i < 50; ++i) {
                BinaryObject bo = ig1.binary().builder(TEST_INDEX_OBJECT).setField("a", (Object)i, Object.class).setField("b", (Object)String.valueOf(i), Object.class).setField("c", (Object)i, Object.class).build();
                s.addData((Object)i, (Object)bo);
            }
        }
        IgniteCache cache2 = ig1.cache(TEST_CACHE_NAME);
        this.assertIndexUsed((IgniteCache<Object, Object>)cache2, "explain select * from TestIndexObject where a > 5", "myindexa");
        IgniteDynamicSqlRestoreTest.assertFalse((boolean)cache2.query(new SqlFieldsQuery("SELECT a,b,c FROM TestIndexObject limit 1")).getAll().isEmpty());
    }

    @Test
    public void testIndexCreationWhenNodeStopped() throws Exception {
        int i2;
        Throwable throwable;
        PreparedStatement stmt2;
        IgniteEx cli;
        this.startGrid(0);
        IgniteEx srv2 = this.startGrid(1);
        Ignition.setClientMode((boolean)true);
        try {
            cli = this.startGrid(2);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        cli.cluster().active(true);
        int entryCnt = 50;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10802");){
            IgniteDynamicSqlRestoreTest.executeJdbc(conn, " CREATE TABLE PERSON (\n FIRST_NAME VARCHAR,\n LAST_NAME VARCHAR,\n ADDRESS VARCHAR,\n LANG VARCHAR,\n BIRTH_DATE TIMESTAMP,\n CONSTRAINT PK_PESON PRIMARY KEY (FIRST_NAME,LAST_NAME,ADDRESS,LANG)\n ) WITH \"key_type=PersonKeyType, CACHE_NAME=PersonCache, value_type=PersonValueType, AFFINITY_KEY=FIRST_NAME,template=PARTITIONED,backups=1\"");
            stmt2 = conn.prepareStatement("insert into Person(LANG, FIRST_NAME, ADDRESS, LAST_NAME, BIRTH_DATE) values(?,?,?,?,?)");
            throwable = null;
            try {
                for (i2 = 0; i2 < entryCnt; ++i2) {
                    String s = String.valueOf(i2);
                    stmt2.setString(1, s);
                    stmt2.setString(2, s);
                    stmt2.setString(3, s);
                    stmt2.setString(4, s);
                    stmt2.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    stmt2.executeUpdate();
                }
            }
            catch (Throwable i2) {
                throwable = i2;
                throw i2;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable i2) {
                            throwable.addSuppressed(i2);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        srv2.close();
        conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10802");
        var5_6 = null;
        try {
            IgniteDynamicSqlRestoreTest.executeJdbc(conn, "create index PERSON_FIRST_NAME_IDX on PERSON(FIRST_NAME)");
        }
        catch (Throwable stmt2) {
            var5_6 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var5_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var5_6.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        this.startGrid(1);
        assert (GridTestUtils.waitForCondition((GridAbsPredicate)new PA(){

            /*
             * Exception decompiling
             */
            public boolean apply() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, (long)5000L));
        conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10802");
        var5_6 = null;
        try {
            stmt2 = conn.prepareStatement("SELECT COUNT(*) FROM Person USE INDEX(PERSON_FIRST_NAME_IDX) WHERE FIRST_NAME=?");
            throwable = null;
            try {
                for (i2 = 0; i2 < entryCnt; ++i2) {
                    stmt2.setString(1, String.valueOf(i2));
                    try (ResultSet rs = stmt2.executeQuery();){
                        rs.next();
                        long cnt = rs.getLong(1);
                        IgniteDynamicSqlRestoreTest.assertEquals((long)1L, (long)cnt);
                        continue;
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var5_6 = throwable4;
            throw throwable4;
        }
        finally {
            if (conn != null) {
                if (var5_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable5) {
                        var5_6.addSuppressed(throwable5);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private static void executeJdbc(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
    }

    @Test
    public void testTakeConfigFromJoiningNodeOnInactiveGrid() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        this.fillTestData((Ignite)ig);
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject add column (c int)")).getAll();
        this.stopAllGrids();
        ig = this.startGrid(1);
        this.startGrid(0);
        ig.cluster().active(true);
        cache = ig.cache(TEST_CACHE_NAME);
        this.assertIndexUsed((IgniteCache<Object, Object>)cache, "explain select * from TestIndexObject where a > 5", "myindexa");
        IgniteDynamicSqlRestoreTest.assertFalse((boolean)cache.query(new SqlFieldsQuery("SELECT a,b,c FROM TestIndexObject limit 1")).getAll().isEmpty());
    }

    @Test
    public void testResaveConfigAfterMerge() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        this.fillTestData((Ignite)ig);
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject add column (c int)")).getAll();
        this.stopAllGrids();
        ig = this.startGrid(1);
        this.startGrid(0);
        ig.cluster().active(true);
        this.stopAllGrids();
        ig = this.startGrid(1);
        ig.cluster().active(true);
        cache = ig.cache(TEST_CACHE_NAME);
        this.assertIndexUsed((IgniteCache<Object, Object>)cache, "explain select * from TestIndexObject where a > 5", "myindexa");
        IgniteDynamicSqlRestoreTest.assertFalse((boolean)cache.query(new SqlFieldsQuery("SELECT a,b,c FROM TestIndexObject limit 1")).getAll().isEmpty());
    }

    @Test
    public void testMergeChangedConfigOnInactiveGrid() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("A", "java.lang.Integer");
        fields.put("B", "java.lang.String");
        CacheConfiguration ccfg = new CacheConfiguration(TEST_CACHE_NAME);
        ccfg.setQueryEntities(Arrays.asList(new QueryEntity().setKeyType("java.lang.Integer").setValueType(TEST_INDEX_OBJECT).setFields(fields)));
        IgniteCache cache = ig.getOrCreateCache(ccfg);
        this.fillTestData((Ignite)ig);
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("drop index myindexb")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject drop column b")).getAll();
        this.stopAllGrids();
        IgniteEx ig0 = this.startGrid(0);
        IgniteEx ig1 = this.startGrid(1);
        ig0.cluster().active(true);
        try (IgniteDataStreamer s = ig1.dataStreamer(TEST_CACHE_NAME);){
            s.allowOverwrite(true);
            for (int i = 0; i < 50; ++i) {
                BinaryObject bo = ig1.binary().builder(TEST_INDEX_OBJECT).setField("a", (Object)i, Object.class).setField("b", (Object)String.valueOf(i), Object.class).build();
                s.addData((Object)i, (Object)bo);
            }
        }
        IgniteCache cache2 = ig1.cache(TEST_CACHE_NAME);
        this.assertIndexUsed((IgniteCache<Object, Object>)cache2, "explain select * from TestIndexObject where a > 5", "myindexa");
        this.assertIndexUsed((IgniteCache<Object, Object>)cache2, "explain select * from TestIndexObject where b > 5", "myindexb");
        IgniteDynamicSqlRestoreTest.assertFalse((boolean)cache2.query(new SqlFieldsQuery("SELECT a,b FROM TestIndexObject limit 1")).getAll().isEmpty());
    }

    private void assertIndexUsed(final IgniteCache<Object, Object> cache, final String sql, final String idx) throws IgniteCheckedException {
        assert (GridTestUtils.waitForCondition((GridAbsPredicate)new PA(){

            public boolean apply() {
                String plan = IgniteDynamicSqlRestoreTest.this.doExplainPlan((IgniteCache<Object, Object>)cache, sql);
                return plan.contains(idx);
            }
        }, (long)10000L));
    }

    @Test
    public void testTakeChangedConfigOnActiveGrid() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        this.fillTestData((Ignite)ig);
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject add column (c int)")).getAll();
        this.stopAllGrids();
        ig = this.startGrid(0);
        ig.cluster().active(true);
        ig = this.startGrid(1);
        try (IgniteDataStreamer s = ig.dataStreamer(TEST_CACHE_NAME);){
            s.allowOverwrite(true);
            for (int i = 0; i < 50; ++i) {
                BinaryObject bo = ig.binary().builder(TEST_INDEX_OBJECT).setField("a", (Object)i, Object.class).setField("b", (Object)String.valueOf(i), Object.class).setField("c", (Object)i, Object.class).build();
                s.addData((Object)i, (Object)bo);
            }
        }
        cache = ig.getOrCreateCache(TEST_CACHE_NAME);
        cache.indexReadyFuture().get();
        this.assertIndexUsed((IgniteCache<Object, Object>)cache, "explain select * from TestIndexObject where a > 5", "myindexa");
        IgniteDynamicSqlRestoreTest.assertFalse((boolean)cache.query(new SqlFieldsQuery("SELECT a,b,c FROM TestIndexObject limit 1")).getAll().isEmpty());
    }

    @Test
    public void testFailJoiningNodeBecauseDifferentSql() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("drop index myindexa")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject drop column b")).getAll();
        cache.query(new SqlFieldsQuery("alter table TestIndexObject add column (b int)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(b)")).getAll();
        this.stopAllGrids();
        this.startGrid(0);
        try {
            this.startGrid(1);
            IgniteDynamicSqlRestoreTest.fail((String)"Node should start with fail");
        }
        catch (Exception e) {
            String cause = ((IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class)).getMessage();
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.containsString((String)"fieldType of B is different"));
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.containsString((String)"index MYINDEXA is different"));
        }
    }

    @Test
    public void testFailJoiningNodeBecauseFieldInlineSizeIsDifferent() throws Exception {
        IgniteEx ig = this.startGrid(0);
        this.startGrid(1);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(this.getTestTableConfiguration());
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a) INLINE_SIZE 100")).getAll();
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("drop index myindexa")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a) INLINE_SIZE 200")).getAll();
        this.stopAllGrids();
        this.startGrid(0);
        try {
            this.startGrid(1);
            IgniteDynamicSqlRestoreTest.fail((String)"Node should start with fail");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)((IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class)).getMessage(), (Matcher)CoreMatchers.containsString((String)"index MYINDEXA is different"));
        }
    }

    @Test
    public void testFailJoiningNodeBecauseNeedConfigUpdateOnActiveGrid() throws Exception {
        this.startGrid(0);
        this.startGrid(1);
        CacheConfiguration<Object, Object> ccfg = this.getTestTableConfiguration();
        Ignite ig = this.ignite(0);
        ig.cluster().active(true);
        IgniteCache cache = ig.getOrCreateCache(ccfg);
        this.fillTestData(ig);
        this.stopGrid(1);
        cache.query(new SqlFieldsQuery("create index myindexa on TestIndexObject(a)")).getAll();
        cache.query(new SqlFieldsQuery("create index myindexb on TestIndexObject(b)")).getAll();
        this.stopGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig2.cluster().active(true);
        try {
            this.startGrid(0);
            IgniteDynamicSqlRestoreTest.fail((String)"Node should start with fail");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)((IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class)).getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to join node to the active cluster"));
        }
    }

    @NotNull
    private String doExplainPlan(IgniteCache<Object, Object> cache, String sql) {
        return ((List)cache.query(new SqlFieldsQuery(sql)).getAll().get(0)).get(0).toString().toLowerCase();
    }

    private void fillTestData(Ignite ig) {
        try (IgniteDataStreamer s = ig.dataStreamer(TEST_CACHE_NAME);){
            for (int i = 0; i < 500; ++i) {
                BinaryObject bo = ig.binary().builder(TEST_INDEX_OBJECT).setField("a", (Object)i, Object.class).setField("b", (Object)String.valueOf(i), Object.class).build();
                s.addData((Object)i, (Object)bo);
            }
        }
    }

    @NotNull
    private CacheConfiguration<Object, Object> getTestTableConfiguration() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", "java.lang.Integer");
        fields.put("B", "java.lang.String");
        CacheConfiguration ccfg = new CacheConfiguration(TEST_CACHE_NAME);
        ccfg.setQueryEntities(Collections.singletonList(new QueryEntity().setKeyType("java.lang.Integer").setValueType(TEST_INDEX_OBJECT).setFields(fields)));
        return ccfg;
    }
}

