/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.CacheException;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteClientReconnectFailoverAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteClientReconnectCacheQueriesFailoverTest
extends IgniteClientReconnectFailoverAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setBackups(1);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteCache cache = this.grid(this.serverCount()).cache("default");
        IgniteClientReconnectCacheQueriesFailoverTest.assertNotNull((Object)cache);
        for (int i = 0; i <= 10000; ++i) {
            cache.put((Object)i, (Object)new Person(i, "name-" + i));
        }
    }

    @Test
    public void testReconnectCacheQueries() throws Exception {
        IgniteEx client = this.grid(this.serverCount());
        final IgniteCache cache = client.cache("default");
        IgniteClientReconnectCacheQueriesFailoverTest.assertNotNull((Object)cache);
        this.reconnectFailover(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SqlQuery sqlQry = new SqlQuery(Person.class, "where id > 1");
                try {
                    Assert.assertEquals((int)9999, (int)cache.query((Query)sqlQry).getAll().size());
                }
                catch (CacheException e) {
                    if (e.getCause() instanceof IgniteClientDisconnectedException) {
                        throw e;
                    }
                    IgniteClientReconnectCacheQueriesFailoverTest.this.log.info("Ignore error: " + (Object)((Object)e));
                }
                try {
                    SqlFieldsQuery fieldsQry = new SqlFieldsQuery("select avg(p.id) from Person p");
                    List res = cache.query(fieldsQry).getAll();
                    Assert.assertEquals((int)1, (int)res.size());
                    Integer avg = (Integer)((List)res.get(0)).get(0);
                    Assert.assertEquals((int)5000, (int)avg);
                }
                catch (CacheException e) {
                    if (e.getCause() instanceof IgniteClientDisconnectedException) {
                        throw e;
                    }
                    IgniteClientReconnectCacheQueriesFailoverTest.this.log.info("Ignore error: " + (Object)((Object)e));
                }
                return null;
            }
        });
    }

    @Test
    public void testReconnectScanQuery() throws Exception {
        int i;
        IgniteEx client = this.grid(this.serverCount());
        final IgniteCache cache = client.cache("default");
        IgniteClientReconnectCacheQueriesFailoverTest.assertNotNull((Object)cache);
        final Affinity aff = client.affinity("default");
        final HashMap<Integer, Integer> partMap = new HashMap<Integer, Integer>();
        for (i = 0; i < aff.partitions(); ++i) {
            partMap.put(i, 0);
        }
        for (i = 0; i <= 10000; ++i) {
            Integer part = aff.partition((Object)i);
            Integer size = (Integer)partMap.get(part);
            partMap.put(part, size + 1);
        }
        this.reconnectFailover(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ScanQuery qry = new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<Integer, Person>(){

                    public boolean apply(Integer key, Person val) {
                        return val.getId() % 2 == 1;
                    }
                });
                Assert.assertEquals((int)5000, (int)cache.query((Query)qry).getAll().size());
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                Integer part = rnd.nextInt(0, aff.partitions());
                qry = new ScanQuery(part.intValue());
                Assert.assertEquals((int)((Integer)partMap.get(part)), (int)cache.query((Query)qry).getAll().size());
                return null;
            }
        });
    }

    public static class Person {
        @QuerySqlField
        public int id;
        @QuerySqlField
        public String name;

        public Person(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.id == ((Person)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

