/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import junit.framework.Assert;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheQueryMultiThreadedSelfTest
extends GridCommonAbstractTest {
    private static final boolean TEST_INFO = true;
    private static final int GRID_CNT = 3;
    private static AtomicInteger idxSwapCnt = new AtomicInteger();
    private static AtomicInteger idxUnswapCnt = new AtomicInteger();
    private static final long DURATION = 30000L;

    public IgniteCacheQueryMultiThreadedSelfTest() {
        super(false);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration()});
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cacheCfg = IgniteCacheQueryMultiThreadedSelfTest.defaultCacheConfiguration();
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setBackups(1);
        LruEvictionPolicy plc = null;
        if (this.evictsEnabled()) {
            plc = new LruEvictionPolicy();
            plc.setMaxSize(100);
        }
        cacheCfg.setEvictionPolicy(plc);
        cacheCfg.setOnheapCacheEnabled(plc != null);
        return cacheCfg;
    }

    protected <K, V> IgniteCache<K, V> cache(Class<K> clsK, Class<V> clsV) {
        return this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), clsK, clsV);
    }

    protected long getTestTimeout() {
        return 90000L;
    }

    protected boolean evictsEnabled() {
        return false;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        for (int i = 0; i < 3; ++i) {
            IgniteCache c = this.grid(i).cache("default");
            IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.size(new CachePeekMode[0]));
        }
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        IgniteCache c;
        int i;
        super.afterTest();
        for (i = 0; i < 3; ++i) {
            for (String cacheName : this.grid(i).cacheNames()) {
                c = this.grid(i).cache(cacheName);
                c.removeAll();
                if (c.size(new CachePeekMode[0]) <= 0) continue;
                for (Cache.Entry e : c.localEntries(new CachePeekMode[0])) {
                    c.remove(e.getKey());
                }
            }
        }
        U.sleep((long)5000L);
        for (i = 0; i < 3; ++i) {
            for (String cacheName : this.grid(i).cacheNames()) {
                c = this.grid(i).cache(cacheName);
                IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.size(new CachePeekMode[]{CachePeekMode.OFFHEAP}));
                IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.size(new CachePeekMode[]{CachePeekMode.PRIMARY}));
                IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.size(new CachePeekMode[0]));
            }
        }
    }

    protected void info(String msg) {
        super.info(msg);
    }

    private Set<UUID> affinityNodes(Iterable<Cache.Entry<Integer, Integer>> entries, Ignite g) {
        HashSet<UUID> nodes = new HashSet<UUID>();
        for (Cache.Entry<Integer, Integer> entry : entries) {
            nodes.add(((ClusterNode)g.affinity("default").mapKeyToPrimaryAndBackups(entry.getKey()).iterator().next()).id());
        }
        return nodes;
    }

    @Test
    public void testMultiThreadedSwapUnswapString() throws Exception {
        int threadCnt = 50;
        int keyCnt = 2000;
        int valCnt = 10000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, String> c = this.cache(Integer.class, String.class);
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)g.cache("default").localSize(new CachePeekMode[0]));
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.query((Query)new SqlQuery(String.class, "1 = 1")).getAll().size());
        Random rnd = new Random();
        for (int i = 0; i < 2000; i += 1 + rnd.nextInt(3)) {
            c.put((Object)i, (Object)String.valueOf(rnd.nextInt(10000)));
            if (!this.evictsEnabled() || !rnd.nextBoolean()) continue;
            c.localEvict(Arrays.asList(i));
        }
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                Random rnd = new Random();
                while (!done.get()) {
                    switch (rnd.nextInt(5)) {
                        case 0: {
                            c.put((Object)rnd.nextInt(2000), (Object)String.valueOf(rnd.nextInt(10000)));
                            break;
                        }
                        case 1: {
                            if (!IgniteCacheQueryMultiThreadedSelfTest.this.evictsEnabled()) break;
                            c.localEvict(Arrays.asList(rnd.nextInt(2000)));
                            break;
                        }
                        case 2: {
                            c.remove((Object)rnd.nextInt(2000));
                            break;
                        }
                        case 3: {
                            c.get((Object)rnd.nextInt(2000));
                            break;
                        }
                        case 4: {
                            int from = rnd.nextInt(10000);
                            c.query((Query)new SqlQuery(String.class, "_val between ? and ?").setArgs(new Object[]{String.valueOf(from), String.valueOf(from + 250)})).getAll();
                        }
                    }
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedSwapUnswapLong() throws Exception {
        int threadCnt = 50;
        int keyCnt = 2000;
        int valCnt = 10000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, Long> c = this.cache(Integer.class, Long.class);
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)g.cache("default").localSize(new CachePeekMode[0]));
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.query((Query)new SqlQuery(Long.class, "1 = 1")).getAll().size());
        Random rnd = new Random();
        for (int i = 0; i < 2000; i += 1 + rnd.nextInt(3)) {
            c.put((Object)i, (Object)rnd.nextInt(10000));
            if (!this.evictsEnabled() || !rnd.nextBoolean()) continue;
            c.localEvict(Arrays.asList(i));
        }
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                Random rnd = new Random();
                while (!done.get()) {
                    int key = rnd.nextInt(2000);
                    switch (rnd.nextInt(5)) {
                        case 0: {
                            c.put((Object)key, (Object)rnd.nextInt(10000));
                            break;
                        }
                        case 1: {
                            if (!IgniteCacheQueryMultiThreadedSelfTest.this.evictsEnabled()) break;
                            c.localEvict(Arrays.asList(key));
                            break;
                        }
                        case 2: {
                            c.remove((Object)key);
                            break;
                        }
                        case 3: {
                            c.get((Object)key);
                            break;
                        }
                        case 4: {
                            int from = rnd.nextInt(10000);
                            c.query((Query)new SqlQuery(Long.class, "_val between ? and ?").setArgs(new Object[]{from, from + 250})).getAll();
                        }
                    }
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedSwapUnswapLongString() throws Exception {
        int threadCnt = 50;
        int keyCnt = 2000;
        int valCnt = 10000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, Object> c = this.cache(Integer.class, Object.class);
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)g.cache("default").size(new CachePeekMode[0]));
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.query((Query)new SqlQuery(Object.class, "1 = 1")).getAll().size());
        Random rnd = new Random();
        for (int i = 0; i < 2000; i += 1 + rnd.nextInt(3)) {
            c.put((Object)i, rnd.nextBoolean() ? Long.valueOf(rnd.nextInt(10000)) : String.valueOf(rnd.nextInt(10000)));
            if (!this.evictsEnabled() || !rnd.nextBoolean()) continue;
            c.localEvict(Arrays.asList(i));
        }
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                Random rnd = new Random();
                while (!done.get()) {
                    int key = rnd.nextInt(2000);
                    switch (rnd.nextInt(5)) {
                        case 0: {
                            c.put((Object)key, rnd.nextBoolean() ? Long.valueOf(rnd.nextInt(10000)) : String.valueOf(rnd.nextInt(10000)));
                            break;
                        }
                        case 1: {
                            if (!IgniteCacheQueryMultiThreadedSelfTest.this.evictsEnabled()) break;
                            c.localEvict(Arrays.asList(key));
                            break;
                        }
                        case 2: {
                            c.remove((Object)key);
                            break;
                        }
                        case 3: {
                            c.get((Object)key);
                            break;
                        }
                        case 4: {
                            int from = rnd.nextInt(10000);
                            c.query((Query)new SqlQuery(Object.class, "_val between ? and ?").setArgs(new Object[]{from, from + 250})).getAll();
                        }
                    }
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedSwapUnswapObject() throws Exception {
        int threadCnt = 50;
        int keyCnt = 4000;
        int valCnt = 10000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, TestValue> c = this.cache(Integer.class, TestValue.class);
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)g.cache("default").localSize(new CachePeekMode[0]));
        IgniteCacheQueryMultiThreadedSelfTest.assertEquals((int)0, (int)c.query((Query)new SqlQuery(TestValue.class, "1 = 1")).getAll().size());
        Random rnd = new Random();
        for (int i = 0; i < 4000; i += 1 + rnd.nextInt(3)) {
            c.put((Object)i, (Object)new TestValue(rnd.nextInt(10000)));
            if (!this.evictsEnabled() || !rnd.nextBoolean()) continue;
            c.localEvict(Arrays.asList(i));
        }
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                Random rnd = new Random();
                while (!done.get()) {
                    int key = rnd.nextInt(4000);
                    switch (rnd.nextInt(5)) {
                        case 0: {
                            c.put((Object)key, (Object)new TestValue(rnd.nextInt(10000)));
                            break;
                        }
                        case 1: {
                            if (!IgniteCacheQueryMultiThreadedSelfTest.this.evictsEnabled()) break;
                            c.localEvict(Arrays.asList(key));
                            break;
                        }
                        case 2: {
                            c.remove((Object)key);
                            break;
                        }
                        case 3: {
                            c.get((Object)key);
                            break;
                        }
                        case 4: {
                            int from = rnd.nextInt(10000);
                            c.query((Query)new SqlQuery(TestValue.class, "TestValue.val between ? and ?").setArgs(new Object[]{from, from + 250})).getAll();
                        }
                    }
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedSameQuery() throws Exception {
        int threadCnt = 50;
        int keyCnt = 10;
        int logMod = 5000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, Integer> c = this.cache(Integer.class, Integer.class);
        for (int i = 0; i < 10; ++i) {
            c.put((Object)i, (Object)i);
            c.localEvict(Arrays.asList(i));
        }
        AtomicInteger cnt = new AtomicInteger();
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX((Ignite)g, cnt){
            final /* synthetic */ Ignite val$g;
            final /* synthetic */ AtomicInteger val$cnt;
            {
                this.val$g = ignite;
                this.val$cnt = atomicInteger;
            }

            public void applyx() throws IgniteCheckedException {
                int iter = 0;
                while (!done.get() && !Thread.currentThread().isInterrupted()) {
                    ++iter;
                    List entries = c.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll();
                    assert (entries != null);
                    Assert.assertEquals((String)("Query results [entries=" + entries + ", aff=" + IgniteCacheQueryMultiThreadedSelfTest.this.affinityNodes(entries, this.val$g) + ", iteration=" + iter + ']'), (int)10, (int)entries.size());
                    if (this.val$cnt.incrementAndGet() % 5000 != 0) continue;
                    GridCacheQueryManager qryMgr = ((IgniteKernal)this.val$g).internalCache(c.getName()).context().queries();
                    assert (qryMgr != null);
                    qryMgr.printMemoryStats();
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        this.info("Finishing test...");
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedNewQueries() throws Exception {
        int threadCnt = 50;
        int keyCnt = 10;
        int logMod = 5000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, Integer> c = this.cache(Integer.class, Integer.class);
        for (int i = 0; i < 10; ++i) {
            c.put((Object)i, (Object)i);
            c.localEvict(Arrays.asList(i));
        }
        final AtomicInteger cnt = new AtomicInteger();
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX((Ignite)g){
            final /* synthetic */ Ignite val$g;
            {
                this.val$g = ignite;
            }

            public void applyx() throws IgniteCheckedException {
                int iter = 0;
                while (!done.get() && !Thread.currentThread().isInterrupted()) {
                    ++iter;
                    List entries = c.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll();
                    assert (entries != null);
                    Assert.assertEquals((String)("Entries count is not as expected on iteration: " + iter), (int)10, (int)entries.size());
                    if (cnt.incrementAndGet() % 5000 != 0) continue;
                    GridCacheQueryManager qryMgr = ((IgniteKernal)this.val$g).internalCache(c.getName()).context().queries();
                    assert (qryMgr != null);
                    qryMgr.printMemoryStats();
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedScanQuery() throws Exception {
        int threadCnt = 50;
        int keyCnt = 500;
        int logMod = 5000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, Integer> c = this.cache(Integer.class, Integer.class);
        for (int i = 0; i < 500; ++i) {
            c.put((Object)i, (Object)i);
        }
        final AtomicInteger cnt = new AtomicInteger();
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX((Ignite)g){
            final /* synthetic */ Ignite val$g;
            {
                this.val$g = ignite;
            }

            public void applyx() throws IgniteCheckedException {
                int iter = 0;
                while (!done.get() && !Thread.currentThread().isInterrupted()) {
                    ++iter;
                    List entries = c.query((Query)new ScanQuery()).getAll();
                    assert (entries != null);
                    Assert.assertEquals((String)("Entries count is not as expected on iteration: " + iter), (int)500, (int)entries.size());
                    if (cnt.incrementAndGet() % 5000 != 0) continue;
                    GridCacheQueryManager qryMgr = ((IgniteKernal)this.val$g).internalCache(c.getName()).context().queries();
                    assert (qryMgr != null);
                    qryMgr.printMemoryStats();
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    @Test
    public void testMultiThreadedSqlFieldsQuery() throws Throwable {
        int threadCnt = 16;
        int keyCnt = 1100;
        int logMod = 5000;
        IgniteEx g = this.grid(0);
        final IgniteCache<Integer, TestValue> c = this.cache(Integer.class, TestValue.class);
        for (int i = 0; i < 1100; ++i) {
            c.put((Object)i, (Object)new TestValue(i));
        }
        final AtomicInteger cnt = new AtomicInteger();
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX((Ignite)g){
            final /* synthetic */ Ignite val$g;
            {
                this.val$g = ignite;
            }

            public void applyx() throws IgniteCheckedException {
                int iter = 0;
                while (!done.get() && !Thread.currentThread().isInterrupted()) {
                    ++iter;
                    List entries = c.query(new SqlFieldsQuery("SELECT * from TestValue").setPageSize(100)).getAll();
                    assert (entries != null);
                    Assert.assertEquals((String)("Entries count is not as expected on iteration: " + iter), (int)1100, (int)entries.size());
                    if (cnt.incrementAndGet() % 5000 != 0) continue;
                    GridCacheQueryManager qryMgr = ((IgniteKernal)this.val$g).internalCache("default").context().queries();
                    assert (qryMgr != null);
                    qryMgr.printMemoryStats();
                }
            }
        }, threadCnt);
        Thread.sleep(30000L);
        done.set(true);
        fut.get();
    }

    private static class TestValue
    implements Serializable {
        @QuerySqlField(index=true)
        private int val;

        private TestValue(int val) {
            this.val = val;
        }

        public int value() {
            return this.val;
        }
    }
}

