/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCachePartitionedQueryMultiThreadedSelfTest
extends GridCommonAbstractTest {
    private static final boolean TEST_INFO = true;
    private static final int GRID_CNT = 3;

    public IgniteCachePartitionedQueryMultiThreadedSelfTest() {
        super(false);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cc = IgniteCachePartitionedQueryMultiThreadedSelfTest.defaultCacheConfiguration();
        cc.setCacheMode(CacheMode.PARTITIONED);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setBackups(0);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setIndexedTypes(new Class[]{UUID.class, PersonObj.class});
        c.setCacheConfiguration(new CacheConfiguration[]{cc});
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (int i = 0; i < 3; ++i) {
            this.grid(i).cache("default").removeAll();
        }
    }

    protected void info(String msg) {
        super.info(msg);
    }

    @Test
    public void testLuceneAndSqlMultithreaded() throws Exception {
        int luceneThreads = 10;
        int sqlThreads = 10;
        long duration = 10000L;
        int logMod = 100;
        final PersonObj p1 = new PersonObj("Jon", 1500, "Master");
        final PersonObj p2 = new PersonObj("Jane", 2000, "Master");
        final PersonObj p3 = new PersonObj("Mike", 1800, "Bachelor");
        final PersonObj p4 = new PersonObj("Bob", 1900, "Bachelor");
        final IgniteCache cache0 = this.grid(0).cache("default");
        cache0.put((Object)p1.id(), (Object)p1);
        cache0.put((Object)p2.id(), (Object)p2);
        cache0.put((Object)p3.id(), (Object)p3);
        cache0.put((Object)p4.id(), (Object)p4);
        IgniteCachePartitionedQueryMultiThreadedSelfTest.assertEquals((int)4, (int)cache0.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        assert (this.grid(0).cluster().nodes().size() == 3);
        final AtomicBoolean done = new AtomicBoolean();
        final AtomicLong luceneCnt = new AtomicLong();
        IgniteInternalFuture futLucene = GridTestUtils.runMultiThreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                while (!done.get()) {
                    QueryCursor master = cache0.query((Query)new TextQuery(PersonObj.class, "Master"));
                    List entries = master.getAll();
                    IgniteCachePartitionedQueryMultiThreadedSelfTest.this.checkResult(entries, new PersonObj[]{p1, p2});
                    long cnt = luceneCnt.incrementAndGet();
                    if (cnt % 100L != 0L) continue;
                    IgniteCachePartitionedQueryMultiThreadedSelfTest.this.info("Executed LUCENE queries: " + cnt);
                }
            }
        }, (int)luceneThreads, (String)"LUCENE-THREAD");
        final AtomicLong sqlCnt = new AtomicLong();
        IgniteInternalFuture futSql = GridTestUtils.runMultiThreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                while (!done.get()) {
                    QueryCursor bachelors = cache0.query((Query)new SqlQuery(PersonObj.class, "degree = 'Bachelor'"));
                    List entries = bachelors.getAll();
                    IgniteCachePartitionedQueryMultiThreadedSelfTest.this.checkResult(entries, new PersonObj[]{p3, p4});
                    long cnt = sqlCnt.incrementAndGet();
                    if (cnt % 100L != 0L) continue;
                    IgniteCachePartitionedQueryMultiThreadedSelfTest.this.info("Executed SQL queries: " + cnt);
                }
            }
        }, (int)sqlThreads, (String)"SQL-THREAD");
        Thread.sleep(duration);
        done.set(true);
        futLucene.get();
        futSql.get();
    }

    private void checkResult(Iterable<Cache.Entry<UUID, PersonObj>> entries, PersonObj ... persons) {
        for (Cache.Entry<UUID, PersonObj> entry : entries) {
            IgniteCachePartitionedQueryMultiThreadedSelfTest.assertEquals((Object)entry.getKey(), (Object)((PersonObj)entry.getValue()).id());
            assert (F.asList((Object[])persons).contains(entry.getValue()));
        }
    }

    private static class PersonObj {
        @GridToStringExclude
        private UUID id = UUID.randomUUID();
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int salary;
        @QuerySqlField
        @QueryTextField
        private String degree;

        public PersonObj() {
        }

        PersonObj(String name, int salary, String degree) {
            assert (name != null);
            assert (salary > 0);
            assert (degree != null);
            this.name = name;
            this.salary = salary;
            this.degree = degree;
        }

        UUID id() {
            return this.id;
        }

        String name() {
            return this.name;
        }

        double salary() {
            return this.salary;
        }

        String degree() {
            return this.degree;
        }

        public int hashCode() {
            return this.id.hashCode() + 31 * this.name.hashCode() + 961 * this.salary;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PersonObj)) {
                return false;
            }
            PersonObj that = (PersonObj)obj;
            return that.id.equals(this.id) && that.name.equals(this.name) && that.salary == this.salary && that.degree.equals(this.degree);
        }

        public String toString() {
            return S.toString(PersonObj.class, (Object)this);
        }
    }
}

