/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheP2pUnmarshallingErrorTest;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheP2pUnmarshallingQueryErrorTest
extends IgniteCacheP2pUnmarshallingErrorTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (cfg.getCacheConfiguration().length > 0) {
            cfg.getCacheConfiguration()[0].setIndexedTypes(new Class[]{IgniteCacheP2pUnmarshallingErrorTest.TestKey.class, String.class});
        }
        return cfg;
    }

    @Test
    public void testResponseMessageOnUnmarshallingFailed() {
        readCnt.set(Integer.MAX_VALUE);
        this.jcache(0).put((Object)new IgniteCacheP2pUnmarshallingErrorTest.TestKey(String.valueOf(++key)), (Object)"");
        readCnt.set(1);
        try {
            this.jcache(0).query((Query)new SqlQuery(String.class, "field like '" + key + "'")).getAll();
            IgniteCacheP2pUnmarshallingQueryErrorTest.fail((String)"p2p marshalling failed, but error response was not sent");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseMessageOnRequestUnmarshallingFailed() throws Exception {
        readCnt.set(Integer.MAX_VALUE);
        try {
            this.jcache().query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<IgniteCacheP2pUnmarshallingErrorTest.TestKey, String>(){

                public boolean apply(IgniteCacheP2pUnmarshallingErrorTest.TestKey key, String val) {
                    return false;
                }

                private void readObject(ObjectInputStream is) throws IOException {
                    throw new IOException();
                }

                private void writeObject(ObjectOutputStream os) throws IOException {
                }
            })).getAll();
            IgniteCacheP2pUnmarshallingQueryErrorTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

