/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheObjectKeyIndexingSelfTest
extends GridCommonAbstractTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid();
    }

    protected void afterTestsStopped() throws Exception {
        Ignition.stopAll((boolean)true);
    }

    protected static CacheConfiguration<Object, TestObject> cacheCfg() {
        return new CacheConfiguration("default").setIndexedTypes(new Class[]{Object.class, TestObject.class});
    }

    @Test
    public void testObjectKeyHandling() throws Exception {
        IgniteEx ignite = this.grid();
        IgniteCache cache = ignite.getOrCreateCache(IgniteCacheObjectKeyIndexingSelfTest.cacheCfg());
        UUID uid = UUID.randomUUID();
        cache.put((Object)uid, (Object)new TestObject("A"));
        this.assertItemsNumber(1L);
        cache.put((Object)1, (Object)new TestObject("B"));
        this.assertItemsNumber(2L);
        cache.put((Object)uid, (Object)new TestObject("C"));
        this.assertItemsNumber(2L);
        List res = cache.query(new SqlFieldsQuery("select _key, name from TestObject order by name")).getAll();
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)res, Arrays.asList(Arrays.asList(1, "B"), Arrays.asList(uid, "C")));
        cache.remove((Object)1);
        this.assertItemsNumber(1L);
        res = cache.query(new SqlFieldsQuery("select _key, name from TestObject")).getAll();
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)res, Collections.singletonList(Arrays.asList(uid, "C")));
        cache.remove((Object)uid);
        this.assertItemsNumber(0L);
    }

    private void assertItemsNumber(long num) {
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((long)num, (long)this.grid().cachex("default").size());
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)num, ((List)this.grid().cache("default").query(new SqlFieldsQuery("select count(*) from TestObject")).getAll().get(0)).get(0));
    }

    private static class TestObject {
        @QuerySqlField
        public final String name;

        private TestObject(String name) {
            this.name = name;
        }
    }
}

