/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheLockPartitionOnAffinityRunAbstractTest;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.collision.CollisionContext;
import org.apache.ignite.spi.collision.CollisionExternalListener;
import org.apache.ignite.spi.collision.CollisionJobContext;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLockPartitionOnAffinityRunWithCollisionSpiTest
extends IgniteCacheLockPartitionOnAffinityRunAbstractTest {
    private static volatile boolean cancelAllJobs = false;

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        AlwaysCancelCollisionSpi colSpi = new AlwaysCancelCollisionSpi();
        cfg.setCollisionSpi((CollisionSpi)colSpi);
        return cfg;
    }

    @Test
    public void testPartitionReservation() throws Exception {
        int orgId = 0;
        cancelAllJobs = true;
        try {
            this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteRunnable)new TestRun(orgId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cancelAllJobs = false;
        ClusterNode n = this.grid(0).context().affinity().mapKeyToNode(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), (Object)orgId);
        IgniteCacheLockPartitionOnAffinityRunWithCollisionSpiTest.checkPartitionsReservations((IgniteEx)this.grid(n), orgId, 0);
    }

    @Test
    public void testJobFinishing() throws Exception {
        final AtomicInteger jobNum = new AtomicInteger(0);
        cancelAllJobs = true;
        IgniteInternalFuture affFut = null;
        try {
            affFut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    block2: while (System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                        int n = 0;
                        try {
                            for (int orgId : IgniteCacheLockPartitionOnAffinityRunAbstractTest.orgIds) {
                                if (System.currentTimeMillis() >= IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) continue block2;
                                n = jobNum.getAndIncrement();
                                IgniteCacheLockPartitionOnAffinityRunWithCollisionSpiTest.this.log.info("+++ Job submitted " + n);
                                IgniteCacheLockPartitionOnAffinityRunWithCollisionSpiTest.this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteRunnable)new TestRun(n));
                            }
                        }
                        catch (Exception e) {
                            IgniteCacheLockPartitionOnAffinityRunWithCollisionSpiTest.this.log.info("+++ Job failed " + n + " " + e.toString());
                        }
                    }
                }
            }, (int)10, (String)"affinity-run");
        }
        finally {
            if (affFut != null) {
                affFut.get();
            }
            this.stopRestartThread.set(true);
            cancelAllJobs = false;
            this.awaitPartitionMapExchange();
        }
    }

    @IgniteSpiMultipleInstancesSupport(value=true)
    public static class AlwaysCancelCollisionSpi
    extends IgniteSpiAdapter
    implements CollisionSpi {
        @LoggerResource
        private IgniteLogger log;

        public void onCollision(CollisionContext ctx) {
            Collection waitJobs = ctx.waitingJobs();
            if (cancelAllJobs) {
                for (CollisionJobContext job : waitJobs) {
                    job.cancel();
                }
            } else {
                for (CollisionJobContext job : waitJobs) {
                    job.activate();
                }
            }
        }

        public void spiStart(String igniteInstanceName) throws IgniteSpiException {
            this.startStopwatch();
        }

        public void spiStop() throws IgniteSpiException {
        }

        public void setExternalCollisionListener(CollisionExternalListener lsnr) {
        }
    }

    private static class TestRun
    implements IgniteRunnable {
        private int jobNum;
        @LoggerResource
        private IgniteLogger log;

        public TestRun() {
        }

        public TestRun(int jobNum) {
            this.jobNum = jobNum;
        }

        public void run() {
        }
    }
}

