/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.compute.ComputeJobMasterLeaveAware;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheLockPartitionOnAffinityRunAbstractTest;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLockPartitionOnAffinityRunTest
extends IgniteCacheLockPartitionOnAffinityRunAbstractTest {
    private static int getPersonsCountFromPartitionMapCheckBothCaches(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
        IgniteCacheLockPartitionOnAffinityRunTest.assertEquals((int)1, (int)IgniteCacheLockPartitionOnAffinityRunTest.getOrganizationCountFromPartitionMap(ignite, orgId));
        return IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountFromPartitionMap(ignite, orgId);
    }

    private static int getOrganizationCountFromPartitionMap(IgniteEx ignite, int orgId) throws Exception {
        int part = ignite.affinity(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()).partition((Object)orgId);
        GridCacheAdapter cacheAdapterOrg = ignite.context().cache().internalCache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName());
        GridDhtLocalPartition pOrgs = cacheAdapterOrg.context().topology().localPartition(part, AffinityTopologyVersion.NONE, false);
        int cnt = 0;
        GridCursor c = pOrgs.dataStore().cursor();
        CacheObjectContext ctx = cacheAdapterOrg.context().cacheObjectContext();
        while (c.next()) {
            CacheDataRow e = (CacheDataRow)c.get();
            Integer k = (Integer)e.key().value((CacheObjectValueContext)ctx, false);
            IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization org = (IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization)e.value().value((CacheObjectValueContext)ctx, false);
            if (org == null || org.getId() != orgId) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int getPersonsCountFromPartitionMap(IgniteEx ignite, int orgId) throws Exception {
        int part = ignite.affinity(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()).partition((Object)orgId);
        GridCacheAdapter cacheAdapterPers = ignite.context().cache().internalCache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName());
        GridDhtLocalPartition pPers = cacheAdapterPers.context().topology().localPartition(part, AffinityTopologyVersion.NONE, false);
        int cnt = 0;
        GridCursor c = pPers.dataStore().cursor();
        CacheObjectContext ctx = cacheAdapterPers.context().cacheObjectContext();
        while (c.next()) {
            CacheDataRow e = (CacheDataRow)c.get();
            IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.Key k = (IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.Key)e.key().value((CacheObjectValueContext)ctx, false);
            IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person p = (IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person)e.value().value((CacheObjectValueContext)ctx, false);
            if (p == null || p.getOrgId() != orgId || k.orgId != orgId) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int getPersonsCountBySqlFieldLocalQuery(IgniteEx ignite, int orgId) {
        List res = ignite.cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()).query(new SqlFieldsQuery(String.format("SELECT p.id FROM \"%s\".Person as p WHERE p.orgId = " + orgId, IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName())).setLocal(true)).getAll();
        return res.size();
    }

    private static int getPersonsCountBySqlFieledLocalQueryJoinOrgs(IgniteEx ignite, int orgId) {
        List res = ignite.cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()).query(new SqlFieldsQuery(String.format("SELECT p.id FROM \"%s\".Person as p, \"%s\".Organization as o WHERE p.orgId = o.id AND p.orgId = " + orgId, IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName())).setLocal(true)).getAll();
        return res.size();
    }

    private static int getPersonsCountBySqlLocalQuery(IgniteEx ignite, int orgId) {
        List res = ignite.cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()).query((Query)new SqlQuery(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class, "orgId = ?").setArgs(new Object[]{orgId}).setLocal(true)).getAll();
        return res.size();
    }

    private static int getPersonsCountByScanLocalQuery(IgniteEx ignite, final int orgId) {
        List res = ignite.cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()).query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.Key, IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person>(){

            public boolean apply(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.Key key, IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person person) {
                return person.getOrgId() == orgId;
            }
        }).setLocal(true)).getAll();
        return res.size();
    }

    private static boolean primaryPartition(IgniteEx ignite, int orgId) {
        int part = ignite.affinity(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()).partition((Object)orgId);
        GridCacheAdapter cacheAdapterPers = ignite.context().cache().internalCache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName());
        GridDhtLocalPartition pPers = cacheAdapterPers.context().topology().localPartition(part, AffinityTopologyVersion.NONE, false);
        return pPers.primary(AffinityTopologyVersion.NONE);
    }

    private static int getPersonsCountSingleCache(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
        int sqlCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountBySqlLocalQuery(ignite, orgId);
        int sqlFieldCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountBySqlFieldLocalQuery(ignite, orgId);
        int scanCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountByScanLocalQuery(ignite, orgId);
        int partCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountFromPartitionMap(ignite, orgId);
        IgniteCacheLockPartitionOnAffinityRunTest.assertEquals((int)10000, (int)partCnt);
        IgniteCacheLockPartitionOnAffinityRunTest.assertEquals((int)partCnt, (int)scanCnt);
        if (partCnt != sqlFieldCnt) {
            IgniteCacheLockPartitionOnAffinityRunTest.assertFalse((String)("Partition is primary, but size check failed [expected=" + partCnt + ", actual=" + sqlFieldCnt + ']'), (boolean)IgniteCacheLockPartitionOnAffinityRunTest.primaryPartition(ignite, orgId));
        }
        if (partCnt != sqlCnt) {
            IgniteCacheLockPartitionOnAffinityRunTest.assertFalse((String)("Partition is primary, but size check failed [expected=" + partCnt + ", actual=" + sqlCnt + ']'), (boolean)IgniteCacheLockPartitionOnAffinityRunTest.primaryPartition(ignite, orgId));
        }
        return partCnt;
    }

    private static int getPersonsCountMultipleCache(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
        int sqlFieldCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountBySqlFieledLocalQueryJoinOrgs(ignite, orgId);
        int partCnt = IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountFromPartitionMapCheckBothCaches(ignite, log, orgId);
        IgniteCacheLockPartitionOnAffinityRunTest.assertEquals((int)partCnt, (int)sqlFieldCnt);
        return partCnt;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.grid(0).compute().affinityCall(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()), 0, (IgniteCallable)new TestAffinityCall(new PersonsCountGetter(){

            @Override
            public int getPersonsCount(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
                return 10000;
            }
        }, 0));
        this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()), 0, (IgniteRunnable)new TestAffinityRun(new PersonsCountGetter(){

            @Override
            public int getPersonsCount(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
                return 10000;
            }
        }, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-7692")
    @Test
    public void testSingleCache() throws Exception {
        final PersonsCountGetter personsCntGetter = new PersonsCountGetter(){

            @Override
            public int getPersonsCount(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
                return IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountSingleCache(ignite, log, orgId);
            }
        };
        this.beginNodesRestart();
        IgniteInternalFuture affFut = null;
        try {
            final AtomicInteger threadNum = new AtomicInteger(0);
            affFut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (threadNum.getAndIncrement() % 2 == 0) {
                        block0: while (System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                            for (int orgId : IgniteCacheLockPartitionOnAffinityRunAbstractTest.orgIds) {
                                if (System.currentTimeMillis() >= IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) continue block0;
                                IgniteCacheLockPartitionOnAffinityRunTest.this.grid(0).compute().affinityRun(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), (Object)new IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person(0, orgId).createKey(), (IgniteRunnable)new TestAffinityRun(personsCntGetter, orgId));
                            }
                        }
                    } else {
                        block2: while (System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                            for (int orgId : IgniteCacheLockPartitionOnAffinityRunAbstractTest.orgIds) {
                                if (System.currentTimeMillis() >= IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) continue block2;
                                int personsCnt = (Integer)IgniteCacheLockPartitionOnAffinityRunTest.this.grid(0).compute().affinityCall(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), (Object)new IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person(0, orgId).createKey(), (IgniteCallable)new TestAffinityCall(personsCntGetter, orgId));
                                Assert.assertEquals((int)10000, (int)personsCnt);
                            }
                        }
                    }
                }
            }, (int)10, (String)"affinity-run");
        }
        finally {
            if (affFut != null) {
                affFut.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCaches() throws Exception {
        final PersonsCountGetter personsCntGetter = new PersonsCountGetter(){

            @Override
            public int getPersonsCount(IgniteEx ignite, IgniteLogger log, int orgId) throws Exception {
                return IgniteCacheLockPartitionOnAffinityRunTest.getPersonsCountMultipleCache(ignite, log, orgId);
            }
        };
        this.beginNodesRestart();
        IgniteInternalFuture affFut = null;
        try {
            final AtomicInteger threadNum = new AtomicInteger(0);
            affFut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (threadNum.getAndIncrement() % 2 == 0) {
                        block0: while (System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                            for (int orgId : IgniteCacheLockPartitionOnAffinityRunAbstractTest.orgIds) {
                                if (System.currentTimeMillis() >= IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) continue block0;
                                IgniteCacheLockPartitionOnAffinityRunTest.this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteRunnable)new TestAffinityRun(personsCntGetter, orgId));
                            }
                        }
                    } else {
                        block2: while (System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                            for (int orgId : IgniteCacheLockPartitionOnAffinityRunAbstractTest.orgIds) {
                                if (System.currentTimeMillis() >= IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) continue block2;
                                int personsCnt = (Integer)IgniteCacheLockPartitionOnAffinityRunTest.this.grid(0).compute().affinityCall(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteCallable)new TestAffinityCall(personsCntGetter, orgId));
                                Assert.assertEquals((int)10000, (int)personsCnt);
                            }
                        }
                    }
                }
            }, (int)10, (String)"affinity-run");
        }
        finally {
            if (affFut != null) {
                affFut.get();
            }
        }
    }

    @Test
    public void testCheckReservePartitionException() throws Exception {
        final int orgId = this.primaryKey(this.grid(1).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgniteCacheLockPartitionOnAffinityRunTest.this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), "otherCache"), (Object)new Integer(orgId), new IgniteRunnable(){

                    public void run() {
                    }
                });
                return null;
            }
        }, IgniteException.class, (String)"Failed partition reservation. Partition is not primary on the node.");
    }

    @Test
    public void testReleasePartitionJobCompletesNormally() throws Exception {
        final int orgId = this.primaryKey(this.grid(1).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), new IgniteRunnable(){
            @IgniteInstanceResource
            IgniteEx ignite;

            public void run() {
                try {
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Unexpected exception");
                }
            }
        });
        IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        this.grid(0).compute().affinityCall(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteCallable)new IgniteCallable<Object>(){
            @IgniteInstanceResource
            IgniteEx ignite;

            public Object call() {
                try {
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Unexpected exception");
                }
                return null;
            }
        });
        IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
    }

    @Test
    public void testReleasePartitionJobThrowsException() throws Exception {
        final int orgId = this.primaryKey(this.grid(1).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        try {
            this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), new IgniteRunnable(){
                @IgniteInstanceResource
                IgniteEx ignite;

                public void run() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    throw new RuntimeException("Test job throws exception");
                }
            });
            IgniteCacheLockPartitionOnAffinityRunTest.fail((String)"Exception must be thrown");
        }
        catch (Exception ignored) {
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        }
        try {
            this.grid(0).compute().affinityCall(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteCallable)new IgniteCallable<Object>(){
                @IgniteInstanceResource
                IgniteEx ignite;

                public Object call() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    throw new RuntimeException("Test job throws exception");
                }
            });
            IgniteCacheLockPartitionOnAffinityRunTest.fail((String)"Exception must be thrown");
        }
        catch (Exception ignored) {
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        }
    }

    @Test
    public void testReleasePartitionJobThrowsError() throws Exception {
        final int orgId = this.primaryKey(this.grid(1).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        try {
            this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), new IgniteRunnable(){
                @IgniteInstanceResource
                IgniteEx ignite;

                public void run() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    throw new Error("Test job throws error");
                }
            });
            IgniteCacheLockPartitionOnAffinityRunTest.fail((String)"Error must be thrown");
        }
        catch (Throwable ignored) {
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        }
        try {
            this.grid(0).compute().affinityCall(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteCallable)new IgniteCallable<Object>(){
                @IgniteInstanceResource
                IgniteEx ignite;

                public Object call() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations(this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    throw new Error("Test job throws error");
                }
            });
            IgniteCacheLockPartitionOnAffinityRunTest.fail((String)"Error must be thrown");
        }
        catch (Throwable ignored) {
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        }
    }

    @Test
    public void testReleasePartitionJobUnmarshalingFails() throws Exception {
        int orgId = this.primaryKey(this.grid(1).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        try {
            this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteRunnable)new JobFailUnmarshaling());
            IgniteCacheLockPartitionOnAffinityRunTest.fail((String)"Unmarshaling exception must be thrown");
        }
        catch (Exception ignored) {
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(1), orgId, 0);
        }
    }

    @Test
    public void testReleasePartitionJobMasterLeave() throws Exception {
        final int orgId = this.primaryKey(this.grid(0).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        try {
            this.grid(1).compute().affinityRunAsync(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), new IgniteRunnable(){
                @IgniteInstanceResource
                private Ignite ignite;

                public void run() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations((IgniteEx)this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.stopGrid(1, true);
            Thread.sleep(3000L);
            this.awaitPartitionMapExchange();
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(0), orgId, 0);
        }
        finally {
            this.startGrid(1);
            this.awaitPartitionMapExchange();
        }
        try {
            this.grid(1).compute().affinityCallAsync(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteCallable)new IgniteCallable<Object>(){
                @IgniteInstanceResource
                private Ignite ignite;

                public Object call() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations((IgniteEx)this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            this.stopGrid(1, true);
            Thread.sleep(3000L);
            this.awaitPartitionMapExchange();
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(0), orgId, 0);
        }
        finally {
            this.startGrid(1);
            this.awaitPartitionMapExchange();
        }
    }

    @Test
    public void testReleasePartitionJobImplementMasterLeave() throws Exception {
        final int orgId = this.primaryKey(this.grid(0).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()));
        try {
            this.grid(1).compute().affinityRunAsync(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(orgId), (IgniteRunnable)new RunnableWithMasterLeave(){
                @IgniteInstanceResource
                private Ignite ignite;

                public void onMasterNodeLeft(ComputeTaskSession ses) throws IgniteException {
                }

                public void run() {
                    try {
                        IgniteCacheLockPartitionOnAffinityRunAbstractTest.checkPartitionsReservations((IgniteEx)this.ignite, orgId, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected exception");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.stopGrid(1, true);
            Thread.sleep(3000L);
            this.awaitPartitionMapExchange();
            IgniteCacheLockPartitionOnAffinityRunTest.checkPartitionsReservations(this.grid(0), orgId, 0);
        }
        finally {
            this.startGrid(1);
            this.awaitPartitionMapExchange();
        }
    }

    static class JobFailUnmarshaling
    implements Externalizable,
    IgniteRunnable {
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new IOException("Test job unmarshaling fails");
        }

        public void run() {
            Assert.fail((String)"Must not be executed");
        }
    }

    private static class TestAffinityRun
    implements IgniteRunnable {
        PersonsCountGetter personsCntGetter;
        int orgId;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;

        public TestAffinityRun() {
        }

        public TestAffinityRun(PersonsCountGetter personsCntGetter, int orgId) {
            this.personsCntGetter = personsCntGetter;
            this.orgId = orgId;
        }

        public void run() {
            try {
                this.log.info("Begin run. orgId=" + this.orgId);
                int cnt = this.personsCntGetter.getPersonsCount(this.ignite, this.log, this.orgId);
                Assert.assertEquals((int)10000, (int)cnt);
            }
            catch (Exception e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    private static class TestAffinityCall
    implements IgniteCallable<Integer> {
        PersonsCountGetter personsCntGetter;
        int orgId;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;

        public TestAffinityCall() {
        }

        public TestAffinityCall(PersonsCountGetter personsCntGetter, int orgId) {
            this.personsCntGetter = personsCntGetter;
            this.orgId = orgId;
        }

        public Integer call() throws Exception {
            this.log.info("Begin call. orgId=" + this.orgId);
            return this.personsCntGetter.getPersonsCount(this.ignite, this.log, this.orgId);
        }
    }

    static interface RunnableWithMasterLeave
    extends IgniteRunnable,
    ComputeJobMasterLeaveAware {
    }

    private static interface PersonsCountGetter {
        public int getPersonsCount(IgniteEx var1, IgniteLogger var2, int var3) throws Exception;
    }
}

