/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheLockPartitionOnAffinityRunAbstractTest;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest
extends IgniteCacheLockPartitionOnAffinityRunAbstractTest {
    private static final String ATOMIC_CACHE = "atomic";
    private static final String TRANSACT_CACHE = "transact";
    private static final long TEST_TIMEOUT = 600000L;
    private static int KEYS_CNT = 100;
    private static int PARTS_CNT = 16;
    private static AtomicInteger key = new AtomicInteger(0);

    @Override
    protected long getTestTimeout() {
        return 600000L;
    }

    @Override
    protected void beginNodesRestart() {
        this.stopRestartThread.set(false);
        nodeRestartFut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.stopRestartThread.get() && System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime) {
                    int i;
                    IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.log.info("Restart nodes");
                    for (i = 2; i < 4; ++i) {
                        IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.stopGrid(i);
                    }
                    Thread.sleep(500L);
                    for (i = 2; i < 4; ++i) {
                        IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.startGrid(i);
                    }
                    GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                        public boolean apply() {
                            return !IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.stopRestartThread.get();
                        }
                    }, (long)3000L);
                }
                return null;
            }
        }, (String)"restart-node");
    }

    protected CacheConfiguration cacheConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = super.cacheConfiguration(igniteInstanceName);
        ccfg.setBackups(0);
        return ccfg;
    }

    protected void createCache(String cacheName, CacheAtomicityMode mode) throws Exception {
        CacheConfiguration ccfg = this.cacheConfiguration(this.grid(0).name());
        ccfg.setName(cacheName);
        ccfg.setAtomicityMode(mode);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, PARTS_CNT));
        this.grid(0).createCache(ccfg);
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.createCaches();
        this.awaitPartitionMapExchange();
    }

    protected void createCaches() throws Exception {
        key.set(0);
        this.createCache(ATOMIC_CACHE, CacheAtomicityMode.ATOMIC);
        this.createCache(TRANSACT_CACHE, CacheAtomicityMode.TRANSACTIONAL);
    }

    protected void destroyCaches() throws Exception {
        this.grid(0).destroyCache(ATOMIC_CACHE);
        this.grid(0).destroyCache(TRANSACT_CACHE);
    }

    @Override
    protected void afterTest() throws Exception {
        this.destroyCaches();
        super.afterTest();
    }

    @Test
    public void testNotReservedAtomicCacheOp() throws Exception {
        this.notReservedCacheOp(ATOMIC_CACHE);
    }

    @Test
    public void testNotReservedTxCacheOp() throws Exception {
        this.notReservedCacheOp(TRANSACT_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notReservedCacheOp(final String cacheName) throws Exception {
        this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()), (Object)new Integer((Integer)orgIds.get(0)), (IgniteRunnable)new NotReservedCacheOpAffinityRun(0, 0, cacheName));
        this.beginNodesRestart();
        this.grid(0).cache(cacheName).clear();
        IgniteInternalFuture affFut = null;
        try {
            affFut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PARTS_CNT; ++i) {
                        try {
                            IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(i), (IgniteRunnable)new NotReservedCacheOpAffinityRun(i, key.getAndIncrement() * KEYS_CNT, cacheName));
                            continue;
                        }
                        catch (IgniteException e) {
                            IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.checkException(e, ClusterTopologyException.class);
                        }
                    }
                }
            }, (int)10, (String)"affinity-run");
        }
        finally {
            if (affFut != null) {
                affFut.get();
            }
            this.stopRestartThread.set(true);
            nodeRestartFut.get();
            Thread.sleep(5000L);
            this.log.info("Final await. Timed out if failed");
            this.awaitPartitionMapExchange();
            IgniteCache cache = this.grid(0).cache(cacheName);
            cache.clear();
        }
    }

    @Test
    public void testReservedPartitionCacheOp() throws Exception {
        this.grid(0).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()).clear();
        this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName()), 0, (IgniteRunnable)new ReservedPartitionCacheOpAffinityRun(0, 0));
        this.beginNodesRestart();
        IgniteInternalFuture affFut = null;
        try {
            affFut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PARTS_CNT && System.currentTimeMillis() < IgniteCacheLockPartitionOnAffinityRunAbstractTest.endTime; ++i) {
                        try {
                            IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.grid(0).compute().affinityRun(Arrays.asList(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Organization.class.getSimpleName(), IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName()), (Object)new Integer(i), (IgniteRunnable)new ReservedPartitionCacheOpAffinityRun(i, key.getAndIncrement() * KEYS_CNT));
                            continue;
                        }
                        catch (IgniteException e) {
                            IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest.this.checkException(e, ClusterTopologyException.class);
                        }
                    }
                }
            }, (int)10, (String)"affinity-run");
        }
        finally {
            if (affFut != null) {
                affFut.get();
            }
            this.stopRestartThread.set(true);
            nodeRestartFut.get();
            Thread.sleep(5000L);
            this.log.info("Final await. Timed out if failed");
            this.awaitPartitionMapExchange();
            IgniteCache cache = this.grid(0).cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName());
            cache.clear();
        }
    }

    private void checkException(IgniteException e, Class<? extends Exception> exCls) {
        Throwable t = e;
        while (t.getCause() != null) {
            if (t.getCause().getClass().isAssignableFrom(exCls)) {
                this.log.info("Expected exception: " + (Object)((Object)e));
                return;
            }
            t = t.getCause();
        }
        throw e;
    }

    private static class ReservedPartitionCacheOpAffinityRun
    implements IgniteRunnable {
        int orgId;
        int keyBegin;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;

        public ReservedPartitionCacheOpAffinityRun() {
        }

        public ReservedPartitionCacheOpAffinityRun(int orgId, int keyBegin) {
            this.orgId = orgId;
            this.keyBegin = keyBegin;
        }

        public void run() {
            this.log.info("Begin run " + this.keyBegin);
            IgniteCache cache = this.ignite.cache(IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person.class.getSimpleName());
            for (int i = 0; i < KEYS_CNT; ++i) {
                IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person p = new IgniteCacheLockPartitionOnAffinityRunAbstractTest.Person(i + this.keyBegin, this.orgId);
                cache.put((Object)p.createKey(), (Object)p);
            }
        }
    }

    private static class NotReservedCacheOpAffinityRun
    implements IgniteRunnable {
        int orgId;
        int keyBegin;
        private String cacheName;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;

        public NotReservedCacheOpAffinityRun() {
        }

        public NotReservedCacheOpAffinityRun(int orgId, int keyBegin, String cacheName) {
            this.orgId = orgId;
            this.keyBegin = keyBegin;
            this.cacheName = cacheName;
        }

        public void run() {
            this.log.info("Begin run " + this.keyBegin);
            IgniteCache cache = this.ignite.cache(this.cacheName);
            for (int i = 0; i < KEYS_CNT; ++i) {
                cache.put((Object)(i + this.keyBegin), (Object)(i + this.keyBegin));
            }
            this.log.info("End run " + this.keyBegin);
        }
    }
}

