/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLargeResultSelfTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cacheCfg = IgniteCacheLargeResultSelfTest.defaultCacheConfiguration();
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setBackups(1);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
    }

    @Test
    public void testLargeResult() {
        try (IgniteDataStreamer streamer = this.ignite(0).dataStreamer("default");){
            streamer.perNodeBufferSize(20000);
            for (int i = 0; i < 50000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
            streamer.flush();
        }
        IgniteCache cache = this.ignite(0).cache("default");
        try (FieldsQueryCursor res = cache.query(new SqlFieldsQuery("select _val from Integer where _key between ? and ?").setArgs(new Object[]{10000, 40000}));){
            int cnt = 0;
            for (List row : res) {
                ++cnt;
                int val = (Integer)row.get(0);
                IgniteCacheLargeResultSelfTest.assertTrue((val >= 10000 && val <= 40000 ? 1 : 0) != 0);
            }
            IgniteCacheLargeResultSelfTest.assertEquals((int)30001, (int)cnt);
        }
    }
}

