/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
@Ignore(value="https://issues.apache.org/jira/browse/IGNITE-5016")
public class IgniteCacheJoinPartitionedAndReplicatedTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private static final String ORG_CACHE = "org";
    private static final String ORG_CACHE_REPLICATED = "orgRepl";
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("id", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE_REPLICATED);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("id", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        cfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration configuration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(1);
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGrid(2);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteEx client = this.grid(2);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        IgniteCache orgCacheRepl = client.cache(ORG_CACHE_REPLICATED);
        personCache.clear();
        orgCache.clear();
        orgCacheRepl.clear();
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-5016")
    @Test
    public void testJoin() throws Exception {
        IgniteEx client = this.grid(2);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        IgniteCache orgCacheRepl = client.cache(ORG_CACHE_REPLICATED);
        List keys = this.primaryKeys(this.ignite(0).cache(PERSON_CACHE), 3, 200000);
        orgCache.put(keys.get(0), (Object)new Organization(0, "org1"));
        orgCacheRepl.put(keys.get(0), (Object)new Organization(0, "org1"));
        personCache.put(keys.get(1), (Object)new Person(0, "p1"));
        personCache.put(keys.get(2), (Object)new Person(0, "p2"));
        this.checkQuery("select o.name, p._key, p.name from \"person\".Person p join \"org\".Organization o on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"org\".Organization o join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"person\".Person p join \"orgRepl\".Organization o on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCacheRepl, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"orgRepl\".Organization o join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCacheRepl, 2, new Object[0]);
        this.checkQuery("select p.name from \"person\".Person p", (IgniteCache<Object, Object>)this.ignite(0).cache(PERSON_CACHE), 2, new Object[0]);
        this.checkQuery("select p.name from \"person\".Person p", (IgniteCache<Object, Object>)this.ignite(1).cache(PERSON_CACHE), 2, new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.checkQuery("select p.name from \"person\".Person p", (IgniteCache<Object, Object>)personCache, 2, new Object[0]);
        }
        this.checkQuery("select o.name, p._key, p.name from \"org\".Organization o left join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"person\".Person p left join \"orgRepl\".Organization o on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCacheRepl, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"orgRepl\".Organization o left join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCacheRepl, 2, new Object[0]);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-5016")
    @Test
    public void testReplicatedToPartitionedLeftJoin() {
        IgniteEx client = this.grid(2);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        IgniteCache orgCacheRepl = client.cache(ORG_CACHE_REPLICATED);
        List keys = this.primaryKeys(this.ignite(0).cache(PERSON_CACHE), 3, 200000);
        orgCache.put(keys.get(0), (Object)new Organization(0, "org1"));
        orgCacheRepl.put(keys.get(0), (Object)new Organization(0, "org1"));
        personCache.put(keys.get(1), (Object)new Person(0, "p1"));
        personCache.put(keys.get(2), (Object)new Person(0, "p2"));
        this.checkQuery("select o.name, p._key, p.name from \"person\".Person p left join \"org\".Organization o on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"org\".Organization o right join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)orgCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"person\".Person p left join \"org\".Organization o on (p.orgId = o.id)", (IgniteCache<Object, Object>)personCache, 2, new Object[0]);
        this.checkQuery("select o.name, p._key, p.name from \"org\".Organization o right join \"person\".Person p on (p.orgId = o.id)", (IgniteCache<Object, Object>)personCache, 2, new Object[0]);
    }

    private void checkQueryFails(final String sql, final IgniteCache<Object, Object> cache) {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SqlFieldsQuery qry = new SqlFieldsQuery(sql);
                cache.query(qry).getAll();
                return null;
            }
        }, CacheException.class, null);
    }

    private void checkQuery(String sql, IgniteCache<Object, Object> cache, int expSize, Object ... args) {
        String plan = (String)((List)cache.query(new SqlFieldsQuery("explain " + sql)).getAll().get(0)).get(0);
        this.log.info("Plan: " + plan);
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setArgs(args);
        FieldsQueryCursor cur = cache.query(qry);
        List res = cur.getAll();
        if (expSize != res.size()) {
            this.log.info("Results: " + res);
        }
        IgniteCacheJoinPartitionedAndReplicatedTest.assertEquals((int)expSize, (int)res.size());
    }

    private static class Organization
    implements Serializable {
        String name;
        int id;

        public Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return S.toString(Organization.class, (Object)this);
        }
    }

    private static class Person
    implements Serializable {
        int orgId;
        String name;

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

