/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractInsertSqlQuerySelfTest;
import org.apache.ignite.internal.processors.cache.IgniteCacheUpdateSqlQuerySelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheInsertSqlQuerySelfTest
extends IgniteCacheAbstractInsertSqlQuerySelfTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        return cfg;
    }

    @Test
    public void testInsertWithExplicitKey() {
        IgniteCache p = this.ignite(0).cache("S2P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into Person (_key, id, firstName) values ('s', ?, ?), ('a', 2, 'Alex')").setArgs(new Object[]{1, "Sergi"}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)"s"));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)"a"));
    }

    @Test
    public void testInsertFromSubquery() {
        IgniteCache p = this.ignite(0).cache("S2P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into String (_key, _val) values ('s', ?), ('a', ?)").setArgs(new Object[]{"Sergi", "Alex"}).setLocal(true));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)"Sergi", (Object)p.get((Object)"s"));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)"Alex", (Object)p.get((Object)"a"));
        p.query(new SqlFieldsQuery("insert into Person(_key, id, firstName) (select substring(lower(_val), 0, 2), cast(length(_val) as int), _val from String)"));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(5, "Sergi"), (Object)p.get((Object)"se"));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(4, "Alex"), (Object)p.get((Object)"al"));
    }

    @Test
    public void testInsertWithExplicitPrimitiveKey() {
        IgniteCache p = this.ignite(0).cache("I2P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into Person (_key, id, firstName) values (cast('1' as int), ?, ?), (2, (5 - 3), 'Alex')").setArgs(new Object[]{1, "Sergi"}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)1));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)2));
    }

    @Test
    public void testInsertWithDynamicKeyInstantiation() {
        IgniteCache p = this.ignite(0).cache("K2P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into Person (key, id, firstName) values (1, ?, ?), (2, 2, 'Alex')").setArgs(new Object[]{1, "Sergi"}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(1)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(2)));
    }

    @Test
    public void testImplicitColumnNames() {
        IgniteCache p = this.ignite(0).cache("K2P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into Person values (1, 1, 'Vova')")).getAll();
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Vova"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(1)));
        p.query(new SqlFieldsQuery("insert into Person values (2, 2, 'Sergi'), (3, 3, 'Alex')")).getAll();
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Sergi"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(2)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson(3, "Alex"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(3)));
    }

    @Test
    public void testFieldsCaseSensitivity() {
        IgniteCache p = this.ignite(0).cache("K22P").withKeepBinary();
        p.query(new SqlFieldsQuery("insert into \"Person2\" (\"Id\", \"id\", \"firstName\", \"IntVal\") values (1, ?, ?, 5),  (2, 3, 'Alex', 6)").setArgs(new Object[]{4, "Sergi"}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson2(4, "Sergi", 5), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key2(1)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)this.createPerson2(3, "Alex", 6), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key2(2)));
    }

    @Test
    public void testPrimitives() {
        IgniteCache p = this.ignite(0).cache("I2I");
        p.query(new SqlFieldsQuery("insert into Integer(_key, _val) values (1, ?), (?, 4)").setArgs(new Object[]{2, 3}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)2, (int)((Integer)p.get((Object)1)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)4, (int)((Integer)p.get((Object)3)));
    }

    @Test
    public void testDuplicateKeysException() {
        final IgniteCache p = this.ignite(0).cache("I2I");
        p.clear();
        p.put((Object)3, (Object)5);
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                p.query(new SqlFieldsQuery("insert into Integer(_key, _val) values (1, ?), (?, 4), (5, 6)").setArgs(new Object[]{2, 3}));
                return null;
            }
        }, CacheException.class, (String)"Failed to INSERT some keys because they are already in cache [keys=[3]]");
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)2, (int)((Integer)p.get((Object)1)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)5, (int)((Integer)p.get((Object)3)));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)6, (int)((Integer)p.get((Object)5)));
    }

    @Test
    public void testUuidHandling() {
        IgniteCache p = this.ignite(0).cache("U2I");
        UUID id = UUID.randomUUID();
        p.query(new SqlFieldsQuery("insert into Integer(_key, _val) values (?, ?)").setArgs(new Object[]{id, 1}));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((int)1, (int)((Integer)p.get((Object)id)));
    }

    @Test
    public void testNestedFieldsHandling() {
        IgniteCache p = this.ignite(0).cache("I2AT");
        p.query(new SqlFieldsQuery("insert into AllTypes(_key, innerTypeCol, arrListCol, _val, innerStrCol) values (1, ?, ?, ?, 'sss')").setArgs(new Object[]{new IgniteCacheUpdateSqlQuerySelfTest.AllTypes.InnerType(50L), new ArrayList<Long>(Arrays.asList(3L, 2L, 1L)), new IgniteCacheUpdateSqlQuerySelfTest.AllTypes(1L)}));
        IgniteCacheUpdateSqlQuerySelfTest.AllTypes res = (IgniteCacheUpdateSqlQuerySelfTest.AllTypes)p.get((Object)1);
        IgniteCacheUpdateSqlQuerySelfTest.AllTypes.InnerType resInner = new IgniteCacheUpdateSqlQuerySelfTest.AllTypes.InnerType(50L);
        resInner.innerStrCol = "sss";
        resInner.arrListCol = new ArrayList<Long>(Arrays.asList(3L, 2L, 1L));
        IgniteCacheInsertSqlQuerySelfTest.assertEquals((Object)resInner, (Object)res.innerTypeCol);
    }

    @Test
    public void testCacheRestartHandling() {
        for (int i = 0; i < 4; ++i) {
            IgniteCache p = this.ignite(0).getOrCreateCache(IgniteCacheInsertSqlQuerySelfTest.cacheConfig("I2AT", true, false, Integer.class, IgniteCacheUpdateSqlQuerySelfTest.AllTypes.class));
            p.query(new SqlFieldsQuery("insert into AllTypes(_key, _val, dateCol) values (1, ?, null)").setArgs(new Object[]{new IgniteCacheUpdateSqlQuerySelfTest.AllTypes(1L)}));
            p.destroy();
        }
    }
}

