/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.AffinityKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheGroupsSqlTest
extends GridCommonAbstractTest {
    private static final String GROUP1 = "grp1";
    private static final String GROUP2 = "grp2";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testSqlQuery() throws Exception {
        Ignite node = this.ignite(0);
        IgniteCache c1 = node.createCache(this.personCacheConfiguration(GROUP1, "c1"));
        IgniteCache c2 = node.createCache(this.personCacheConfiguration(GROUP1, "c2"));
        SqlFieldsQuery qry = new SqlFieldsQuery("select name from Person where name=?");
        qry.setArgs(new Object[]{"p1"});
        IgniteCacheGroupsSqlTest.assertEquals((int)0, (int)c1.query(qry).getAll().size());
        IgniteCacheGroupsSqlTest.assertEquals((int)0, (int)c2.query(qry).getAll().size());
        c1.put((Object)1, (Object)new Person("p1"));
        IgniteCacheGroupsSqlTest.assertEquals((int)1, (int)c1.query(qry).getAll().size());
        IgniteCacheGroupsSqlTest.assertEquals((int)0, (int)c2.query(qry).getAll().size());
        c2.put((Object)2, (Object)new Person("p1"));
        IgniteCacheGroupsSqlTest.assertEquals((int)1, (int)c1.query(qry).getAll().size());
        IgniteCacheGroupsSqlTest.assertEquals((int)1, (int)c2.query(qry).getAll().size());
    }

    @Test
    public void testJoinQuery1() throws Exception {
        this.joinQuery(GROUP1, GROUP2, CacheMode.REPLICATED, CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testJoinQuery2() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgniteCacheGroupsSqlTest.this.joinQuery(IgniteCacheGroupsSqlTest.GROUP1, IgniteCacheGroupsSqlTest.GROUP1, CacheMode.REPLICATED, CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.TRANSACTIONAL);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Cache mode mismatch for caches related to the same group");
    }

    @Test
    public void testJoinQuery3() throws Exception {
        this.joinQuery(GROUP1, GROUP1, CacheMode.PARTITIONED, CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testJoinQuery4() throws Exception {
        this.joinQuery(GROUP1, GROUP1, CacheMode.REPLICATED, CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testJoinQuery5() throws Exception {
        this.joinQuery(GROUP1, null, CacheMode.REPLICATED, CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testJoinQuery6() throws Exception {
        this.joinQuery(GROUP1, null, CacheMode.PARTITIONED, CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.ATOMIC);
    }

    private void joinQuery(String grp1, String grp2, CacheMode cm1, CacheMode cm2, CacheAtomicityMode cam1, CacheAtomicityMode cam2) throws Exception {
        int keys = 1000;
        int accsPerPerson = 4;
        Ignite srv0 = this.ignite(0);
        IgniteCache pers = srv0.createCache(this.personCacheConfiguration(grp1, "pers").setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(10)).setCacheMode(cm1).setAtomicityMode(cam1)).withAllowAtomicOpsInTx();
        IgniteCache acc = srv0.createCache(this.accountCacheConfiguration(grp2, "acc").setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(10)).setCacheMode(cm2).setAtomicityMode(cam2)).withAllowAtomicOpsInTx();
        try (Transaction tx = cam1 == CacheAtomicityMode.TRANSACTIONAL || cam2 == CacheAtomicityMode.TRANSACTIONAL ? srv0.transactions().txStart() : null;){
            for (int i = 0; i < keys; ++i) {
                int pKey = i - i % accsPerPerson;
                if (i % accsPerPerson == 0) {
                    pers.put((Object)pKey, (Object)new Person("pers-" + pKey));
                }
                acc.put((Object)new AffinityKey(i, pKey), (Object)new Account(pKey, "acc-" + i));
            }
            if (tx != null) {
                tx.commit();
            }
        }
        Ignite node = this.ignite(2);
        SqlFieldsQuery qry = new SqlFieldsQuery("select p._key as p_key, p.name, a._key as a_key, a.personId, a.attr \nfrom \"pers\".Person p inner join \"acc\".Account a \non (p._key = a.personId)");
        IgniteCache cache = node.cache("acc");
        List res = cache.query(qry).getAll();
        IgniteCacheGroupsSqlTest.assertEquals((int)keys, (int)res.size());
        for (List row : res) {
            IgniteCacheGroupsSqlTest.assertEquals(row.get(0), row.get(3));
        }
    }

    private CacheConfiguration personCacheConfiguration(String grpName, String cacheName) {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        return this.cacheConfiguration(grpName, cacheName, entity);
    }

    private CacheConfiguration accountCacheConfiguration(String grpName, String cacheName) {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(AffinityKey.class.getName());
        entity.setValueType(Account.class.getName());
        entity.addQueryField("personId", Integer.class.getName(), null);
        entity.addQueryField("attr", String.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("personId")));
        return this.cacheConfiguration(grpName, cacheName, entity);
    }

    private CacheConfiguration cacheConfiguration(String grpName, String cacheName, QueryEntity queryEntity) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setGroupName(grpName);
        ccfg.setName(cacheName);
        ccfg.setQueryEntities((Collection)F.asList((Object)queryEntity));
        return ccfg;
    }

    private static class Account
    implements Serializable {
        Integer personId;
        String attr;

        public Account(Integer personId, String attr) {
            this.personId = personId;
            this.attr = attr;
        }

        public String toString() {
            return S.toString(Account.class, (Object)this);
        }
    }

    private static class Person
    implements Serializable {
        String name;

        public Person(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

