/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedJoinPartitionedAndReplicatedTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private static final String ORG_CACHE = "org";
    private static final String ACCOUNT_CACHE = "acc";
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration configuration(String name, CacheMode cacheMode) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setCacheMode(cacheMode);
        if (cacheMode == CacheMode.PARTITIONED) {
            ccfg.setBackups(1);
        }
        return ccfg;
    }

    private List<CacheConfiguration> caches(boolean idx, CacheMode persCacheMode, CacheMode orgCacheMode, CacheMode accCacheMode) {
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE, persCacheMode);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        if (idx) {
            entity.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("orgId"), new QueryIndex("name")}));
        }
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE, orgCacheMode);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        if (idx) {
            entity.setIndexes((Collection)F.asList((Object)new QueryIndex("name")));
        }
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ACCOUNT_CACHE, accCacheMode);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Account.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("personId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        if (idx) {
            entity.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("orgId"), new QueryIndex("personId"), new QueryIndex("name")}));
        }
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        return ccfgs;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGrid(2);
    }

    @Test
    public void testJoin1() throws Exception {
        this.join(true, CacheMode.REPLICATED, CacheMode.PARTITIONED, CacheMode.PARTITIONED);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-5956")
    @Test
    public void testJoin2() throws Exception {
        this.join(true, CacheMode.PARTITIONED, CacheMode.REPLICATED, CacheMode.PARTITIONED);
    }

    @Test
    public void testJoin3() throws Exception {
        this.join(true, CacheMode.PARTITIONED, CacheMode.PARTITIONED, CacheMode.REPLICATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join(boolean idx, CacheMode persCacheMode, CacheMode orgCacheMode, CacheMode accCacheMode) throws Exception {
        IgniteEx client = this.grid(2);
        for (CacheConfiguration ccfg : this.caches(idx, persCacheMode, orgCacheMode, accCacheMode)) {
            client.createCache(ccfg);
        }
        try {
            IgniteCache personCache = client.cache(PERSON_CACHE);
            IgniteCache orgCache = client.cache(ORG_CACHE);
            IgniteCache accCache = client.cache(ACCOUNT_CACHE);
            Affinity aff = client.affinity(PERSON_CACHE);
            AtomicInteger pKey = new AtomicInteger(100000);
            AtomicInteger orgKey = new AtomicInteger();
            AtomicInteger accKey = new AtomicInteger();
            ClusterNode node0 = this.ignite(0).cluster().localNode();
            ClusterNode node1 = this.ignite(1).cluster().localNode();
            int orgId1 = this.keyForNode(aff, orgKey, node0);
            orgCache.put((Object)orgId1, (Object)new Organization("obj-" + orgId1));
            int pid1 = this.keyForNode(aff, pKey, node0);
            personCache.put((Object)pid1, (Object)new Person(orgId1, "o1-p1"));
            accCache.put((Object)this.keyForNode(aff, accKey, node0), (Object)new Account(pid1, orgId1, "a0"));
            accCache.put((Object)this.keyForNode(aff, accKey, node1), (Object)new Account(pid1, orgId1, "a1"));
            IgniteCache qryCache = this.replicated(orgCache) ? personCache : orgCache;
            this.checkQuery("select p._key, p.name, a.name from \"person\".Person p, \"acc\".Account a where p._key = a.personId", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o, \"acc\".Account a, \"person\".Person p where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            this.checkQuery("select o.name, p._key, p.name, a.name from \"person\".Person p, \"org\".Organization o, \"acc\".Account a where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            this.checkQuery("select * from (select o.name n1, p._key, p.name n2, a.name n3 from \"acc\".Account a, \"person\".Person p, \"org\".Organization o where p.orgId = o._key and p._key = a.personId and a.orgId=o._key)", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            this.checkQuery("select * from (select o.name n1, p._key, p.name n2, a.name n3 from \"person\".Person p, \"acc\".Account a, \"org\".Organization o where p.orgId = o._key and p._key = a.personId and a.orgId=o._key)", (IgniteCache<Object, Object>)qryCache, false, 2, new Object[0]);
            List<List<?>> res = this.checkQuery("select count(*) from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 1, new Object[0]);
            IgniteCacheDistributedJoinPartitionedAndReplicatedTest.assertEquals((Object)2L, res.get(0).get(0));
            this.checkQueries((IgniteCache<Object, Object>)qryCache, 2);
            int orgId2 = this.keyForNode(aff, orgKey, node1);
            orgCache.put((Object)orgId2, (Object)new Organization("obj-" + orgId2));
            int pid2 = this.keyForNode(aff, pKey, node0);
            personCache.put((Object)pid2, (Object)new Person(orgId2, "o2-p1"));
            accCache.put((Object)this.keyForNode(aff, accKey, node0), (Object)new Account(pid2, orgId2, "a3"));
            accCache.put((Object)this.keyForNode(aff, accKey, node1), (Object)new Account(pid2, orgId2, "a4"));
            this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 4, new Object[0]);
            this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o inner join \"person\".Person p on p.orgId = o._key inner join \"acc\".Account a on p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 4, new Object[0]);
            res = this.checkQuery("select count(*) from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and p._key = a.personId and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 1, new Object[0]);
            IgniteCacheDistributedJoinPartitionedAndReplicatedTest.assertEquals((Object)4L, res.get(0).get(0));
            this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and a.orgId = o._key and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 4, new Object[0]);
            res = this.checkQuery("select count(*) from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o._key and a.orgId = o._key and a.orgId=o._key", (IgniteCache<Object, Object>)qryCache, false, 1, new Object[0]);
            IgniteCacheDistributedJoinPartitionedAndReplicatedTest.assertEquals((Object)4L, res.get(0).get(0));
            this.checkQueries((IgniteCache<Object, Object>)qryCache, 4);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
            client.destroyCache(ACCOUNT_CACHE);
        }
    }

    private void checkQueries(IgniteCache<Object, Object> qryCache, int expSize) {
        String[] cacheNames = new String[]{"\"org\".Organization o", "\"person\".Person p", "\"acc\".Account a"};
        for (int c1 = 0; c1 < cacheNames.length; ++c1) {
            for (int c2 = 0; c2 < cacheNames.length; ++c2) {
                if (c2 == c1) continue;
                for (int c3 = 0; c3 < cacheNames.length; ++c3) {
                    if (c3 == c1 || c3 == c2) continue;
                    String cache1 = cacheNames[c1];
                    String cache2 = cacheNames[c2];
                    String cache3 = cacheNames[c3];
                    String qry = "select o.name, p._key, p.name, a.name from " + cache1 + ", " + cache2 + ", " + cache3 + " where p.orgId = o._key and p._key = a.personId and a.orgId=o._key";
                    this.checkQuery(qry, qryCache, false, expSize, new Object[0]);
                    qry = "select o.name, p._key, p.name, a.name from " + cache1 + ", " + cache2 + ", " + cache3 + " where p.orgId = o._key and a.orgId = o._key and a.orgId=o._key";
                    this.checkQuery(qry, qryCache, false, expSize, new Object[0]);
                }
            }
        }
    }

    private List<List<?>> checkQuery(String sql, IgniteCache<Object, Object> cache, boolean enforceJoinOrder, int expSize, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setEnforceJoinOrder(enforceJoinOrder);
        qry.setArgs(args);
        this.log.info("Plan: " + this.queryPlan(cache, qry));
        FieldsQueryCursor cur = cache.query(qry);
        List res = cur.getAll();
        if (expSize != res.size()) {
            this.log.info("Results: " + res);
        }
        IgniteCacheDistributedJoinPartitionedAndReplicatedTest.assertEquals((int)expSize, (int)res.size());
        return res;
    }

    private boolean replicated(IgniteCache<?, ?> cache) {
        return ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getCacheMode() == CacheMode.REPLICATED;
    }

    private static class Organization
    implements Serializable {
        String name;

        public Organization(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Organization.class, (Object)this);
        }
    }

    private static class Person
    implements Serializable {
        int orgId;
        String name;

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    private static class Account
    implements Serializable {
        int personId;
        int orgId;
        String name;

        public Account(int personId, int orgId, String name) {
            this.personId = personId;
            this.orgId = orgId;
            this.name = name;
        }

        public String toString() {
            return S.toString(Account.class, (Object)this);
        }
    }
}

