/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedJoinCustomAffinityMapper
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private static final String PERSON_CACHE_CUSTOM_AFF = "personCustomAff";
    private static final String ORG_CACHE = "org";
    private static final String ORG_CACHE_REPL_CUSTOM = "orgReplCustomAff";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("orgId")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(PERSON_CACHE_CUSTOM_AFF);
        ccfg.setAffinityMapper((AffinityKeyMapper)new TestMapper());
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("orgId")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE_REPL_CUSTOM);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        ccfg.setAffinityMapper((AffinityKeyMapper)new TestMapper());
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        cfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        return cfg;
    }

    private CacheConfiguration configuration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(0);
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    @Test
    public void testJoinCustomAffinityMapper() throws Exception {
        Ignite ignite = this.ignite(0);
        IgniteCache cache = ignite.cache(PERSON_CACHE);
        this.checkQueryFails((IgniteCache<Object, Object>)cache, "select o._key k1, p._key k2 from \"org\".Organization o, \"personCustomAff\".Person p where o._key=p.orgId", false);
        this.checkQueryFails((IgniteCache<Object, Object>)cache, "select o._key k1, p._key k2 from \"personCustomAff\".Person p, \"org\".Organization o where o._key=p.orgId", false);
        SqlFieldsQuery qry = new SqlFieldsQuery("select o._key k1, p._key k2 from \"org\".Organization o, \"personCustomAff\".Person p where o._key=p.orgId");
        cache.query(qry).getAll();
        qry = new SqlFieldsQuery("select o1._key k1, p._key k2, o2._key k3 from \"org\".Organization o1, \"person\".Person p, \"orgReplCustomAff\".Organization o2 where o1._key=p.orgId and o2._key=p.orgId");
        cache.query(qry).getAll();
    }

    private void checkQueryFails(final IgniteCache<Object, Object> cache, String sql, boolean enforceJoinOrder) {
        final SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setEnforceJoinOrder(enforceJoinOrder);
        Throwable err = GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.query(qry);
                return null;
            }
        }, CacheException.class, null);
        IgniteCacheDistributedJoinCustomAffinityMapper.assertTrue((String)("Unexpected error message: " + err.getMessage()), (boolean)err.getMessage().contains("can not use distributed joins for cache with custom AffinityKeyMapper configured."));
    }

    private static class Organization
    implements Serializable {
        private Organization() {
        }
    }

    private static class Person
    implements Serializable {
        int orgId;

        public Person(int orgId) {
            this.orgId = orgId;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    static class TestMapper
    implements AffinityKeyMapper {
        TestMapper() {
        }

        public Object affinityKey(Object key) {
            return key;
        }

        public void reset() {
        }
    }
}

