/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedJoinCollocatedAndNotTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private static final String ORG_CACHE = "org";
    private static final String ACCOUNT_CACHE = "acc";
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheKeyConfiguration keyCfg = new CacheKeyConfiguration(PersonKey.class.getName(), "affKey");
        cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(PersonKey.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("id", Integer.class.getName(), null);
        entity.addQueryField("affKey", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("name")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ACCOUNT_CACHE);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Account.class.getName());
        entity.addQueryField("personId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("personId"), new QueryIndex("name")}));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        cfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        cfg.setClientMode(this.client);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGrid(2);
    }

    private CacheConfiguration configuration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(1);
        return ccfg;
    }

    @Test
    public void testJoin() throws Exception {
        IgniteEx client = this.grid(2);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        IgniteCache accCache = client.cache(ACCOUNT_CACHE);
        Affinity aff = client.affinity(PERSON_CACHE);
        AtomicInteger orgKey = new AtomicInteger();
        AtomicInteger accKey = new AtomicInteger();
        ClusterNode node0 = this.ignite(0).cluster().localNode();
        ClusterNode node1 = this.ignite(1).cluster().localNode();
        int orgId1 = this.keyForNode(aff, orgKey, node0);
        orgCache.put((Object)orgId1, (Object)new Organization("obj-" + orgId1));
        personCache.put((Object)new PersonKey(1, orgId1), (Object)new Person(1, "o1-p1"));
        personCache.put((Object)new PersonKey(2, orgId1), (Object)new Person(2, "o1-p2"));
        accCache.put((Object)this.keyForNode(aff, accKey, node0), (Object)new Account(1, "a0"));
        accCache.put((Object)this.keyForNode(aff, accKey, node1), (Object)new Account(1, "a1"));
        String qry = "select o.name, p._key, p.name from \"org\".Organization o, \"person\".Person p where p.affKey = o._key";
        IgniteCacheDistributedJoinCollocatedAndNotTest.assertFalse((boolean)this.plan(qry, orgCache, false).contains("batched"));
        this.checkQuery(qry, (IgniteCache<Object, Object>)orgCache, false, 2);
        this.checkQuery("select o.name, p._key, p.name, a.name from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.affKey = o._key and p.id = a.personId", (IgniteCache<Object, Object>)orgCache, true, 2);
    }

    private String plan(String sql, IgniteCache<?, ?> cache, boolean enforceJoinOrder) {
        return (String)((List)cache.query(new SqlFieldsQuery("explain " + sql).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder)).getAll().get(0)).get(0);
    }

    private void checkQuery(String sql, IgniteCache<Object, Object> cache, boolean enforceJoinOrder, int expSize) {
        String plan = (String)((List)cache.query(new SqlFieldsQuery("explain " + sql).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder)).getAll().get(0)).get(0);
        this.log.info("Plan: " + plan);
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setEnforceJoinOrder(enforceJoinOrder);
        FieldsQueryCursor cur = cache.query(qry);
        List res = cur.getAll();
        if (expSize != res.size()) {
            this.log.info("Results: " + res);
        }
        IgniteCacheDistributedJoinCollocatedAndNotTest.assertEquals((int)expSize, (int)res.size());
    }

    private static class Organization
    implements Serializable {
        String name;

        public Organization(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Organization.class, (Object)this);
        }
    }

    private static class Person
    implements Serializable {
        int id;
        String name;

        public Person(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    private static class Account
    implements Serializable {
        int personId;
        String name;

        public Account(int personId, String name) {
            this.personId = personId;
            this.name = name;
        }

        public String toString() {
            return S.toString(Account.class, (Object)this);
        }
    }

    public static class PersonKey {
        private int id;
        @AffinityKeyMapped
        private int affKey;

        public PersonKey(int id, int affKey) {
            this.id = id;
            this.affKey = affKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonKey other = (PersonKey)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

