/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheCrossCacheJoinRandomTest
extends AbstractH2CompareQueryTest {
    private boolean client;
    private static final int OBJECTS = 200;
    private static final int MAX_CACHES = 5;
    private static Random rnd;
    private static List<Map<Integer, Integer>> cachesData;
    private static final List<T2<CacheMode, Integer>> MODES_1;
    private static final List<T2<CacheMode, Integer>> MODES_2;

    @Override
    protected void createCaches() {
    }

    @Override
    protected void initCacheAndDbData() throws Exception {
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
    }

    protected long getTestTimeout() {
        return 600000L;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.client = true;
        this.startGrid(4);
        long seed = System.currentTimeMillis();
        rnd = new Random(seed);
        this.log.info("Random seed: " + seed);
        cachesData = new ArrayList<Map<Integer, Integer>>(5);
        for (int i = 0; i < 5; ++i) {
            Map<Integer, Integer> data = this.createData(400);
            this.insertH2(data, i);
            cachesData.add(data);
        }
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        cachesData = null;
        super.afterTestsStopped();
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = super.initializeH2Schema();
        for (int i = 0; i < 5; ++i) {
            st.execute("CREATE SCHEMA \"cache" + i + "\"");
            st.execute("create table \"cache" + i + "\".TESTOBJECT  (_key int not null,  _val other not null,  parentId int)");
        }
        return st;
    }

    private CacheConfiguration configuration(String name, CacheMode cacheMode, int backups) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setCacheMode(cacheMode);
        if (cacheMode == CacheMode.PARTITIONED) {
            ccfg.setBackups(backups);
        }
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(TestObject.class.getName());
        entity.addQueryField("parentId", Integer.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("parentId")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        return ccfg;
    }

    @Test
    public void testJoin2Caches() throws Exception {
        this.testJoin(2, MODES_1);
    }

    @Test
    public void testJoin3Caches() throws Exception {
        this.testJoin(3, MODES_1);
    }

    @Test
    public void testJoin4Caches() throws Exception {
        this.testJoin(4, MODES_2);
    }

    @Test
    public void testJoin5Caches() throws Exception {
        this.testJoin(5, MODES_2);
    }

    private void testJoin(int caches, List<T2<CacheMode, Integer>> allModes) throws Exception {
        this.checkJoin(cachesData, allModes, new Stack<T2<CacheMode, Integer>>(), caches);
    }

    private void checkJoin(List<Map<Integer, Integer>> cachesData, List<T2<CacheMode, Integer>> allModes, Stack<T2<CacheMode, Integer>> modes, int caches) throws Exception {
        if (modes.size() == caches) {
            ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
            for (int i = 0; i < modes.size(); ++i) {
                T2 mode = (T2)modes.get(i);
                CacheConfiguration ccfg = this.configuration("cache" + i, (CacheMode)mode.get1(), (Integer)mode.get2());
                ccfgs.add(ccfg);
            }
            this.log.info("Check configurations: " + modes);
            this.checkJoinQueries(ccfgs, cachesData);
        } else {
            for (T2<CacheMode, Integer> mode : allModes) {
                modes.push(mode);
                this.checkJoin(cachesData, allModes, modes, caches);
                modes.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJoinQueries(List<CacheConfiguration> ccfgs, List<Map<Integer, Integer>> cachesData) throws Exception {
        Ignite client = this.ignite(4);
        int CACHES = ccfgs.size();
        try {
            IgniteCache cache = null;
            boolean hasReplicated = false;
            for (int i = 0; i < CACHES; ++i) {
                CacheConfiguration ccfg = ccfgs.get(i);
                IgniteCache cache0 = client.createCache(ccfg);
                if (ccfg.getCacheMode() == CacheMode.REPLICATED) {
                    hasReplicated = true;
                }
                if (cache == null && ccfg.getCacheMode() == CacheMode.PARTITIONED) {
                    cache = cache0;
                }
                this.insertCache(cachesData.get(i), (IgniteCache<Object, Object>)cache0);
            }
            boolean distributedJoin = true;
            if (cache == null) {
                cache = client.cache(ccfgs.get(0).getName());
                distributedJoin = false;
            }
            Object[] args = new Object[]{};
            IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, false, null), distributedJoin, false, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
            if (!hasReplicated) {
                IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, false, null), distributedJoin, true, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
                IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, true, null), distributedJoin, true, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
            }
            Map<Integer, Integer> data = cachesData.get(CACHES - 1);
            int QRY_CNT = CACHES > 4 ? 2 : 50;
            int cnt = 0;
            for (Integer objId : data.keySet()) {
                IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, false, objId), distributedJoin, false, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
                if (!hasReplicated) {
                    IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, false, objId), distributedJoin, true, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
                    IgniteCacheCrossCacheJoinRandomTest.compareQueryRes0(cache, this.createQuery(CACHES, true, objId), distributedJoin, true, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
                }
                if (cnt++ != QRY_CNT) continue;
                break;
            }
        }
        finally {
            for (CacheConfiguration ccfg : ccfgs) {
                client.destroyCache(ccfg.getName());
            }
        }
    }

    private String createQuery(int caches, boolean outer, @Nullable Integer objId) {
        int i;
        StringBuilder qry = new StringBuilder("select ");
        for (i = 0; i < caches; ++i) {
            if (i != 0) {
                qry.append(", ");
            }
            qry.append("o" + i + "._key");
        }
        qry.append(" from \"cache0\".TestObject o0 ");
        for (i = 1; i < caches; ++i) {
            String cacheName = "cache" + i;
            String cur = "o" + i;
            String prev = "o" + (i - 1);
            qry.append(outer ? "left outer join " : "inner join ");
            qry.append("\"" + cacheName + "\".TestObject " + cur);
            if (i == caches - 1 && objId != null) {
                qry.append(" on (" + prev + ".parentId=" + cur + "._key and " + cur + "._key=" + objId + ") ");
                continue;
            }
            qry.append(" on (" + prev + ".parentId=" + cur + "._key) ");
        }
        return qry.toString();
    }

    private void insertCache(Map<Integer, Integer> data, IgniteCache<Object, Object> cache) {
        for (Map.Entry<Integer, Integer> e : data.entrySet()) {
            cache.put((Object)e.getKey(), (Object)new TestObject(e.getValue()));
        }
    }

    private void insertH2(Map<Integer, Integer> data, int cache) throws Exception {
        for (Map.Entry<Integer, Integer> e : data.entrySet()) {
            PreparedStatement st = conn.prepareStatement("insert into \"cache" + cache + "\".TESTOBJECT (_key, _val, parentId) values(?, ?, ?)");
            Throwable throwable = null;
            try {
                st.setObject(1, e.getKey());
                st.setObject(2, new TestObject(e.getValue()));
                st.setObject(3, e.getValue());
                st.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (st == null) continue;
                if (throwable != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                st.close();
            }
        }
    }

    private Map<Integer, Integer> createData(int cnt) {
        LinkedHashMap<Integer, Integer> res = new LinkedHashMap<Integer, Integer>();
        while (res.size() < cnt) {
            res.put(rnd.nextInt(cnt), rnd.nextInt(201));
        }
        return res;
    }

    static {
        MODES_1 = F.asList((Object[])new T2[]{new T2((Object)CacheMode.PARTITIONED, (Object)0), new T2((Object)CacheMode.PARTITIONED, (Object)1), new T2((Object)CacheMode.PARTITIONED, (Object)2)});
        MODES_2 = F.asList((Object[])new T2[]{new T2((Object)CacheMode.PARTITIONED, (Object)0), new T2((Object)CacheMode.PARTITIONED, (Object)1)});
    }

    static class TestObject
    implements Serializable {
        int parentId;

        public TestObject(int parentId) {
            this.parentId = parentId;
        }

        public String toString() {
            return S.toString(TestObject.class, (Object)this);
        }
    }
}

