/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.IgniteCacheConfigVariationsAbstractTest;
import org.apache.ignite.testframework.junits.IgniteConfigVariationsAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheConfigVariationsQueryTest
extends IgniteCacheConfigVariationsAbstractTest {
    public static final int CNT = 50;
    private Map<Object, Object> evtMap;
    private CountDownLatch readEvtLatch;
    private CountDownLatch execEvtLatch;
    private IgnitePredicate[] objReadLsnrs;
    private IgnitePredicate[] qryExecLsnrs;
    private Map<Object, Object> expMap;

    @Test
    public void testScanQuery() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                try {
                    IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                    HashMap<Object, Object> map = new HashMap<Object, Object>(){
                        {
                            for (int i = 0; i < 50; ++i) {
                                this.put(IgniteCacheConfigVariationsQueryTest.this.key(i), IgniteCacheConfigVariationsQueryTest.this.value(i));
                            }
                        }
                    };
                    IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(map);
                    for (Map.Entry e : map.entrySet()) {
                        cache.put(e.getKey(), e.getValue());
                    }
                    QueryCursor qry = cache.query((Query)new ScanQuery());
                    IgniteCacheConfigVariationsQueryTest.this.checkQueryResults(map, (QueryCursor<Cache.Entry<Object, Object>>)qry);
                }
                finally {
                    IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    @Test
    public void testScanPartitionQuery() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                int i;
                IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                GridCacheContext cctx = ((IgniteCacheProxy)cache).context();
                HashMap<Integer, HashMap<Object, Object>> entries = new HashMap<Integer, HashMap<Object, Object>>();
                for (i = 0; i < 50; ++i) {
                    Object key = IgniteCacheConfigVariationsQueryTest.this.key(i);
                    Object val = IgniteCacheConfigVariationsQueryTest.this.value(i);
                    cache.put(key, val);
                    int part = cctx.affinity().partition(key);
                    HashMap<Object, Object> partEntries = (HashMap<Object, Object>)entries.get(part);
                    if (partEntries == null) {
                        partEntries = new HashMap<Object, Object>();
                        entries.put(part, partEntries);
                    }
                    partEntries.put(key, val);
                }
                for (i = 0; i < cctx.affinity().partitions(); ++i) {
                    try {
                        Map exp = (Map)entries.get(i);
                        if (exp == null) {
                            System.out.println();
                        }
                        IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(exp);
                        ScanQuery scan = new ScanQuery(i);
                        List actual = cache.query((Query)scan).getAll();
                        Assert.assertEquals((String)("Failed for partition: " + i), (int)(exp == null ? 0 : exp.size()), (int)actual.size());
                        if (exp != null) {
                            for (Cache.Entry entry : actual) {
                                Assert.assertTrue((boolean)entry.getValue().equals(exp.get(entry.getKey())));
                            }
                        }
                        IgniteCacheConfigVariationsQueryTest.this.checkEvents();
                        continue;
                    }
                    finally {
                        IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                    }
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    @Test
    public void testScanFilters() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                try {
                    IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                    IgniteBiPredicate<Object, Object> p = new IgniteBiPredicate<Object, Object>(){

                        public boolean apply(Object k, Object v) {
                            Assert.assertNotNull((Object)k);
                            Assert.assertNotNull((Object)v);
                            return IgniteConfigVariationsAbstractTest.valueOf((Object)k) >= 20 && IgniteConfigVariationsAbstractTest.valueOf((Object)v) < 40;
                        }
                    };
                    HashMap<Object, Object> exp = new HashMap<Object, Object>();
                    for (int i = 0; i < 50; ++i) {
                        Object key = IgniteCacheConfigVariationsQueryTest.this.key(i);
                        Object val = IgniteCacheConfigVariationsQueryTest.this.value(i);
                        cache.put(key, val);
                        if (!p.apply(key, val)) continue;
                        exp.put(key, val);
                    }
                    IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(exp, true);
                    QueryCursor q = cache.query((Query)new ScanQuery((IgniteBiPredicate)p));
                    IgniteCacheConfigVariationsQueryTest.this.checkQueryResults(exp, (QueryCursor<Cache.Entry<Object, Object>>)q);
                }
                finally {
                    IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    @Test
    public void testLocalScanQuery() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                try {
                    IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                    ClusterNode locNode = IgniteCacheConfigVariationsQueryTest.this.testedGrid().cluster().localNode();
                    Affinity affinity = IgniteCacheConfigVariationsQueryTest.this.testedGrid().affinity(IgniteCacheConfigVariationsQueryTest.this.cacheName());
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    for (int i = 0; i < 50; ++i) {
                        Object key = IgniteCacheConfigVariationsQueryTest.this.key(i);
                        Object val = IgniteCacheConfigVariationsQueryTest.this.value(i);
                        cache.put(key, val);
                        if (IgniteCacheConfigVariationsQueryTest.this.isClientMode() || IgniteCacheConfigVariationsQueryTest.this.cacheMode() != CacheMode.REPLICATED && !affinity.isPrimary(locNode, key)) continue;
                        map.put(key, val);
                    }
                    IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(map);
                    QueryCursor q = cache.query((Query)new ScanQuery().setLocal(true));
                    IgniteCacheConfigVariationsQueryTest.this.checkQueryResults(map, (QueryCursor<Cache.Entry<Object, Object>>)q);
                }
                finally {
                    IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    @Test
    public void testScanQueryLocalFilter() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                try {
                    IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                    ClusterNode locNode = IgniteCacheConfigVariationsQueryTest.this.testedGrid().cluster().localNode();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    IgniteBiPredicate<Object, Object> filter = new IgniteBiPredicate<Object, Object>(){

                        public boolean apply(Object k, Object v) {
                            Assert.assertNotNull((Object)k);
                            Assert.assertNotNull((Object)v);
                            return IgniteConfigVariationsAbstractTest.valueOf((Object)k) >= 20 && IgniteConfigVariationsAbstractTest.valueOf((Object)v) < 40;
                        }
                    };
                    for (int i = 0; i < 50; ++i) {
                        Object key = IgniteCacheConfigVariationsQueryTest.this.key(i);
                        Object val = IgniteCacheConfigVariationsQueryTest.this.value(i);
                        cache.put(key, val);
                        if (IgniteCacheConfigVariationsQueryTest.this.isClientMode() || IgniteCacheConfigVariationsQueryTest.this.cacheMode() != CacheMode.REPLICATED && !IgniteCacheConfigVariationsQueryTest.this.testedGrid().affinity(IgniteCacheConfigVariationsQueryTest.this.cacheName()).isPrimary(locNode, key) || !filter.apply(key, val)) continue;
                        map.put(key, val);
                    }
                    IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(map, true);
                    QueryCursor q = cache.query((Query)new ScanQuery((IgniteBiPredicate)filter).setLocal(true));
                    IgniteCacheConfigVariationsQueryTest.this.checkQueryResults(map, (QueryCursor<Cache.Entry<Object, Object>>)q);
                }
                finally {
                    IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    @Test
    public void testScanQueryPartitionFilter() throws Exception {
        this.runInAllDataModes(new IgniteConfigVariationsAbstractTest.TestRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                IgniteCache cache = IgniteCacheConfigVariationsQueryTest.this.jcache();
                Affinity affinity = IgniteCacheConfigVariationsQueryTest.this.testedGrid().affinity(IgniteCacheConfigVariationsQueryTest.this.cacheName());
                HashMap<Integer, HashMap<Object, Object>> partMap = new HashMap<Integer, HashMap<Object, Object>>();
                IgniteBiPredicate<Object, Object> filter = new IgniteBiPredicate<Object, Object>(){

                    public boolean apply(Object k, Object v) {
                        Assert.assertNotNull((Object)k);
                        Assert.assertNotNull((Object)v);
                        return IgniteConfigVariationsAbstractTest.valueOf((Object)k) >= 20 && IgniteConfigVariationsAbstractTest.valueOf((Object)v) < 40;
                    }
                };
                for (int i = 0; i < 50; ++i) {
                    Object key = IgniteCacheConfigVariationsQueryTest.this.key(i);
                    Object val = IgniteCacheConfigVariationsQueryTest.this.value(i);
                    cache.put(key, val);
                    if (!filter.apply(key, val)) continue;
                    int part = affinity.partition(key);
                    HashMap<Object, Object> map = (HashMap<Object, Object>)partMap.get(part);
                    if (map == null) {
                        map = new HashMap<Object, Object>();
                        partMap.put(part, map);
                    }
                    map.put(key, val);
                }
                for (int part = 0; part < affinity.partitions(); ++part) {
                    try {
                        Map expMap = (Map)partMap.get(part);
                        expMap = expMap == null ? Collections.emptyMap() : expMap;
                        IgniteCacheConfigVariationsQueryTest.this.registerEventListeners(expMap, true);
                        QueryCursor q = cache.query((Query)new ScanQuery(Integer.valueOf(part), (IgniteBiPredicate)filter));
                        IgniteCacheConfigVariationsQueryTest.this.checkQueryResults(expMap, (QueryCursor<Cache.Entry<Object, Object>>)q);
                        continue;
                    }
                    finally {
                        IgniteCacheConfigVariationsQueryTest.this.stopListeners();
                    }
                }
            }
        }, new IgniteConfigVariationsAbstractTest.DataMode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueryResults(Map<Object, Object> expMap, QueryCursor<Cache.Entry<Object, Object>> cursor) throws InterruptedException {
        Iterator iter = cursor.iterator();
        try {
            IgniteCacheConfigVariationsQueryTest.assertNotNull((Object)iter);
            int cnt = 0;
            while (iter.hasNext()) {
                Cache.Entry e = (Cache.Entry)iter.next();
                IgniteCacheConfigVariationsQueryTest.assertNotNull((Object)e.getKey());
                IgniteCacheConfigVariationsQueryTest.assertNotNull((Object)e.getValue());
                Object expVal = expMap.get(e.getKey());
                IgniteCacheConfigVariationsQueryTest.assertNotNull((String)("Failed to resolve expected value for key: " + e.getKey()), (Object)expVal);
                IgniteCacheConfigVariationsQueryTest.assertEquals((Object)expVal, (Object)e.getValue());
                ++cnt;
            }
            IgniteCacheConfigVariationsQueryTest.assertEquals((int)expMap.size(), (int)cnt);
        }
        finally {
            cursor.close();
        }
        this.checkEvents();
    }

    private void registerEventListeners(Map<Object, Object> expMap) {
        this.registerEventListeners(expMap, false);
    }

    private void registerEventListeners(Map<Object, Object> expMap, final boolean filterExp) {
        this.expMap = expMap != null ? expMap : Collections.emptyMap();
        HashSet<ClusterNode> affNodes = new HashSet<ClusterNode>();
        if (this.cacheMode() != CacheMode.REPLICATED) {
            Affinity aff = this.testedGrid().affinity(this.cacheName());
            for (Object key : this.expMap.keySet()) {
                affNodes.add(aff.mapKeyToNode(key));
            }
        }
        int execEvtCnt = this.cacheMode() == CacheMode.REPLICATED || this.cacheMode() == CacheMode.PARTITIONED && affNodes.isEmpty() ? 1 : affNodes.size();
        this.evtMap = new ConcurrentHashMap<Object, Object>();
        this.readEvtLatch = new CountDownLatch(this.expMap.size());
        this.execEvtLatch = new CountDownLatch(execEvtCnt);
        this.objReadLsnrs = new IgnitePredicate[this.gridCount()];
        this.qryExecLsnrs = new IgnitePredicate[this.gridCount()];
        for (int i = 0; i < this.gridCount(); ++i) {
            IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    Assert.assertTrue((String)("Event: " + evt), (boolean)(evt instanceof CacheQueryReadEvent));
                    CacheQueryReadEvent qe = (CacheQueryReadEvent)evt;
                    Assert.assertEquals((String)CacheQueryType.SCAN.name(), (String)qe.queryType());
                    Assert.assertEquals((String)IgniteCacheConfigVariationsQueryTest.this.cacheName(), (String)qe.cacheName());
                    Assert.assertNull((Object)qe.className());
                    Assert.assertNull((Object)qe.clause());
                    Assert.assertEquals((boolean)filterExp, (qe.scanQueryFilter() != null ? 1 : 0) != 0);
                    Assert.assertNull((Object)qe.continuousQueryFilter());
                    Assert.assertNull((Object)qe.arguments());
                    IgniteCacheConfigVariationsQueryTest.this.evtMap.put(qe.key(), qe.value());
                    Assert.assertFalse((IgniteCacheConfigVariationsQueryTest.this.readEvtLatch.getCount() == 0L ? 1 : 0) != 0);
                    IgniteCacheConfigVariationsQueryTest.this.readEvtLatch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)pred, new int[]{97});
            this.objReadLsnrs[i] = pred;
            IgnitePredicate<Event> execPred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    Assert.assertTrue((String)("Event: " + evt), (boolean)(evt instanceof CacheQueryExecutedEvent));
                    CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                    Assert.assertEquals((String)CacheQueryType.SCAN.name(), (String)qe.queryType());
                    Assert.assertEquals((String)IgniteCacheConfigVariationsQueryTest.this.cacheName(), (String)qe.cacheName());
                    Assert.assertNull((Object)qe.className());
                    Assert.assertNull((Object)qe.clause());
                    Assert.assertEquals((boolean)filterExp, (qe.scanQueryFilter() != null ? 1 : 0) != 0);
                    Assert.assertNull((Object)qe.continuousQueryFilter());
                    Assert.assertNull((Object)qe.arguments());
                    Assert.assertFalse((String)"Too many events.", (IgniteCacheConfigVariationsQueryTest.this.execEvtLatch.getCount() == 0L ? 1 : 0) != 0);
                    IgniteCacheConfigVariationsQueryTest.this.execEvtLatch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)execPred, new int[]{96});
            this.qryExecLsnrs[i] = execPred;
        }
    }

    private void stopListeners() {
        for (int i = 0; i < this.gridCount(); ++i) {
            this.grid(i).events().stopLocalListen(this.objReadLsnrs[i], new int[0]);
            this.grid(i).events().stopLocalListen(this.qryExecLsnrs[i], new int[0]);
        }
    }

    private void checkEvents() throws InterruptedException {
        IgniteCacheConfigVariationsQueryTest.assertTrue((boolean)this.execEvtLatch.await(1000L, TimeUnit.MILLISECONDS));
        IgniteCacheConfigVariationsQueryTest.assertTrue((boolean)this.readEvtLatch.await(1000L, TimeUnit.MILLISECONDS));
        IgniteCacheConfigVariationsQueryTest.assertEquals((int)this.expMap.size(), (int)this.evtMap.size());
        for (Map.Entry<Object, Object> e : this.expMap.entrySet()) {
            IgniteCacheConfigVariationsQueryTest.assertEquals((Object)e.getValue(), (Object)this.evtMap.get(e.getKey()));
        }
    }
}

