/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheQueryTestValue;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class IgniteCacheAbstractQuerySelfTest
extends GridCommonAbstractTest {
    private static final int KEY_CNT = 5000;
    private static TestStore store = new TestStore();

    protected abstract int gridCount();

    protected abstract CacheMode cacheMode();

    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.TRANSACTIONAL;
    }

    protected NearCacheConfiguration nearCacheConfiguration() {
        return new NearCacheConfiguration();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        ((TcpDiscoverySpi)c.getDiscoverySpi()).setForceServerMode(true);
        if (igniteInstanceName.startsWith("client")) {
            c.setClientMode(true);
            c.setDataStorageConfiguration(new DataStorageConfiguration());
        }
        return c;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cc = IgniteCacheAbstractQuerySelfTest.defaultCacheConfiguration();
        cc.setCacheMode(this.cacheMode());
        cc.setAtomicityMode(this.atomicityMode());
        cc.setNearConfiguration(this.nearCacheConfiguration());
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setCacheStoreFactory((Factory)new StoreFactory());
        cc.setReadThrough(true);
        cc.setWriteThrough(true);
        cc.setLoadPreviousValue(true);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setSqlFunctionClasses(new Class[]{SqlFunctions.class});
        ArrayList<QueryEntity> entityList = new ArrayList<QueryEntity>();
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(Type1.class.getName());
        qryEntity.addQueryField("id", Integer.class.getName(), null);
        qryEntity.addQueryField("name", String.class.getName(), null);
        qryEntity.setTableName("Type2");
        qryEntity.setIndexes(Arrays.asList(new QueryIndex("id").setName("index~!@#$%^&*()_=-+;[]{}|?,.*`:nameWithNonLetterSymbols")));
        entityList.add(qryEntity);
        qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(Type2.class.getName());
        qryEntity.addQueryField("id", Integer.class.getName(), null);
        qryEntity.addQueryField("name", String.class.getName(), null);
        qryEntity.setTableName("Type1");
        qryEntity.setIndexes(Arrays.asList(new QueryIndex("id")));
        entityList.add(qryEntity);
        qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(ObjectValue2.class.getName());
        qryEntity.addQueryField("strVal", String.class.getName(), null);
        QueryIndex strIdx = new QueryIndex();
        strIdx.setFieldNames(Collections.singletonList("strVal"), true);
        qryEntity.setIndexes(Arrays.asList(strIdx));
        entityList.add(qryEntity);
        cc.setQueryEntities(entityList);
        if (this.cacheMode() != CacheMode.LOCAL) {
            cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction());
        }
        if (this.cacheMode() == CacheMode.PARTITIONED) {
            cc.setBackups(this.gridCount());
        }
        return cc;
    }

    protected <K, V> IgniteCache<K, V> jcache(Class<K> clsK, Class<V> clsV) {
        return this.jcache(this.ignite(), clsK, clsV);
    }

    protected <K, V> IgniteCache<K, V> jcache(Ignite ig, Class<K> clsK, Class<V> clsV) {
        IgniteCache cache = this.jcache(ig, this.cacheConfiguration(), clsK, clsV);
        return cache;
    }

    protected boolean snapshotableIndex() {
        return false;
    }

    protected Ignite ignite() {
        return this.grid(0);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (String cacheName : this.ignite().cacheNames()) {
            this.ignite().cache(cacheName).destroy();
        }
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(this.gridCount());
    }

    protected void afterTestsStopped() throws Exception {
        store.reset();
    }

    @Test
    public void testDifferentKeyTypes() throws Exception {
        IgniteCache<Object, Object> cache = this.jcache(Object.class, Object.class);
        cache.put((Object)1, (Object)"value");
        cache.put((Object)"key", (Object)"value");
    }

    @Test
    public void testDifferentValueTypes() throws Exception {
        IgniteCache<Integer, Object> cache = this.jcache(Integer.class, Object.class);
        cache.put((Object)7, (Object)"value");
        cache.put((Object)7, (Object)1);
    }

    @Test
    public void testStringType() throws Exception {
        IgniteCache<Integer, String> cache = this.jcache(Integer.class, String.class);
        cache.put((Object)666, (Object)"test");
        QueryCursor qry = cache.query((Query)new SqlQuery(String.class, "_val='test'"));
        Cache.Entry entry = (Cache.Entry)F.first((List)qry.getAll());
        assert (entry != null);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)666, (int)((Integer)entry.getKey()));
    }

    @Test
    public void testIntegerType() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        int key = 898;
        int val = 2;
        cache.put((Object)key, (Object)val);
        QueryCursor qry = cache.query((Query)new SqlQuery(Integer.class, "_key = ? and _val > 1").setArgs(new Object[]{key}));
        Cache.Entry entry = (Cache.Entry)F.first((List)qry.getAll());
        assert (entry != null);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)key, (int)((Integer)entry.getKey()));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)val, (int)((Integer)entry.getValue()));
    }

    @Test
    public void testTableAliasInSqlQuery() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        int key = 898;
        int val = 2;
        cache.put((Object)key, (Object)val);
        SqlQuery sqlQry = new SqlQuery(Integer.class, "t1._key = ? and t1._val > 1");
        QueryCursor qry = cache.query((Query)sqlQry.setAlias("t1").setArgs(new Object[]{key}));
        Cache.Entry entry = (Cache.Entry)F.first((List)qry.getAll());
        assert (entry != null);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)key, (int)((Integer)entry.getKey()));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)val, (int)((Integer)entry.getValue()));
        sqlQry = new SqlQuery(Integer.class, "FROM Integer as t1 WHERE t1._key = ? and t1._val > 1");
        qry = cache.query((Query)sqlQry.setAlias("t1").setArgs(new Object[]{key}));
        entry = (Cache.Entry)F.first((List)qry.getAll());
        assert (entry != null);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)key, (int)((Integer)entry.getKey()));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)val, (int)((Integer)entry.getValue()));
    }

    @Test
    public void testUserDefinedFunction() throws IgniteCheckedException {
        final IgniteCache<Object, Object> cache = this.jcache(Object.class, Object.class);
        FieldsQueryCursor qry = cache.query(new SqlFieldsQuery("select square(1), square(2)"));
        List res = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)res.size());
        List row = (List)res.iterator().next();
        IgniteCacheAbstractQuerySelfTest.assertEquals((Object)1, row.get(0));
        IgniteCacheAbstractQuerySelfTest.assertEquals((Object)4, row.get(1));
        qry = cache.query(new SqlFieldsQuery("select _cube_(1), _cube_(2)"));
        res = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)res.size());
        row = (List)res.iterator().next();
        IgniteCacheAbstractQuerySelfTest.assertEquals((Object)1, row.get(0));
        IgniteCacheAbstractQuerySelfTest.assertEquals((Object)8, row.get(1));
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                cache.query(new SqlFieldsQuery("select no()"));
                return null;
            }
        }, CacheException.class, null);
    }

    @Test
    public void testExpiration() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        cache.withExpiryPolicy((ExpiryPolicy)new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 1000L))).put((Object)7, (Object)1);
        List qry = cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll();
        Cache.Entry res = (Cache.Entry)F.first((List)qry);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)((Integer)res.getValue()));
        U.sleep((long)300L);
        qry = cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll();
        res = (Cache.Entry)F.first((List)qry);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)((Integer)res.getValue()));
        U.sleep((long)1800L);
        qry = cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll();
        res = (Cache.Entry)F.first((List)qry);
        IgniteCacheAbstractQuerySelfTest.assertNull((Object)res);
    }

    @Test
    public void testIllegalBounds() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        QueryCursor qry = cache.query((Query)new SqlQuery(Integer.class, "_key between 2 and 1"));
        IgniteCacheAbstractQuerySelfTest.assertTrue((boolean)qry.getAll().isEmpty());
    }

    @Test
    public void testComplexType() throws Exception {
        IgniteCache<Key, GridCacheQueryTestValue> cache = this.jcache(Key.class, GridCacheQueryTestValue.class);
        GridCacheQueryTestValue val1 = new GridCacheQueryTestValue();
        val1.setField1("field1");
        val1.setField2(1);
        val1.setField3(1L);
        GridCacheQueryTestValue val2 = new GridCacheQueryTestValue();
        val2.setField1("field2");
        val2.setField2(2);
        val2.setField3(2L);
        val2.setField6(null);
        cache.put((Object)new Key(100500L), (Object)val1);
        cache.put((Object)new Key(100501L), (Object)val2);
        QueryCursor qry = cache.query((Query)new SqlQuery(GridCacheQueryTestValue.class, "fieldName='field1' and field2=1 and field3=1 and id=100500 and embeddedField2=11 and x=3"));
        Cache.Entry entry = (Cache.Entry)F.first((List)qry.getAll());
        IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)entry);
        IgniteCacheAbstractQuerySelfTest.assertEquals((long)100500L, (long)((Key)entry.getKey()).id);
        IgniteCacheAbstractQuerySelfTest.assertEquals((Object)val1, (Object)entry.getValue());
    }

    @Test
    public void testComplexTypeKeepBinary() throws Exception {
        if (this.ignite().configuration().getMarshaller() == null || this.ignite().configuration().getMarshaller() instanceof BinaryMarshaller) {
            IgniteCache<Key, GridCacheQueryTestValue> cache = this.jcache(Key.class, GridCacheQueryTestValue.class);
            GridCacheQueryTestValue val1 = new GridCacheQueryTestValue();
            val1.setField1("field1");
            val1.setField2(1);
            val1.setField3(1L);
            GridCacheQueryTestValue val2 = new GridCacheQueryTestValue();
            val2.setField1("field2");
            val2.setField2(2);
            val2.setField3(2L);
            val2.setField6(null);
            cache.put((Object)new Key(100500L), (Object)val1);
            cache.put((Object)new Key(100501L), (Object)val2);
            QueryCursor qry = cache.withKeepBinary().query((Query)new SqlQuery(GridCacheQueryTestValue.class, "fieldName='field1' and field2=1 and field3=1 and id=100500 and embeddedField2=11 and x=3"));
            Cache.Entry entry = (Cache.Entry)F.first((List)qry.getAll());
            IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)entry);
            IgniteCacheAbstractQuerySelfTest.assertEquals((Object)100500L, (Object)((BinaryObject)entry.getKey()).field("id"));
            IgniteCacheAbstractQuerySelfTest.assertEquals((Object)val1, (Object)((BinaryObject)entry.getValue()).deserialize());
        }
    }

    @Test
    public void testSelectQuery() throws Exception {
        IgniteCache<Integer, String> cache = this.jcache(Integer.class, String.class);
        cache.put((Object)10, (Object)"value");
        QueryCursor qry = cache.query((Query)new SqlQuery(String.class, "true"));
        Iterator iter = qry.iterator();
        assert (iter != null);
        assert (iter.next() != null);
    }

    @Test
    public void testSimpleCustomTableName() {
        CacheConfiguration cacheConf = new CacheConfiguration((CompleteConfiguration)this.cacheConfiguration()).setName("default").setQueryEntities(Arrays.asList(new QueryEntity(Integer.class, Type1.class), new QueryEntity(Integer.class, Type2.class)));
        final IgniteCache cache = this.ignite().getOrCreateCache(cacheConf);
        cache.put((Object)10, (Object)new Type1(1, "Type1 record #1"));
        cache.put((Object)20, (Object)new Type1(2, "Type1 record #2"));
        QueryCursor qry1 = cache.query((Query)new SqlQuery(Type1.class, "FROM Type2"));
        List all = qry1.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)all.size());
        FieldsQueryCursor qry = cache.query(new SqlFieldsQuery("SELECT name FROM Type2"));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)qry.getAll().size());
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new GridPlainCallable<Void>(){

            public Void call() throws Exception {
                QueryCursor qry = cache.query((Query)new SqlQuery(Type1.class, "FROM Type1"));
                qry.getAll();
                return null;
            }
        }, CacheException.class, null);
    }

    @Test
    public void testMixedCustomTableName() throws Exception {
        final IgniteCache<Integer, Object> cache = this.jcache(Integer.class, Object.class);
        cache.put((Object)10, (Object)new Type1(1, "Type1 record #1"));
        cache.put((Object)20, (Object)new Type1(2, "Type1 record #2"));
        cache.put((Object)30, (Object)new Type2(1, "Type2 record #1"));
        cache.put((Object)40, (Object)new Type2(2, "Type2 record #2"));
        cache.put((Object)50, (Object)new Type2(3, "Type2 record #3"));
        QueryCursor qry1 = cache.query((Query)new SqlQuery(Type1.class, "FROM Type2"));
        List all = qry1.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)all.size());
        QueryCursor qry2 = cache.query((Query)new SqlQuery(Type2.class, "FROM Type1"));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)3, (int)qry2.getAll().size());
        FieldsQueryCursor qry = cache.query(new SqlFieldsQuery("SELECT name FROM Type1"));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)3, (int)qry.getAll().size());
        qry = cache.query(new SqlFieldsQuery("SELECT name FROM Type2"));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)qry.getAll().size());
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new GridPlainCallable<Void>(){

            public Void call() throws Exception {
                QueryCursor qry1 = cache.query((Query)new SqlQuery(Type1.class, "FROM Type1"));
                qry1.getAll().size();
                return null;
            }
        }, CacheException.class, null);
    }

    @Test
    public void testDistributedJoinCustomTableName() throws Exception {
        IgniteCache<Integer, Object> cache = this.jcache(Integer.class, Object.class);
        cache.put((Object)10, (Object)new Type1(1, "Type1 record #1"));
        cache.put((Object)20, (Object)new Type1(2, "Type1 record #2"));
        cache.put((Object)30, (Object)new Type2(1, "Type2 record #1"));
        cache.put((Object)40, (Object)new Type2(2, "Type2 record #2"));
        cache.put((Object)50, (Object)new Type2(3, "Type2 record #3"));
        FieldsQueryCursor query = cache.query(new SqlFieldsQuery("SELECT t2.name, t1.name FROM Type2 as t2 LEFT JOIN Type1 as t1 ON t1.id = t2.id").setDistributedJoins(this.cacheMode() == CacheMode.PARTITIONED));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)query.getAll().size());
        query = cache.query(new SqlFieldsQuery("SELECT t2.name, t1.name FROM Type2 as t2 RIGHT JOIN Type1 as t1 ON t1.id = t2.id").setDistributedJoins(this.cacheMode() == CacheMode.PARTITIONED));
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)3, (int)query.getAll().size());
    }

    @Test
    public void testObjectQuery() throws Exception {
        int i;
        IgniteCache<Integer, ObjectValue> cache = this.jcache(Integer.class, ObjectValue.class);
        ObjectValue val = new ObjectValue("test", 0);
        cache.put((Object)1, (Object)val);
        QueryCursor qry = cache.query((Query)new SqlQuery(ObjectValue.class, "_val=?").setArgs(new Object[]{val}));
        Iterator iter = qry.iterator();
        assert (iter != null);
        int expCnt = 1;
        for (i = 0; i < expCnt; ++i) {
            assert (iter.next() != null);
        }
        assert (!iter.hasNext());
        qry = cache.query((Query)new TextQuery(ObjectValue.class, "test"));
        iter = qry.iterator();
        assert (iter != null);
        for (i = 0; i < expCnt; ++i) {
            assert (iter.next() != null);
        }
        assert (!iter.hasNext());
    }

    @Test
    public void testObjectWithString() throws Exception {
        IgniteCache<Integer, ObjectValue2> cache = this.jcache(Integer.class, ObjectValue2.class);
        cache.put((Object)1, (Object)new ObjectValue2("value 1"));
        cache.put((Object)2, (Object)new ObjectValue2("value 2"));
        cache.put((Object)3, (Object)new ObjectValue2("value 3"));
        QueryCursor qry = cache.query((Query)new SqlQuery(ObjectValue2.class, "strVal like ?").setArgs(new Object[]{"value%"}));
        int expCnt = 3;
        List results = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)expCnt, (int)results.size());
        qry = cache.query((Query)new SqlQuery(ObjectValue2.class, "strVal > ?").setArgs(new Object[]{"value 1"}));
        results = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)(expCnt - 1), (int)results.size());
        qry = cache.query((Query)new TextQuery(ObjectValue2.class, "value"));
        results = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testEnumObjectQuery() throws Exception {
        IgniteCache<Long, EnumObject> cache = this.jcache(Long.class, EnumObject.class);
        for (long i = 0L; i < 50L; ++i) {
            cache.put((Object)i, (Object)new EnumObject(i, i % 2L == 0L ? EnumType.TYPE_A : EnumType.TYPE_B));
        }
        this.assertEnumQry("type = ?", (Object)EnumType.TYPE_A, EnumType.TYPE_A, cache, 25);
        this.assertEnumQry("type > ?", (Object)EnumType.TYPE_A, EnumType.TYPE_B, cache, 25);
        this.assertEnumQry("type < ?", (Object)EnumType.TYPE_B, EnumType.TYPE_A, cache, 25);
        this.assertEnumQry("type != ?", (Object)EnumType.TYPE_B, EnumType.TYPE_A, cache, 25);
        this.assertEmptyEnumQry("type = ?", null, cache);
        this.assertEmptyEnumQry("type > ?", (Object)EnumType.TYPE_B, cache);
        this.assertEmptyEnumQry("type < ?", (Object)EnumType.TYPE_A, cache);
        cache.put((Object)50L, (Object)new EnumObject(50L, null));
        this.assertNoArgEnumQry("type is null", null, cache, 1);
        this.assertAnyResTypeEnumQry("type is not null", cache, 50);
        IgniteBinary binary = this.ignite().binary();
        if (binary != null) {
            this.assertEnumQry("type = ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_A), EnumType.TYPE_A, cache, 25);
            this.assertEnumQry("type > ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_A), EnumType.TYPE_B, cache, 25);
            this.assertEnumQry("type < ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_B), EnumType.TYPE_A, cache, 25);
            this.assertEnumQry("type != ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_B), EnumType.TYPE_A, cache, 25);
            this.assertEmptyEnumQry("type > ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_B), cache);
            this.assertEmptyEnumQry("type < ?", IgniteCacheAbstractQuerySelfTest.binaryEnum(binary, EnumType.TYPE_A), cache);
        }
    }

    private static BinaryObject binaryEnum(IgniteBinary binary, EnumType val) {
        return binary.buildEnum(EnumType.class.getName(), val.ordinal());
    }

    private void assertAnyResTypeEnumQry(String qryStr, IgniteCache<Long, EnumObject> cache, int resSize) {
        SqlQuery qry = new SqlQuery(EnumObject.class, qryStr);
        List res = cache.query((Query)qry).getAll();
        assert (resSize == res.size());
    }

    private void assertNoArgEnumQry(String qryStr, EnumType resType, IgniteCache<Long, EnumObject> cache, int resSize) {
        SqlQuery qry = new SqlQuery(EnumObject.class, qryStr);
        List res = cache.query((Query)qry).getAll();
        assert (resSize == res.size());
        this.assertEnumType(res, resType);
    }

    private void assertEnumQry(String qryStr, Object arg, EnumType resType, IgniteCache<Long, EnumObject> cache, int resSize) {
        SqlQuery qry = new SqlQuery(EnumObject.class, qryStr);
        qry.setArgs(new Object[]{arg});
        List res = cache.query((Query)qry).getAll();
        assert (resSize == res.size());
        this.assertEnumType(res, resType);
    }

    private void assertEmptyEnumQry(String qryStr, Object arg, IgniteCache<Long, EnumObject> cache) {
        SqlQuery qry = new SqlQuery(EnumObject.class, qryStr);
        qry.setArgs(new Object[]{arg});
        List res = cache.query((Query)qry).getAll();
        assert (res.isEmpty());
    }

    private void assertEnumType(List<Cache.Entry<Long, EnumObject>> enumObjects, EnumType enumType) {
        for (Cache.Entry<Long, EnumObject> entry : enumObjects) {
            assert (((EnumObject)entry.getValue()).type == enumType);
        }
    }

    @Test
    public void testObjectQueryWithSwap() {
        CacheConfiguration config = new CacheConfiguration((CompleteConfiguration)this.cacheConfiguration());
        config.setOnheapCacheEnabled(true);
        IgniteCache cache = this.jcache(this.ignite(), config, Integer.class, ObjectValue.class);
        boolean partitioned = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getCacheMode() == CacheMode.PARTITIONED;
        int cnt = 10;
        for (int i = 0; i < cnt; ++i) {
            cache.put((Object)i, (Object)new ObjectValue("test" + i, i));
        }
        for (Ignite g : G.allGrids()) {
            IgniteCache c = g.cache(cache.getName());
            for (int i = 0; i < cnt; ++i) {
                IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)c.localPeek((Object)i, new CachePeekMode[]{CachePeekMode.ONHEAP}));
                c.localEvict(Collections.singleton(i));
                if (partitioned && !g.affinity(cache.getName()).mapKeyToNode((Object)i).isLocal()) continue;
                ObjectValue peekVal = (ObjectValue)c.localPeek((Object)i, new CachePeekMode[]{CachePeekMode.ONHEAP});
                IgniteCacheAbstractQuerySelfTest.assertNull((String)("Non-null value for peek [key=" + i + ", val=" + peekVal + ']'), (Object)peekVal);
            }
        }
        QueryCursor qry = cache.query((Query)new SqlQuery(ObjectValue.class, "intVal >= ? order by intVal").setArgs(new Object[]{0}));
        Iterator iter = qry.iterator();
        assert (iter != null);
        HashSet<Integer> set = new HashSet<Integer>(cnt);
        while (iter.hasNext()) {
            Cache.Entry next = (Cache.Entry)iter.next();
            ObjectValue v = (ObjectValue)next.getValue();
            assert (!set.contains(v.intValue()));
            set.add(v.intValue());
        }
        assert (!iter.hasNext());
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)cnt, (int)set.size());
        for (int i = 0; i < cnt; ++i) {
            assert (set.contains(i));
        }
        qry = cache.query((Query)new SqlQuery(ObjectValue.class, "MOD(intVal, 2) = ? order by intVal").setArgs(new Object[]{0}));
        iter = qry.iterator();
        assert (iter != null);
        set.clear();
        while (iter.hasNext()) {
            Cache.Entry next = (Cache.Entry)iter.next();
            ObjectValue v = (ObjectValue)next.getValue();
            assert (!set.contains(v.intValue()));
            set.add(v.intValue());
        }
        assert (!iter.hasNext());
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)(cnt / 2), (int)set.size());
        for (int i = 0; i < cnt; ++i) {
            if (i % 2 == 0 ? !$assertionsDisabled && !set.contains(i) : !$assertionsDisabled && set.contains(i)) {
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testFullTextSearch() throws Exception {
        IgniteCache<Integer, ObjectValue> cache = this.jcache(Integer.class, ObjectValue.class);
        QueryCursor qry = cache.query((Query)new TextQuery(ObjectValue.class, "full"));
        assert (qry.getAll().isEmpty());
        qry = cache.query((Query)new TextQuery(ObjectValue.class, "full"));
        assert (qry.getAll().isEmpty());
        int key1 = 1;
        ObjectValue val1 = new ObjectValue("test full text", 0);
        cache.put((Object)key1, (Object)val1);
        int key2 = 2;
        ObjectValue val2 = new ObjectValue("test full text more", 0);
        cache.put((Object)key2, (Object)val2);
        qry = cache.query((Query)new TextQuery(ObjectValue.class, "full"));
        List res = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)res);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)res.size());
        qry = cache.query((Query)new TextQuery(ObjectValue.class, "full"));
        res = qry.getAll();
        IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)res);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)res.size());
    }

    @Test
    public void testScanQuery() throws Exception {
        IgniteCache<Integer, String> c1 = this.jcache(Integer.class, String.class);
        HashMap<Integer, String> map = new HashMap<Integer, String>(){
            {
                for (int i = 0; i < 5000; ++i) {
                    this.put(i, "str" + i);
                }
            }
        };
        for (Map.Entry e : map.entrySet()) {
            c1.put(e.getKey(), e.getValue());
        }
        QueryCursor qry = c1.query((Query)new ScanQuery());
        Iterator iter = qry.iterator();
        assert (iter != null);
        int cnt = 0;
        while (iter.hasNext()) {
            Cache.Entry e = (Cache.Entry)iter.next();
            String expVal = (String)map.get(e.getKey());
            IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)expVal);
            IgniteCacheAbstractQuerySelfTest.assertEquals((String)expVal, (String)((String)e.getValue()));
            ++cnt;
        }
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)map.size(), (int)cnt);
    }

    @Test
    public void testScanPartitionQuery() throws Exception {
        int i;
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        GridCacheContext cctx = ((IgniteCacheProxy)cache).context();
        HashMap<Integer, HashMap<Integer, Integer>> entries = new HashMap<Integer, HashMap<Integer, Integer>>();
        for (i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
            int part = cctx.affinity().partition((Object)i);
            HashMap<Integer, Integer> partEntries = (HashMap<Integer, Integer>)entries.get(part);
            if (partEntries == null) {
                partEntries = new HashMap<Integer, Integer>();
                entries.put(part, partEntries);
            }
            partEntries.put(i, i);
        }
        for (i = 0; i < cctx.affinity().partitions(); ++i) {
            ScanQuery scan = new ScanQuery(i);
            List actual = cache.query((Query)scan).getAll();
            Map exp = (Map)entries.get(i);
            int size = exp == null ? 0 : exp.size();
            IgniteCacheAbstractQuerySelfTest.assertEquals((String)("Failed for partition: " + i), (int)size, (int)actual.size());
            if (exp == null) {
                IgniteCacheAbstractQuerySelfTest.assertTrue((boolean)actual.isEmpty());
                continue;
            }
            for (Cache.Entry entry : actual) {
                IgniteCacheAbstractQuerySelfTest.assertTrue((boolean)((Integer)entry.getValue()).equals(exp.get(entry.getKey())));
            }
        }
    }

    @Test
    public void testTwoObjectsTextSearch() {
        CacheConfiguration conf = new CacheConfiguration((CompleteConfiguration)this.cacheConfiguration());
        conf.setQueryEntities(Arrays.asList(new QueryEntity(Integer.class, ObjectValue.class), new QueryEntity(String.class, ObjectValueOther.class)));
        IgniteCache c = this.jcache(this.ignite(), conf, Object.class, Object.class);
        c.put((Object)1, (Object)new ObjectValue("ObjectValue str", 1));
        c.put((Object)"key", (Object)new ObjectValueOther("ObjectValueOther str"));
        List res = c.query((Query)new TextQuery(ObjectValue.class, "str")).getAll();
        assert (res != null);
        int expCnt = 1;
        assert (res.size() == expCnt);
        assert (((Cache.Entry)F.first((Iterable)res)).getValue().getClass() == ObjectValue.class);
        res = c.query((Query)new TextQuery(ObjectValueOther.class, "str")).getAll();
        assert (res != null);
        assert (res.size() == expCnt);
        assert (((Cache.Entry)F.first((Iterable)res)).getValue().getClass() == ObjectValueOther.class);
    }

    @Test
    public void testPrimitiveType() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_val > 1"));
        List res = q.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)res.size());
        for (Cache.Entry e : res) {
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)((Integer)e.getKey()));
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)((Integer)e.getValue()));
        }
    }

    @Test
    public void testPaginationIteratorDefaultCache() throws Exception {
        this.testPaginationIterator((IgniteCache<Integer, Integer>)this.jcache(this.ignite(), this.cacheConfiguration(), "default", Integer.class, Integer.class));
    }

    @Test
    public void testPaginationIteratorNamedCache() throws Exception {
        this.testPaginationIterator((IgniteCache<Integer, Integer>)this.jcache(this.ignite(), this.cacheConfiguration(), Integer.class, Integer.class));
    }

    private void testPaginationIterator(IgniteCache<Integer, Integer> cache) throws Exception {
        for (int i = 0; i < 50; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SqlQuery qry = new SqlQuery(Integer.class, "_key >= 0");
        qry.setPageSize(10);
        QueryCursor q = cache.query((Query)qry);
        int cnt = 0;
        for (Cache.Entry e : q) {
            IgniteCacheAbstractQuerySelfTest.assertTrue(((Integer)e.getKey() >= 0 && (Integer)e.getKey() < 50 ? 1 : 0) != 0);
            IgniteCacheAbstractQuerySelfTest.assertTrue(((Integer)e.getValue() >= 0 && (Integer)e.getValue() < 50 ? 1 : 0) != 0);
            ++cnt;
        }
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)50, (int)cnt);
    }

    @Test
    public void testPaginationGetDefaultCache() throws Exception {
        this.testPaginationGet((IgniteCache<Integer, Integer>)this.jcache(this.ignite(), this.cacheConfiguration(), "default", Integer.class, Integer.class));
    }

    @Test
    public void testPaginationGetNamedCache() throws Exception {
        this.testPaginationGet((IgniteCache<Integer, Integer>)this.jcache(this.ignite(), this.cacheConfiguration(), Integer.class, Integer.class));
    }

    private void testPaginationGet(IgniteCache<Integer, Integer> cache) throws Exception {
        for (int i = 0; i < 50; ++i) {
            cache.put((Object)i, (Object)i);
        }
        QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_key >= 0"));
        ArrayList list = new ArrayList(q.getAll());
        Collections.sort(list, new Comparator<Cache.Entry<Integer, Integer>>(){

            @Override
            public int compare(Cache.Entry<Integer, Integer> e1, Cache.Entry<Integer, Integer> e2) {
                return ((Integer)e1.getKey()).compareTo((Integer)e2.getKey());
            }
        });
        for (int i = 0; i < 50; ++i) {
            Cache.Entry e = (Cache.Entry)list.get(i);
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getKey()));
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getValue()));
        }
    }

    @Test
    public void testScanFilters() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        for (int i = 0; i < 50; ++i) {
            cache.put((Object)i, (Object)i);
        }
        QueryCursor q = cache.query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<Integer, Integer>(){

            public boolean apply(Integer k, Integer v) {
                junit.framework.Assert.assertNotNull((Object)k);
                junit.framework.Assert.assertNotNull((Object)v);
                return k >= 20 && v < 40;
            }
        }));
        ArrayList list = new ArrayList(q.getAll());
        Collections.sort(list, new Comparator<Cache.Entry<Integer, Integer>>(){

            @Override
            public int compare(Cache.Entry<Integer, Integer> e1, Cache.Entry<Integer, Integer> e2) {
                return ((Integer)e1.getKey()).compareTo((Integer)e2.getKey());
            }
        });
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)20, (int)list.size());
        for (int i = 20; i < 40; ++i) {
            Cache.Entry e = (Cache.Entry)list.get(i - 20);
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getKey()));
            IgniteCacheAbstractQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getValue()));
        }
    }

    @Test
    public void testBadHashObjectKey() throws IgniteCheckedException {
        IgniteCache<BadHashKeyObject, Byte> cache = this.jcache(BadHashKeyObject.class, Byte.class);
        cache.put((Object)new BadHashKeyObject("test_key1"), (Object)1);
        cache.put((Object)new BadHashKeyObject("test_key0"), (Object)10);
        cache.put((Object)new BadHashKeyObject("test_key1"), (Object)7);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)10, (int)((Byte)((Cache.Entry)cache.query((Query)new SqlQuery(Byte.class, "_key = ?").setArgs(new Object[]{new BadHashKeyObject("test_key0")})).getAll().get(0)).getValue()).intValue());
    }

    @Test
    public void testTextIndexedKey() throws IgniteCheckedException {
        IgniteCache<ObjectValue, Long> cache = this.jcache(ObjectValue.class, Long.class);
        cache.put((Object)new ObjectValue("test_key1", 10), (Object)19L);
        cache.put((Object)new ObjectValue("test_key0", 11), (Object)11005L);
        cache.put((Object)new ObjectValue("test_key1", 12), (Object)17L);
        IgniteCacheAbstractQuerySelfTest.assertEquals((long)11005L, (long)((Long)((Cache.Entry)cache.query((Query)new TextQuery(Long.class, "test_key0")).getAll().get(0)).getValue()).intValue());
    }

    @Test
    public void testOrderByOnly() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)i);
        }
        QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_key >= 0"));
        List res = q.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)10, (int)res.size());
        if (this.cacheMode() != CacheMode.PARTITIONED) {
            Iterator it = res.iterator();
            Integer i = 0;
            while (i < 10) {
                IgniteCacheAbstractQuerySelfTest.assertTrue((boolean)it.hasNext());
                Cache.Entry e = (Cache.Entry)it.next();
                IgniteCacheAbstractQuerySelfTest.assertEquals((Object)i, (Object)e.getKey());
                IgniteCacheAbstractQuerySelfTest.assertEquals((Object)i, (Object)e.getValue());
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    @Test
    public void testLimitOnly() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)i);
        }
        QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "limit 5"));
        List res = q.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)5, (int)res.size());
        HashSet<Object> checkDuplicate = new HashSet<Object>();
        for (Cache.Entry e : res) {
            assert ((Integer)e.getKey() < 10 && (Integer)e.getKey() >= 0);
            assert ((Integer)e.getValue() < 10 && (Integer)e.getValue() >= 0);
            checkDuplicate.add(e.getValue());
        }
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)5, (int)checkDuplicate.size());
    }

    @Test
    public void testArray() throws Exception {
        IgniteCache<Integer, ArrayObject> cache = this.jcache(Integer.class, ArrayObject.class);
        cache.put((Object)1, (Object)new ArrayObject(new Long[]{1L, null, 3L}));
        cache.put((Object)2, (Object)new ArrayObject(new Long[]{4L, 5L, 6L}));
        QueryCursor q = cache.query((Query)new SqlQuery(ArrayObject.class, "array_contains(arr, cast(? as long))").setArgs(new Object[]{4}));
        List res = q.getAll();
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)1, (int)res.size());
        Cache.Entry e = (Cache.Entry)F.first((Iterable)res);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)((Integer)e.getKey()));
        Assert.assertArrayEquals((Object[])new Long[]{4L, 5L, 6L}, (Object[])((ArrayObject)e.getValue()).arr);
    }

    @Test
    public void testSqlQueryEvents() throws Exception {
        this.checkSqlQueryEvents();
    }

    @Test
    public void testFieldsQueryMetadata() throws Exception {
        IgniteCache<UUID, Person> cache = this.jcache(UUID.class, Person.class);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)UUID.randomUUID(), (Object)new Person("name-" + i, (i + 1) * 100));
        }
        FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("select name, salary from Person where name like ?").setArgs(new Object[]{"name-"}));
        IgniteCacheAbstractQuerySelfTest.assertTrue((boolean)(cur instanceof QueryCursorEx));
        QueryCursorEx curEx = (QueryCursorEx)cur;
        List meta = curEx.fieldsMeta();
        IgniteCacheAbstractQuerySelfTest.assertNotNull((Object)meta);
        IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)meta.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSqlQueryEvents() throws Exception {
        IgnitePredicate[] lsnrs;
        block6: {
            int i;
            final IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
            final boolean evtsDisabled = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).isEventsDisabled();
            final CountDownLatch execLatch = new CountDownLatch(evtsDisabled ? 0 : (this.cacheMode() == CacheMode.REPLICATED ? 1 : this.gridCount()));
            lsnrs = new IgnitePredicate[this.gridCount()];
            for (i = 0; i < this.gridCount(); ++i) {
                IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

                    public boolean apply(Event evt) {
                        assert (evt instanceof CacheQueryExecutedEvent);
                        System.out.println(">>> EVENT");
                        if (evtsDisabled) {
                            junit.framework.Assert.fail((String)"Cache events are disabled");
                        }
                        CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                        junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                        junit.framework.Assert.assertNotNull((Object)qe.clause());
                        junit.framework.Assert.assertNull((Object)qe.scanQueryFilter());
                        junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                        Assert.assertArrayEquals((Object[])new Integer[]{10}, (Object[])qe.arguments());
                        execLatch.countDown();
                        return true;
                    }
                };
                this.grid(i).events().localListen((IgnitePredicate)pred, new int[]{96});
                lsnrs[i] = pred;
            }
            try {
                for (i = 0; i < 20; ++i) {
                    cache.put((Object)i, (Object)i);
                }
                QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_key >= ?").setArgs(new Object[]{10}));
                q.getAll();
                if ($assertionsDisabled || execLatch.await(1000L, TimeUnit.MILLISECONDS)) break block6;
                throw new AssertionError();
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < this.gridCount(); ++i2) {
                    this.grid(i2).events().stopLocalListen(lsnrs[i2], new int[]{96});
                }
                throw throwable;
            }
        }
        for (int i = 0; i < this.gridCount(); ++i) {
            this.grid(i).events().stopLocalListen(lsnrs[i], new int[]{96});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanQueryEvents() throws Exception {
        int i;
        final ConcurrentHashMap map = new ConcurrentHashMap();
        final IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        final boolean evtsDisabled = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).isEventsDisabled();
        final CountDownLatch latch = new CountDownLatch(evtsDisabled ? 0 : 10);
        final CountDownLatch execLatch = new CountDownLatch(evtsDisabled ? 0 : (this.cacheMode() == CacheMode.REPLICATED ? 1 : this.gridCount()));
        IgnitePredicate[] objReadLsnrs = new IgnitePredicate[this.gridCount()];
        IgnitePredicate[] qryExecLsnrs = new IgnitePredicate[this.gridCount()];
        for (i = 0; i < this.gridCount(); ++i) {
            IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    assert (evt instanceof CacheQueryReadEvent);
                    if (evtsDisabled) {
                        junit.framework.Assert.fail((String)"Cache events are disabled");
                    }
                    CacheQueryReadEvent qe = (CacheQueryReadEvent)evt;
                    junit.framework.Assert.assertEquals((String)CacheQueryType.SCAN.name(), (String)qe.queryType());
                    junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                    junit.framework.Assert.assertNull((Object)qe.className());
                    junit.framework.Assert.assertNull(null, (Object)qe.clause());
                    junit.framework.Assert.assertNotNull((Object)qe.scanQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.arguments());
                    map.put(qe.key(), qe.value());
                    latch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)pred, new int[]{97});
            objReadLsnrs[i] = pred;
            IgnitePredicate<Event> execPred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    assert (evt instanceof CacheQueryExecutedEvent);
                    if (evtsDisabled) {
                        junit.framework.Assert.fail((String)"Cache events are disabled");
                    }
                    CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                    junit.framework.Assert.assertEquals((String)CacheQueryType.SCAN.name(), (String)qe.queryType());
                    junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                    junit.framework.Assert.assertNull((Object)qe.className());
                    junit.framework.Assert.assertNull(null, (Object)qe.clause());
                    junit.framework.Assert.assertNotNull((Object)qe.scanQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.arguments());
                    execLatch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)execPred, new int[]{96});
            qryExecLsnrs[i] = execPred;
        }
        try {
            for (i = 0; i < 20; ++i) {
                cache.put((Object)i, (Object)i);
            }
            IgniteBiPredicate<Integer, Integer> filter = new IgniteBiPredicate<Integer, Integer>(){

                public boolean apply(Integer k, Integer v) {
                    return k >= 10;
                }
            };
            QueryCursor q = cache.query((Query)new ScanQuery((IgniteBiPredicate)filter));
            q.getAll();
            assert (latch.await(1000L, TimeUnit.MILLISECONDS));
            assert (execLatch.await(1000L, TimeUnit.MILLISECONDS));
            if (!evtsDisabled) {
                IgniteCacheAbstractQuerySelfTest.assertEquals((int)10, (int)map.size());
                for (int i2 = 10; i2 < 20; ++i2) {
                    IgniteCacheAbstractQuerySelfTest.assertEquals((int)i2, (int)((Integer)map.get(i2)));
                }
            }
        }
        finally {
            for (int i3 = 0; i3 < this.gridCount(); ++i3) {
                this.grid(i3).events().stopLocalListen(objReadLsnrs[i3], new int[0]);
                this.grid(i3).events().stopLocalListen(qryExecLsnrs[i3], new int[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTextQueryEvents() throws Exception {
        final ConcurrentHashMap map = new ConcurrentHashMap();
        final IgniteCache<UUID, Person> cache = this.jcache(UUID.class, Person.class);
        final boolean evtsDisabled = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).isEventsDisabled();
        final CountDownLatch latch = new CountDownLatch(evtsDisabled ? 0 : 2);
        final CountDownLatch execLatch = new CountDownLatch(evtsDisabled ? 0 : (this.cacheMode() == CacheMode.REPLICATED ? 1 : this.gridCount()));
        IgnitePredicate[] objReadLsnrs = new IgnitePredicate[this.gridCount()];
        IgnitePredicate[] qryExecLsnrs = new IgnitePredicate[this.gridCount()];
        for (int i = 0; i < this.gridCount(); ++i) {
            IgnitePredicate<Event> objReadPred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    assert (evt instanceof CacheQueryReadEvent);
                    if (evtsDisabled) {
                        junit.framework.Assert.fail((String)"Cache events are disabled");
                    }
                    CacheQueryReadEvent qe = (CacheQueryReadEvent)evt;
                    junit.framework.Assert.assertEquals((String)CacheQueryType.FULL_TEXT.name(), (String)qe.queryType());
                    junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                    junit.framework.Assert.assertEquals((String)"Person", (String)qe.className());
                    junit.framework.Assert.assertEquals((String)"White", (String)qe.clause());
                    junit.framework.Assert.assertNull((Object)qe.scanQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.arguments());
                    map.put(qe.key(), qe.value());
                    latch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)objReadPred, new int[]{97});
            objReadLsnrs[i] = objReadPred;
            IgnitePredicate<Event> qryExecPred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    assert (evt instanceof CacheQueryExecutedEvent);
                    if (evtsDisabled) {
                        junit.framework.Assert.fail((String)"Cache events are disabled");
                    }
                    CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                    junit.framework.Assert.assertEquals((String)CacheQueryType.FULL_TEXT.name(), (String)qe.queryType());
                    junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                    junit.framework.Assert.assertEquals((String)"Person", (String)qe.className());
                    junit.framework.Assert.assertEquals((String)"White", (String)qe.clause());
                    junit.framework.Assert.assertNull((Object)qe.scanQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.arguments());
                    execLatch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)qryExecPred, new int[]{96});
            qryExecLsnrs[i] = qryExecPred;
        }
        try {
            UUID k1 = UUID.randomUUID();
            UUID k2 = UUID.randomUUID();
            UUID k3 = UUID.randomUUID();
            cache.put((Object)k1, (Object)new Person("Bob White", 1000));
            cache.put((Object)k2, (Object)new Person("Tom White", 1000));
            cache.put((Object)k3, (Object)new Person("Mike Green", 1000));
            QueryCursor q = cache.query((Query)new TextQuery(Person.class, "White"));
            q.getAll();
            assert (latch.await(1000L, TimeUnit.MILLISECONDS));
            assert (execLatch.await(1000L, TimeUnit.MILLISECONDS));
            if (!evtsDisabled) {
                IgniteCacheAbstractQuerySelfTest.assertEquals((int)2, (int)map.size());
                IgniteCacheAbstractQuerySelfTest.assertEquals((String)"Bob White", (String)((Person)map.get(k1)).name());
                IgniteCacheAbstractQuerySelfTest.assertEquals((String)"Tom White", (String)((Person)map.get(k2)).name());
            }
        }
        finally {
            for (int i = 0; i < this.gridCount(); ++i) {
                this.grid(i).events().stopLocalListen(objReadLsnrs[i], new int[0]);
                this.grid(i).events().stopLocalListen(qryExecLsnrs[i], new int[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFieldsQueryEvents() throws Exception {
        int i;
        final IgniteCache<UUID, Person> cache = this.jcache(UUID.class, Person.class);
        final boolean evtsDisabled = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).isEventsDisabled();
        final CountDownLatch execLatch = new CountDownLatch(evtsDisabled ? 0 : (this.cacheMode() == CacheMode.REPLICATED ? 1 : this.gridCount()));
        IgnitePredicate[] qryExecLsnrs = new IgnitePredicate[this.gridCount()];
        for (i = 0; i < this.gridCount(); ++i) {
            IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

                public boolean apply(Event evt) {
                    assert (evt instanceof CacheQueryExecutedEvent);
                    if (evtsDisabled) {
                        junit.framework.Assert.fail((String)"Cache events are disabled");
                    }
                    CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                    junit.framework.Assert.assertEquals((String)cache.getName(), (String)qe.cacheName());
                    junit.framework.Assert.assertNotNull((Object)qe.clause());
                    junit.framework.Assert.assertNull((Object)qe.scanQueryFilter());
                    junit.framework.Assert.assertNull((Object)qe.continuousQueryFilter());
                    Assert.assertArrayEquals((Object[])new Integer[]{10}, (Object[])qe.arguments());
                    execLatch.countDown();
                    return true;
                }
            };
            this.grid(i).events().localListen((IgnitePredicate)pred, new int[]{96});
            qryExecLsnrs[i] = pred;
        }
        try {
            for (i = 1; i <= 20; ++i) {
                cache.put((Object)UUID.randomUUID(), (Object)new Person("Person " + i, i));
            }
            FieldsQueryCursor q = cache.query(new SqlFieldsQuery("select _key, name from Person where salary > ?").setArgs(new Object[]{10}));
            q.getAll();
            assert (execLatch.await(1000L, TimeUnit.MILLISECONDS));
        }
        finally {
            for (int i2 = 0; i2 < this.gridCount(); ++i2) {
                this.grid(i2).events().stopLocalListen(qryExecLsnrs[i2], new int[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalSqlQueryFromClient() throws Exception {
        try {
            IgniteEx g = this.startGrid("client");
            IgniteCache<Integer, Integer> c = this.jcache((Ignite)g, Integer.class, Integer.class);
            for (int i = 0; i < 10; ++i) {
                c.put((Object)i, (Object)i);
            }
            SqlQuery qry = new SqlQuery(Integer.class, "_key >= 5 order by _key");
            qry.setLocal(true);
            GridTestUtils.assertThrowsWithCause(() -> c.query((Query)qry), CacheException.class);
        }
        finally {
            this.stopGrid("client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalSqlFieldsQueryFromClient() throws Exception {
        try {
            IgniteEx g = this.startGrid("client");
            IgniteCache<UUID, Person> c = this.jcache((Ignite)g, UUID.class, Person.class);
            Person p = new Person("Jon", 1500);
            c.put((Object)p.id(), (Object)p);
            SqlFieldsQuery qry = new SqlFieldsQuery("select count(*) from Person");
            qry.setLocal(true);
            GridTestUtils.assertThrowsWithCause(() -> c.query(qry), CacheException.class);
        }
        finally {
            this.stopGrid("client");
        }
    }

    private static enum EnumType {
        TYPE_A,
        TYPE_B;

    }

    private static class EnumObject {
        @QuerySqlField(index=true)
        private long id;
        @QuerySqlField
        private EnumType type;

        public EnumObject(long id, EnumType type) {
            this.id = id;
            this.type = type;
        }

        public String toString() {
            return "EnumObject{id=" + this.id + ", type=" + (Object)((Object)this.type) + '}';
        }
    }

    private static class StoreFactory
    implements Factory<CacheStore> {
        private StoreFactory() {
        }

        public CacheStore create() {
            return store;
        }
    }

    public static class SqlFunctions {
        @QuerySqlFunction
        public static int square(int x) {
            return x * x;
        }

        @QuerySqlFunction(alias="_cube_")
        public static int cube(int x) {
            return x * x * x;
        }

        public static int no() {
            throw new IllegalStateException();
        }
    }

    private static class TestStore
    extends CacheStoreAdapter<Object, Object> {
        private Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();

        private TestStore() {
        }

        void reset() {
            this.map.clear();
        }

        public Object load(Object key) {
            return this.map.get(key);
        }

        public void write(Cache.Entry<? extends Object, ? extends Object> e) {
            this.map.put(e.getKey(), e.getValue());
        }

        public void delete(Object key) {
            this.map.remove(key);
        }
    }

    private static class BadHashKeyObject
    implements Serializable,
    Comparable<BadHashKeyObject> {
        @QuerySqlField(index=false)
        private final String str;

        private BadHashKeyObject(String str) {
            this.str = str == null ? "" : str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BadHashKeyObject keyObj = (BadHashKeyObject)o;
            return this.str.equals(keyObj.str);
        }

        public int hashCode() {
            return 10;
        }

        @Override
        public int compareTo(BadHashKeyObject o) {
            return this.str.compareTo(o.str);
        }

        public String toString() {
            return S.toString(BadHashKeyObject.class, (Object)this);
        }
    }

    private static class ObjectValue2 {
        private String strVal;

        ObjectValue2(String strVal) {
            this.strVal = strVal;
        }

        public String value() {
            return this.strVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValue2 other = (ObjectValue2)o;
            return this.strVal == null ? other.strVal == null : this.strVal.equals(other.strVal);
        }

        public int hashCode() {
            return this.strVal != null ? this.strVal.hashCode() : 0;
        }

        public String toString() {
            return S.toString(ObjectValue2.class, (Object)this);
        }
    }

    private static class ObjectValueOther {
        @QueryTextField
        private String val;

        ObjectValueOther(String val) {
            this.val = val;
        }

        public String value() {
            return this.val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValueOther other = (ObjectValueOther)o;
            return this.val == null ? other.val == null : this.val.equals(other.val);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }

        public String toString() {
            return S.toString(ObjectValueOther.class, (Object)this);
        }
    }

    public static class ObjectValue
    implements Serializable {
        @QueryTextField
        private String strVal;
        @QuerySqlField
        private int intVal;

        ObjectValue(String strVal, int intVal) {
            this.strVal = strVal;
            this.intVal = intVal;
        }

        public String getStringValue() {
            return this.strVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValue other = (ObjectValue)o;
            return this.strVal == null ? other.strVal == null : this.strVal.equals(other.strVal);
        }

        public int hashCode() {
            return this.strVal != null ? this.strVal.hashCode() : 0;
        }

        public String toString() {
            return S.toString(ObjectValue.class, (Object)this);
        }
    }

    public static class Type2
    implements Serializable {
        private int id;
        private String name;

        Type2(int id, String name) {
            assert (name != null);
            assert (id > 0);
            this.name = name;
            this.id = id;
        }

        public String name() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public int hashCode() {
            return this.name.hashCode() + 31 * this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Type2)) {
                return false;
            }
            Type2 that = (Type2)obj;
            return that.name.equals(this.name) && that.id == this.id;
        }

        public String toString() {
            return S.toString(Type2.class, (Object)this);
        }
    }

    public static class Type1
    implements Serializable {
        private int id;
        private String name;

        Type1(int id, String name) {
            assert (name != null);
            assert (id > 0);
            this.name = name;
            this.id = id;
        }

        public String name() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public int hashCode() {
            return this.name.hashCode() + 31 * this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Type1)) {
                return false;
            }
            Type1 that = (Type1)obj;
            return that.name.equals(this.name) && that.id == this.id;
        }

        public String toString() {
            return S.toString(Type1.class, (Object)this);
        }
    }

    public static class Person
    implements Externalizable {
        @GridToStringExclude
        @QuerySqlField
        private UUID id = UUID.randomUUID();
        @QuerySqlField
        @QueryTextField
        private String name;
        @QuerySqlField
        private int salary;
        @QuerySqlField(index=true)
        private int fake$Field;

        public Person() {
        }

        public Person(String name, int salary) {
            assert (name != null);
            assert (salary > 0);
            this.name = name;
            this.salary = salary;
        }

        public UUID id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public int salary() {
            return this.salary;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeUuid((DataOutput)out, (UUID)this.id);
            U.writeString((DataOutput)out, (String)this.name);
            out.writeInt(this.salary);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = U.readUuid((DataInput)in);
            this.name = U.readString((DataInput)in);
            this.salary = in.readInt();
        }

        public int hashCode() {
            return this.id.hashCode() + 31 * this.name.hashCode() + 961 * this.salary;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Person)) {
                return false;
            }
            Person that = (Person)obj;
            return that.id.equals(this.id) && that.name.equals(this.name) && that.salary == this.salary;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    private static class ArrayObject
    implements Serializable {
        @QuerySqlField
        private Long[] arr;

        private ArrayObject(Long[] arr) {
            this.arr = arr;
        }
    }

    private static class Key {
        @QuerySqlField
        private final long id;

        private Key(long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.id == key.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }
}

