/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKeyImpl;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class IgniteCacheAbstractFieldsQuerySelfTest
extends GridCommonAbstractTest {
    private static IgniteCache<String, Organization> orgCache;
    private static IgniteCache<AffinityKey<String>, Person> personCache;
    private static IgniteCache<String, String> strCache;
    protected static IgniteCache<Integer, Integer> intCache;
    protected static IgniteCache<?, ?> noOpCache;
    protected boolean hasCache;
    protected boolean binaryMarshaller;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        if (this.hasCache) {
            cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration()});
        } else {
            cfg.setCacheConfiguration(new CacheConfiguration[0]);
        }
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration ccfg = IgniteCacheAbstractFieldsQuerySelfTest.defaultCacheConfiguration();
        ccfg.setCacheMode(this.cacheMode());
        ccfg.setAtomicityMode(this.atomicityMode());
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        if (this.cacheMode() == CacheMode.PARTITIONED) {
            ccfg.setBackups(1);
        }
        return ccfg;
    }

    protected <K, V> IgniteCache<K, V> jcache(Class<K> clsK, Class<V> clsV) {
        return this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), clsK, clsV);
    }

    protected <K, V> IgniteCache<K, V> jcache(String name, Class<K> clsK, Class<V> clsV) {
        return this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), name, clsK, clsV);
    }

    protected void beforeTestsStarted() throws Exception {
        this.hasCache = true;
        this.startGridsMultiThreaded(this.gridCount());
        this.hasCache = false;
        this.startGrid(this.gridCount());
        orgCache = this.jcache(String.class, Organization.class);
        assert (orgCache != null);
        orgCache.put((Object)"o1", (Object)new Organization(1, "A"));
        orgCache.put((Object)"o2", (Object)new Organization(2, "B"));
        IgniteCache<AffinityKey, Person> c = this.jcache(AffinityKey.class, Person.class);
        personCache = c;
        assert (personCache != null);
        personCache.put((Object)new AffinityKey((Object)"p1", (Object)"o1"), (Object)new Person("John White", 25, 1));
        personCache.put((Object)new AffinityKey((Object)"p2", (Object)"o1"), (Object)new Person("Joe Black", 35, 1));
        personCache.put((Object)new AffinityKey((Object)"p3", (Object)"o2"), (Object)new Person("Mike Green", 40, 2));
        strCache = this.jcache(String.class, String.class);
        assert (strCache != null);
        strCache.put((Object)"key", (Object)"val");
        intCache = this.jcache(Integer.class, Integer.class);
        assert (intCache != null);
        for (int i = 0; i < 200; ++i) {
            intCache.put((Object)i, (Object)i);
        }
        noOpCache = this.grid(0).getOrCreateCache("noop");
    }

    protected void beforeTest() throws Exception {
        this.binaryMarshaller = this.grid(0).configuration().getMarshaller() instanceof BinaryMarshaller;
    }

    protected void afterTestsStopped() throws Exception {
        orgCache = null;
        personCache = null;
        strCache = null;
        intCache = null;
        noOpCache = null;
    }

    protected abstract CacheMode cacheMode();

    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.TRANSACTIONAL;
    }

    protected abstract int gridCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheMetaData() throws Exception {
        for (String cacheName : this.grid(0).cacheNames()) {
            ((IgniteKernal)this.grid(0)).getCache(cacheName).getAndPut((Object)new GridCacheInternalKeyImpl("LONG", ""), (Object)new GridCacheAtomicLongValue(0L));
        }
        try {
            Collection metas = ((IgniteKernal)this.grid(0)).getCache(intCache.getName()).context().queries().sqlMetadata();
            assert (metas != null);
            for (GridCacheSqlMetadata meta : metas) {
                Map fields;
                Collection types = meta.types();
                IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)types);
                if (personCache.getName().equals(meta.cacheName())) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Invalid types size", (int)1, (int)types.size());
                    assert (types.contains("Person"));
                    if (this.binaryMarshaller) {
                        assert (Object.class.getName().equals(meta.keyClass("Person")));
                        assert (Object.class.getName().equals(meta.valueClass("Person")));
                    } else {
                        assert (AffinityKey.class.getName().equals(meta.keyClass("Person")));
                        assert (Person.class.getName().equals(meta.valueClass("Person")));
                    }
                    fields = meta.fields("Person");
                    assert (fields != null);
                    assert (fields.size() == 3);
                    if (this.binaryMarshaller) {
                        assert (Integer.class.getName().equals(fields.get("AGE")));
                        assert (Integer.class.getName().equals(fields.get("ORGID")));
                    } else {
                        assert (Integer.TYPE.getName().equals(fields.get("AGE")));
                        assert (Integer.TYPE.getName().equals(fields.get("ORGID")));
                    }
                    assert (String.class.getName().equals(fields.get("NAME")));
                    Collection indexes = meta.indexes("Person");
                    IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((String)"Indexes should be defined", (Object)indexes);
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)2, (int)indexes.size());
                    HashSet idxFields = new HashSet();
                    Iterator it = indexes.iterator();
                    Collection indFlds = ((GridCacheSqlIndexMetadata)it.next()).fields();
                    IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((String)"Fields for first index should be defined", (Object)indFlds);
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"First index should have one field", (int)indFlds.size(), (int)1);
                    Iterator indFldIt = indFlds.iterator();
                    idxFields.add(indFldIt.next());
                    indFlds = ((GridCacheSqlIndexMetadata)it.next()).fields();
                    IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((String)"Fields for second index should be defined", (Object)indFlds);
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Second index should have one field", (int)indFlds.size(), (int)1);
                    indFldIt = indFlds.iterator();
                    idxFields.add(indFldIt.next());
                    IgniteCacheAbstractFieldsQuerySelfTest.assertTrue((boolean)idxFields.contains("AGE"));
                    IgniteCacheAbstractFieldsQuerySelfTest.assertTrue((boolean)idxFields.contains("ORGID"));
                    continue;
                }
                if (orgCache.getName().equals(meta.cacheName())) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Invalid types size", (int)1, (int)types.size());
                    assert (types.contains("Organization"));
                    if (this.binaryMarshaller ? !$assertionsDisabled && !Object.class.getName().equals(meta.valueClass("Organization")) : !$assertionsDisabled && !Organization.class.getName().equals(meta.valueClass("Organization"))) {
                        throw new AssertionError();
                    }
                    assert (String.class.getName().equals(meta.keyClass("Organization")));
                    fields = meta.fields("Organization");
                    assert (fields != null);
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)("Fields: " + fields), (int)2, (int)fields.size());
                    if (this.binaryMarshaller ? !$assertionsDisabled && !Integer.class.getName().equals(fields.get("ID")) : !$assertionsDisabled && !Integer.TYPE.getName().equals(fields.get("ID"))) {
                        throw new AssertionError();
                    }
                    assert (String.class.getName().equals(fields.get("NAME")));
                    continue;
                }
                if (intCache.getName().equals(meta.cacheName())) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Invalid types size", (int)1, (int)types.size());
                    assert (types.contains("Integer"));
                    assert (Integer.class.getName().equals(meta.valueClass("Integer")));
                    assert (Integer.class.getName().equals(meta.keyClass("Integer")));
                    fields = meta.fields("Integer");
                    assert (fields != null);
                    assert (fields.size() == 2);
                    assert (Integer.class.getName().equals(fields.get("_KEY")));
                    assert (Integer.class.getName().equals(fields.get("_VAL")));
                    continue;
                }
                if (strCache.getName().equals(meta.cacheName())) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Invalid types size", (int)1, (int)types.size());
                    assert (types.contains("String"));
                    assert (String.class.getName().equals(meta.valueClass("String")));
                    assert (String.class.getName().equals(meta.keyClass("String")));
                    fields = meta.fields("String");
                    assert (fields != null);
                    assert (fields.size() == 2);
                    assert (String.class.getName().equals(fields.get("_KEY")));
                    assert (String.class.getName().equals(fields.get("_VAL")));
                    continue;
                }
                if ("default".equals(meta.cacheName()) || noOpCache.getName().equals(meta.cacheName())) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertTrue((String)"Invalid types size", (boolean)types.isEmpty());
                    continue;
                }
                if ("cacheWithCustomKeyPrecision".equalsIgnoreCase(meta.cacheName())) continue;
                IgniteCacheAbstractFieldsQuerySelfTest.fail((String)("Unknown cache: " + meta.cacheName()));
            }
        }
        finally {
            ((IgniteKernal)this.grid(0)).getCache(intCache.getName()).remove((Object)new GridCacheInternalKeyImpl("LONG", ""));
        }
    }

    @Test
    public void testExplain() {
        List res = this.grid(0).cache(personCache.getName()).query(this.sqlFieldsQuery(String.format("explain select p.age, p.name, o.name from \"%s\".Person p, \"%s\".Organization o where p.orgId = o.id", personCache.getName(), orgCache.getName()))).getAll();
        for (List row : res) {
            X.println((String)("____ : " + row), (Object[])new Object[0]);
        }
        if (this.cacheMode() == CacheMode.PARTITIONED) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)2, (int)res.size());
            IgniteCacheAbstractFieldsQuerySelfTest.assertTrue((boolean)((String)((List)res.get(1)).get(0)).contains(GridSqlQuerySplitter.mergeTableIdentifier((int)0)));
        } else {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)1, (int)res.size());
        }
    }

    @Test
    public void testExecuteWithMetaDataAndPrecision() throws Exception {
        QueryEntity qeWithPrecision = new QueryEntity().setKeyType("java.lang.Long").setValueType("TestType").addQueryField("strField", "java.lang.String", "strField").setFieldsPrecision((Map)ImmutableMap.of((Object)"strField", (Object)999));
        this.grid(0).getOrCreateCache(this.cacheConfiguration().setName("cacheWithPrecision").setQueryEntities(Collections.singleton(qeWithPrecision)));
        GridQueryProcessor qryProc = this.grid(0).context().query();
        qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO TestType(_KEY, strField) VALUES(?, ?)").setSchema("cacheWithPrecision").setArgs(new Object[]{1, "ABC"}), true);
        qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO TestType(_KEY, strField) VALUES(?, ?)").setSchema("cacheWithPrecision").setArgs(new Object[]{2, "DEF"}), true);
        QueryCursorImpl cursor = (QueryCursorImpl)qryProc.querySqlFields(new SqlFieldsQuery("SELECT _KEY, strField FROM TestType").setSchema("cacheWithPrecision"), true);
        List fieldsMeta = cursor.fieldsMeta();
        for (GridQueryFieldMetadata meta : fieldsMeta) {
            if (!meta.fieldName().equalsIgnoreCase("strField")) continue;
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)999, (int)meta.precision());
        }
    }

    @Test
    public void testExecuteWithMetaDataAndCustomKeyPrecision() throws Exception {
        QueryEntity qeWithPrecision = new QueryEntity().setKeyType("java.lang.String").setKeyFieldName("my_key").setValueType("CustomKeyType").addQueryField("my_key", "java.lang.String", "my_key").addQueryField("strField", "java.lang.String", "strField").setFieldsPrecision((Map)ImmutableMap.of((Object)"strField", (Object)999, (Object)"my_key", (Object)777));
        this.grid(0).getOrCreateCache(this.cacheConfiguration().setName("cacheWithCustomKeyPrecision").setQueryEntities(Collections.singleton(qeWithPrecision)));
        GridQueryProcessor qryProc = this.grid(0).context().query();
        qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO CustomKeyType(my_key, strField) VALUES(?, ?)").setSchema("cacheWithCustomKeyPrecision").setArgs(new Object[]{"1", "ABC"}), true);
        qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO CustomKeyType(my_key, strField) VALUES(?, ?)").setSchema("cacheWithCustomKeyPrecision").setArgs(new Object[]{"2", "DEF"}), true);
        QueryCursorImpl cursor = (QueryCursorImpl)qryProc.querySqlFields(new SqlFieldsQuery("SELECT my_key, strField FROM CustomKeyType").setSchema("cacheWithCustomKeyPrecision"), true);
        List fieldsMeta = cursor.fieldsMeta();
        int fldCnt = 0;
        block8: for (GridQueryFieldMetadata meta : fieldsMeta) {
            switch (meta.fieldName()) {
                case "STRFIELD": {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)999, (int)meta.precision());
                    ++fldCnt;
                    continue block8;
                }
                case "MY_KEY": {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)777, (int)meta.precision());
                    ++fldCnt;
                    continue block8;
                }
            }
            IgniteCacheAbstractFieldsQuerySelfTest.fail((String)("Unknown field - " + meta.fieldName()));
        }
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"Metadata for all fields should be returned.", (int)2, (int)fldCnt);
    }

    @Test
    public void testExecuteWithMetaData() throws Exception {
        QueryCursorImpl cursor = (QueryCursorImpl)personCache.query(this.sqlFieldsQuery(String.format("select p._KEY, p.name, p.age, o.name from \"%s\".Person p, \"%s\".Organization o where p.orgId = o.id", personCache.getName(), orgCache.getName())));
        List meta = cursor.fieldsMeta();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)meta);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)4, (int)meta.size());
        Iterator metaIt = meta.iterator();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull(metaIt);
        assert (metaIt.hasNext());
        GridQueryFieldMetadata field = (GridQueryFieldMetadata)metaIt.next();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)field);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)personCache.getName(), (String)field.schemaName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"PERSON", (String)field.typeName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"_KEY", (String)field.fieldName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)Object.class.getName(), (String)field.fieldTypeName());
        assert (metaIt.hasNext());
        field = (GridQueryFieldMetadata)metaIt.next();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)field);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)personCache.getName(), (String)field.schemaName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"PERSON", (String)field.typeName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"NAME", (String)field.fieldName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)String.class.getName(), (String)field.fieldTypeName());
        assert (metaIt.hasNext());
        field = (GridQueryFieldMetadata)metaIt.next();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)field);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)personCache.getName(), (String)field.schemaName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"PERSON", (String)field.typeName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"AGE", (String)field.fieldName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)Integer.class.getName(), (String)field.fieldTypeName());
        assert (metaIt.hasNext());
        field = (GridQueryFieldMetadata)metaIt.next();
        assert (field != null);
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)field);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)orgCache.getName(), (String)field.schemaName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"ORGANIZATION", (String)field.typeName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)"NAME", (String)field.fieldName());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)String.class.getName(), (String)field.fieldTypeName());
        assert (!metaIt.hasNext());
        List res = cursor.getAll();
        this.dedup(res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)res.size());
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> row1, List<?> row2) {
                return ((Integer)row1.get(2)).compareTo((Integer)row2.get(2));
            }
        });
        int cnt = 0;
        for (List row : res) {
            assert (row.size() == 4);
            if (cnt == 0) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p1", (Object)"o1"), row.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"John White", row.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)25, row.get(2));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"A", row.get(3));
            } else if (cnt == 1) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p2", (Object)"o1"), row.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Joe Black", row.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)35, row.get(2));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"A", row.get(3));
            }
            if (cnt == 2) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p3", (Object)"o2"), row.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Mike Green", row.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)40, row.get(2));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"B", row.get(3));
            }
            ++cnt;
        }
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)cnt);
    }

    @Test
    public void testExecute() throws Exception {
        this.doTestExecute(personCache, this.sqlFieldsQuery("select _KEY, name, age from Person"));
    }

    @Test
    public void testExecuteNoOpCache() throws Exception {
        this.doTestExecute(noOpCache, this.sqlFieldsQuery("select _KEY, name, age from \"AffinityKey-Person\".Person"));
    }

    private void doTestExecute(IgniteCache<?, ?> cache, SqlFieldsQuery fldsQry) throws Exception {
        FieldsQueryCursor qry = cache.query(fldsQry);
        ArrayList res = new ArrayList(qry.getAll());
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull(res);
        this.dedup(res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)res.size(), (int)3);
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> row1, List<?> row2) {
                return ((Integer)row1.get(2)).compareTo((Integer)row2.get(2));
            }
        });
        int cnt = 0;
        for (List list : res) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)list.size());
            if (cnt == 0) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p1", (Object)"o1"), list.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"John White", list.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)25, list.get(2));
            } else if (cnt == 1) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p2", (Object)"o1"), list.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Joe Black", list.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)35, list.get(2));
            }
            if (cnt == 2) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p3", (Object)"o2"), list.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Mike Green", list.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)40, list.get(2));
            }
            ++cnt;
        }
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)cnt);
    }

    @Test
    public void testExecuteWithArguments() throws Exception {
        FieldsQueryCursor qry = personCache.query(this.sqlFieldsQuery("select _KEY, name, age from Person where age > ?").setArgs(new Object[]{30}));
        ArrayList res = new ArrayList(qry.getAll());
        this.dedup(res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)2, (int)res.size());
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> row1, List<?> row2) {
                return ((Integer)row1.get(2)).compareTo((Integer)row2.get(2));
            }
        });
        int cnt = 0;
        for (List list : res) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)list.size());
            if (cnt == 0) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p2", (Object)"o1"), list.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Joe Black", list.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)35, list.get(2));
            }
            if (cnt == 1) {
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)new AffinityKey((Object)"p3", (Object)"o2"), list.get(0));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"Mike Green", list.get(1));
                IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)40, list.get(2));
            }
            ++cnt;
        }
        assert (cnt == 2);
    }

    protected boolean isReplicatedOnly() {
        return false;
    }

    private SqlFieldsQuery sqlFieldsQuery(String sql) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (this.isReplicatedOnly()) {
            qry.setReplicatedOnly(true);
        }
        return qry;
    }

    @Test
    public void testSelectAllJoined() throws Exception {
        FieldsQueryCursor qry = personCache.query(this.sqlFieldsQuery(String.format("select p._key, p._val, p.*, o._key, o._val, o.* from \"%s\".Person p, \"%s\".Organization o where p.orgId = o.id", personCache.getName(), orgCache.getName())));
        ArrayList res = new ArrayList(qry.getAll());
        this.dedup(res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)3, (int)res.size());
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> row1, List<?> row2) {
                return ((Integer)row1.get(3)).compareTo((Integer)row2.get(3));
            }
        });
        int cnt = 0;
        for (List list : res) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)9, (int)list.size());
            if (cnt == 0) {
                assert (new AffinityKey((Object)"p1", (Object)"o1").equals(list.get(0)));
                assert (Person.class.getName().equals(list.get(1).getClass().getName()));
                assert ("John White".equals(list.get(2)));
                assert (list.get(3).equals(25));
                assert (list.get(4).equals(1));
                assert ("o1".equals(list.get(5)));
                assert (Organization.class.getName().equals(list.get(6).getClass().getName()));
                assert (list.get(7).equals(1));
                assert ("A".equals(list.get(8)));
            } else if (cnt == 1) {
                assert (new AffinityKey((Object)"p2", (Object)"o1").equals(list.get(0)));
                assert (Person.class.getName().equals(list.get(1).getClass().getName()));
                assert ("Joe Black".equals(list.get(2)));
                assert (list.get(3).equals(35));
                assert (list.get(4).equals(1));
                assert ("o1".equals(list.get(5)));
                assert (Organization.class.getName().equals(list.get(6).getClass().getName()));
                assert (list.get(7).equals(1));
                assert ("A".equals(list.get(8)));
            }
            if (cnt == 2) {
                assert (new AffinityKey((Object)"p3", (Object)"o2").equals(list.get(0)));
                assert (Person.class.getName().equals(list.get(1).getClass().getName()));
                assert ("Mike Green".equals(list.get(2)));
                assert (list.get(3).equals(40));
                assert (list.get(4).equals(2));
                assert ("o2".equals(list.get(5)));
                assert (Organization.class.getName().equals(list.get(6).getClass().getName()));
                assert (list.get(7).equals(2));
                assert ("B".equals(list.get(8)));
            }
            ++cnt;
        }
        assert (cnt == 3);
    }

    @Test
    public void testEmptyResult() throws Exception {
        FieldsQueryCursor qry = personCache.query(this.sqlFieldsQuery("select name from Person where age = 0"));
        List res = qry.getAll();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testSingleResultUsesFindOne() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select _val from Integer where _key = 25"));
        List res = qry.getAll();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)1, (int)res.size());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)25, ((List)res.get(0)).get(0));
    }

    @Test
    public void testEmptyResultUsesFindOne() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select _val from Integer where _key = -10"));
        List res = qry.getAll();
        IgniteCacheAbstractFieldsQuerySelfTest.assertNotNull((Object)res);
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)0, (int)res.size());
    }

    @Test
    public void testQueryString() throws Exception {
        FieldsQueryCursor qry = strCache.query(this.sqlFieldsQuery("select * from String"));
        List res = qry.getAll();
        assert (res != null);
        assert (res.size() == 1);
        for (List row : res) {
            assert (row != null);
            assert (row.size() == 2);
            assert ("key".equals(row.get(0)));
            assert ("val".equals(row.get(1)));
        }
    }

    @Test
    public void testQueryIntegersWithJoin() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select i._KEY, i._VAL, j._KEY, j._VAL from Integer i join Integer j where i._VAL >= 100"));
        List res = qry.getAll();
        assert (res != null);
        if (this.cacheMode() == CacheMode.LOCAL ? !$assertionsDisabled && res.size() != 20000 : !$assertionsDisabled && res.size() > 20000) {
            throw new AssertionError();
        }
        for (List row : res) {
            assert ((Integer)row.get(0) >= 100);
            assert ((Integer)row.get(1) >= 100);
            assert ((Integer)row.get(2) >= 0);
            assert ((Integer)row.get(3) >= 0);
        }
    }

    @Test
    public void testPagination() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select * from Integer").setPageSize(20));
        ArrayList res = new ArrayList(qry.getAll());
        this.dedup(res);
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> r1, List<?> r2) {
                return ((Integer)r1.get(0)).compareTo((Integer)r2.get(0));
            }
        });
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)200, (int)res.size());
        for (List list : res) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((String)("Wrong row size: " + list), (int)2, (int)list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamedCache() throws Exception {
        try {
            IgniteCache<Integer, Integer> cache = this.jcache("tmp_int", Integer.class, Integer.class);
            for (int i = 0; i < 200; ++i) {
                cache.put((Object)i, (Object)i);
            }
            FieldsQueryCursor qry = cache.query(this.sqlFieldsQuery("select * from Integer"));
            List res = qry.getAll();
            assert (res != null);
            assert (res.size() == 200);
        }
        finally {
            this.grid(0).destroyCache("tmp_int");
        }
    }

    @Test
    public void testNoPrimitives() throws Exception {
        try {
            final IgniteCache cache = this.grid(0).getOrCreateCache("tmp_without_index");
            cache.put((Object)"key", (Object)"val");
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return cache.query(IgniteCacheAbstractFieldsQuerySelfTest.this.sqlFieldsQuery("select * from String"));
                }
            }, CacheException.class, null);
        }
        finally {
            this.grid(0).destroyCache("tmp_without_index");
        }
    }

    @Test
    public void testComplexKeys() throws Exception {
        IgniteCache<PersonKey, Person> cache = this.jcache(PersonKey.class, Person.class);
        UUID id = UUID.randomUUID();
        PersonKey key = new PersonKey(id);
        Person val = new Person("John", 20, 1);
        cache.put((Object)key, (Object)val);
        List res = cache.query(this.sqlFieldsQuery("select _key, _val, * from Person")).getAll();
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)1, (int)res.size());
        for (Collection row : res) {
            int cnt = 0;
            for (Object fieldVal : row) {
                if (cnt == 0) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)key, fieldVal);
                } else if (cnt == 1) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)val, fieldVal);
                } else if (cnt == 2) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)id, fieldVal);
                } else if (cnt == 3) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)"John", fieldVal);
                } else if (cnt == 4) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)20, fieldVal);
                } else if (cnt == 5) {
                    IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)1, fieldVal);
                }
                ++cnt;
            }
        }
        cache.removeAll();
    }

    @Test
    public void testPaginationIterator() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select _key, _val from Integer").setPageSize(10));
        int cnt = 0;
        for (List row : qry) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)2, (int)row.size());
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals(row.get(0), row.get(1));
            IgniteCacheAbstractFieldsQuerySelfTest.assertTrue(((Integer)row.get(0) >= 0 && (Integer)row.get(0) < 200 ? 1 : 0) != 0);
            ++cnt;
        }
        int size = 200;
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)size, (int)cnt);
    }

    @Test
    public void testPaginationIteratorKeepAll() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select _key, _val from Integer").setPageSize(10));
        int cnt = 0;
        for (List row : qry) {
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)2, (int)row.size());
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals(row.get(0), row.get(1));
            IgniteCacheAbstractFieldsQuerySelfTest.assertTrue(((Integer)row.get(0) >= 0 && (Integer)row.get(0) < 200 ? 1 : 0) != 0);
            ++cnt;
        }
        int size = 200;
        IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((int)size, (int)cnt);
        qry = intCache.query(this.sqlFieldsQuery("select _key, _val from Integer").setPageSize(10));
        ArrayList list = new ArrayList(qry.getAll());
        this.dedup(list);
        Collections.sort(list, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> r1, List<?> r2) {
                return ((Integer)r1.get(0)).compareTo((Integer)r2.get(0));
            }
        });
        for (int i = 0; i < 200; ++i) {
            List r = (List)list.get(i);
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)i, r.get(0));
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)i, r.get(1));
        }
    }

    @Test
    public void testPaginationGet() throws Exception {
        FieldsQueryCursor qry = intCache.query(this.sqlFieldsQuery("select _key, _val from Integer").setPageSize(10));
        ArrayList list = new ArrayList(qry.getAll());
        this.dedup(list);
        Collections.sort(list, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> r1, List<?> r2) {
                return ((Integer)r1.get(0)).compareTo((Integer)r2.get(0));
            }
        });
        for (int i = 0; i < 200; ++i) {
            List row = (List)list.get(i);
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)i, row.get(0));
            IgniteCacheAbstractFieldsQuerySelfTest.assertEquals((Object)i, row.get(1));
        }
    }

    @Test
    public void testEmptyGrid() throws Exception {
        FieldsQueryCursor qry = personCache.query(this.sqlFieldsQuery("select name, age from Person where age = 25"));
        List res = (List)F.first((List)qry.getAll());
        assert (res != null);
        assert (res.size() == 2);
        assert ("John White".equals(res.get(0)));
        assert (res.get(1).equals(25));
    }

    private void dedup(Collection<List<?>> res) throws Exception {
        assert (res != null);
        if (this.cacheMode() != CacheMode.REPLICATED) {
            return;
        }
        ArrayList res0 = new ArrayList(res.size());
        HashSet keys = new HashSet();
        for (List<?> row : res) {
            Object key = row.get(0);
            if (keys.contains(key)) continue;
            res0.add(row);
            keys.add(key);
        }
        res.clear();
        res.addAll(res0);
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String name;

        private Organization(int id, String name) {
            assert (id > 0);
            assert (!F.isEmpty((String)name));
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Organization that = (Organization)o;
            return this.id == that.id && this.name.equals(that.name);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + this.name.hashCode();
            return res;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=false)
        private final String name;
        @QuerySqlField(index=true)
        private final int age;
        @QuerySqlField(index=true)
        private final int orgId;

        private Person(String name, int age, int orgId) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            assert (orgId > 0);
            this.name = name;
            this.age = age;
            this.orgId = orgId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.age == person.age && this.orgId == person.orgId && this.name.equals(person.name);
        }

        public int hashCode() {
            int res = this.name.hashCode();
            res = 31 * res + this.age;
            res = 31 * res + this.orgId;
            return res;
        }
    }

    private static class PersonKey
    implements Serializable {
        @QuerySqlField
        private final UUID id;

        private PersonKey(UUID id) {
            assert (id != null);
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonKey key = (PersonKey)o;
            return this.id.equals(key.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

