/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridCacheQuerySimpleBenchmark
extends GridCommonAbstractTest {
    private Ignite ignite;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName("offheap-cache");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setIndexedTypes(new Class[]{Long.class, Person.class});
        c.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return c;
    }

    protected void beforeTest() throws Exception {
        this.ignite = this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.ignite = null;
    }

    protected long getTestTimeout() {
        return 900000L;
    }

    @Test
    public void testPerformance() throws Exception {
        GridRandom rnd = new GridRandom();
        final IgniteCache c = this.ignite.cache("offheap-cache");
        X.println((String)"___ PUT start", (Object[])new Object[0]);
        int cnt = 100000;
        int maxSalary = 10000;
        for (long i = 0L; i < 100000L; ++i) {
            c.put((Object)i, (Object)new Person(rnd.nextInt(10000), "Vasya " + i));
        }
        X.println((String)"___ PUT end", (Object[])new Object[0]);
        final AtomicBoolean end = new AtomicBoolean();
        final LongAdder puts = new LongAdder();
        IgniteInternalFuture fut0 = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridRandom rnd = new GridRandom();
                while (!end.get()) {
                    long i = rnd.nextInt(100000);
                    c.put((Object)i, (Object)new Person(rnd.nextInt(10000), "Vasya " + i));
                    puts.increment();
                }
                return null;
            }
        }, 10);
        final LongAdder qrys = new LongAdder();
        IgniteInternalFuture fut1 = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridRandom rnd = new GridRandom();
                while (!end.get()) {
                    int salary = rnd.nextInt(10000);
                    c.query(new SqlFieldsQuery("select name from Person where salary = ?").setArgs(new Object[]{salary})).getAll();
                    qrys.increment();
                }
                return null;
            }
        }, 10);
        int runTimeSec = 600;
        for (int s = 0; s < runTimeSec; ++s) {
            Thread.sleep(1000L);
            long puts0 = puts.sum();
            long qrys0 = qrys.sum();
            puts.add(-puts0);
            qrys.add(-qrys0);
            X.println((String)("___ puts: " + puts0 + " qrys: " + qrys0), (Object[])new Object[0]);
        }
        end.set(true);
        fut0.get();
        fut1.get();
        X.println((String)"___ STOP", (Object[])new Object[0]);
    }

    private static class Person
    implements Externalizable {
        @QuerySqlField(index=true)
        int salary;
        @QuerySqlField
        String name;

        public Person() {
        }

        Person(int salary, String name) {
            this.salary = salary;
            this.name = name;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.salary);
            U.writeString((DataOutput)out, (String)this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.salary = in.readInt();
            this.name = U.readString((DataInput)in);
        }
    }
}

