/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheQueryTestValue;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridCacheQuerySerializationSelfTest
extends GridCommonAbstractTest {
    private static final int GRID_CNT = 2;
    private static final String CACHE_NAME = "A";
    private static final CacheMode CACHE_MODE = CacheMode.PARTITIONED;

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cacheCfg = GridCacheQuerySerializationSelfTest.defaultCacheConfiguration();
        cacheCfg.setName(CACHE_NAME);
        cacheCfg.setCacheMode(CACHE_MODE);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, GridCacheQueryTestValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    private GridCacheQueryTestValue value(String f1, int f2, long f3) {
        GridCacheQueryTestValue val = new GridCacheQueryTestValue();
        val.setField1(f1);
        val.setField2(f2);
        val.setField3(f3);
        return val;
    }

    @Test
    public void testSerialization() throws Exception {
        IgniteEx g0 = this.grid(0);
        IgniteCache c0 = g0.cache(CACHE_NAME);
        c0.put((Object)1, (Object)this.value(CACHE_NAME, 1, 1L));
        c0.put((Object)2, (Object)this.value("B", 2, 2L));
        IgniteEx g1 = this.grid(1);
        IgniteCache c1 = g1.cache(CACHE_NAME);
        c1.put((Object)3, (Object)this.value("C", 3, 3L));
        c1.put((Object)4, (Object)this.value("D", 4, 4L));
        List qryRes = (List)g0.compute(g0.cluster().forNode(g1.localNode(), new ClusterNode[0])).withNoFailover().call((IgniteCallable)new QueryCallable());
        assert (!qryRes.isEmpty());
        this.info(">>>> Query result:");
        for (Cache.Entry entry : qryRes) {
            this.info(">>>>>>>" + entry.getKey() + " " + ((GridCacheQueryTestValue)entry.getValue()).getField1());
        }
    }

    private static class QueryCallable
    implements IgniteCallable<List<Cache.Entry<Integer, GridCacheQueryTestValue>>> {
        @IgniteInstanceResource
        private Ignite ignite;

        private QueryCallable() {
        }

        public List<Cache.Entry<Integer, GridCacheQueryTestValue>> call() throws Exception {
            IgniteCache c = this.ignite.cache(GridCacheQuerySerializationSelfTest.CACHE_NAME);
            String sqlStr = "FROM GridCacheQueryTestValue WHERE fieldname = ?";
            SqlQuery sql = new SqlQuery(GridCacheQueryTestValue.class, sqlStr);
            sql.setArgs(new Object[]{"C"});
            return c.query((Query)sql.setSql(sqlStr)).getAll();
        }
    }
}

