/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridCacheQueryIndexDisabledSelfTest
extends GridCommonAbstractTest {
    public GridCacheQueryIndexDisabledSelfTest() {
        super(true);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = GridCacheQueryIndexDisabledSelfTest.defaultCacheConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testSqlQuery() throws Exception {
        block4: {
            IgniteCache cache = this.grid().getOrCreateCache(SqlValue.class.getSimpleName());
            try {
                cache.query((Query)new SqlQuery(SqlValue.class, "val >= 0")).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testSqlFieldsQuery() throws Exception {
        block9: {
            IgniteCache cache;
            block8: {
                cache = this.grid().getOrCreateCache(SqlValue.class.getSimpleName());
                try {
                    cache.query(new SqlFieldsQuery("select * from Person")).getAll();
                    assert (false);
                }
                catch (CacheException e) {
                    X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
                }
                catch (Exception ignored) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            try {
                cache.query(new SqlFieldsQuery("select * from Person")).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testFullTextQuery() throws Exception {
        block4: {
            IgniteCache cache = this.grid().getOrCreateCache(String.class.getSimpleName());
            try {
                cache.query((Query)new TextQuery(String.class, "text")).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testScanLocalQuery() throws Exception {
        IgniteCache cache = this.grid().getOrCreateCache(String.class.getSimpleName());
        try {
            cache.query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<Integer, String>(){

                public boolean apply(Integer id, String s) {
                    return s.equals("");
                }
            }).setLocal(true)).getAll();
        }
        catch (IgniteException ignored) {
            GridCacheQueryIndexDisabledSelfTest.assertTrue((String)"Scan query should work with disable query indexing.", (boolean)false);
        }
    }

    @Test
    public void testSqlLocalQuery() throws Exception {
        block4: {
            IgniteCache cache = this.grid().getOrCreateCache(SqlValue.class.getSimpleName());
            try {
                cache.query((Query)new SqlQuery(SqlValue.class, "val >= 0").setLocal(true)).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testSqlLocalFieldsQuery() throws Exception {
        block4: {
            IgniteCache cache = this.grid().getOrCreateCache(SqlValue.class.getSimpleName());
            try {
                cache.query(new SqlFieldsQuery("select * from Person")).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testFullTextLocalQuery() throws Exception {
        block4: {
            IgniteCache cache = this.grid().getOrCreateCache(String.class.getSimpleName());
            try {
                cache.query((Query)new TextQuery(String.class, "text").setLocal(true)).getAll();
                assert (false);
            }
            catch (CacheException e) {
                X.println((String)("Caught expected exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            catch (Exception ignored) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testScanQuery() throws Exception {
        IgniteCache cache = this.grid().getOrCreateCache(String.class.getSimpleName());
        try {
            cache.query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<Integer, String>(){

                public boolean apply(Integer id, String s) {
                    return s.equals("");
                }
            })).getAll();
        }
        catch (IgniteException ignored) {
            GridCacheQueryIndexDisabledSelfTest.assertTrue((String)"Scan query should work with disabled query indexing.", (boolean)false);
        }
    }

    private static class SqlValue {
        @QuerySqlField
        private final int val;

        SqlValue(int val) {
            this.val = val;
        }

        int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(SqlValue.class, (Object)this);
        }
    }
}

