/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GridCacheLazyQueryPartitionsReleaseTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = GridCacheLazyQueryPartitionsReleaseTest.defaultCacheConfiguration().setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setRebalanceMode(CacheRebalanceMode.ASYNC).setRebalanceBatchSize(1000).setRebalanceDelay(0L).setName(PERSON_CACHE).setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testLazyQueryPartitionsRelease() throws Exception {
        IgniteEx node1 = this.startGrid(0);
        IgniteCache cache = node1.cache(PERSON_CACHE);
        cache.clear();
        Affinity aff = node1.affinity(PERSON_CACHE);
        int partsFilled = this.fillAllPartitions((IgniteCache<Integer, Person>)cache, (Affinity<Integer>)aff);
        SqlFieldsQuery qry = new SqlFieldsQuery("select name, age from person").setLazy(true).setPageSize(1);
        FieldsQueryCursor qryCursor = cache.query(qry);
        Iterator it = qryCursor.iterator();
        int resCntr = 0;
        if (it.hasNext()) {
            it.next();
            ++resCntr;
        } else {
            GridCacheLazyQueryPartitionsReleaseTest.fail((String)"No query results.");
        }
        this.startGrid(1);
        for (Ignite ig : G.allGrids()) {
            ig.cache(PERSON_CACHE).rebalance().get();
        }
        while (it.hasNext()) {
            it.next();
            ++resCntr;
        }
        GridCacheLazyQueryPartitionsReleaseTest.assertEquals((String)"Wrong result set size", (int)partsFilled, (int)resCntr);
    }

    @Test
    public void testLazyQueryPartitionsReleaseOnClose() throws Exception {
        IgniteEx node1 = this.startGrid(0);
        IgniteCache cache = node1.cache(PERSON_CACHE);
        cache.clear();
        Affinity aff = node1.affinity(PERSON_CACHE);
        int partsFilled = this.fillAllPartitions((IgniteCache<Integer, Person>)cache, (Affinity<Integer>)aff);
        SqlFieldsQuery qry = new SqlFieldsQuery("select name, age from person").setLazy(true).setPageSize(1);
        FieldsQueryCursor qryCursor = cache.query(qry);
        Iterator it = qryCursor.iterator();
        if (it.hasNext()) {
            it.next();
        } else {
            GridCacheLazyQueryPartitionsReleaseTest.fail((String)"No query results.");
        }
        this.startGrid(1);
        qryCursor.close();
        for (Ignite ig : G.allGrids()) {
            ig.cache(PERSON_CACHE).rebalance().get();
        }
        GridCacheLazyQueryPartitionsReleaseTest.assertEquals((String)"Wrong result set size", (int)partsFilled, (int)cache.query(qry).getAll().size());
    }

    private int fillAllPartitions(IgniteCache<Integer, Person> cache, Affinity<Integer> aff) {
        int partsCnt = aff.partitions();
        HashSet<Integer> emptyParts = new HashSet<Integer>(partsCnt);
        for (int i = 0; i < partsCnt; ++i) {
            emptyParts.add(i);
        }
        int cntr = 0;
        while (!emptyParts.isEmpty()) {
            int part;
            if (emptyParts.remove(part = aff.partition((Object)cntr++))) {
                cache.put((Object)cntr, (Object)new Person("p_" + cntr, cntr));
            }
            if (cntr <= 100000) continue;
            GridCacheLazyQueryPartitionsReleaseTest.fail((String)"Failed to fill all partitions");
        }
        return partsCnt;
    }

    public static class Person
    implements Serializable {
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

