/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DdlTransactionSelfTest
extends GridCommonAbstractTest {
    private boolean client;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setTransactionConfiguration(new TransactionConfiguration().setDefaultTxIsolation(TransactionIsolation.REPEATABLE_READ).setDefaultTxConcurrency(TransactionConcurrency.PESSIMISTIC).setDefaultTxTimeout(5000L));
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfiguration()});
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration getCacheConfiguration() {
        CacheConfiguration ccfg = DdlTransactionSelfTest.defaultCacheConfiguration();
        ccfg.setNearConfiguration(null);
        return ccfg;
    }

    @Test
    public void testTxIsCommittedOnDdlRequestMultinodeClient() throws Exception {
        this.startGridsMultiThreaded(4, false);
        this.client = true;
        IgniteEx node = this.startGrid(4);
        this.awaitPartitionMapExchange();
        IgniteCache cache = node.cache("default");
        try (Transaction tx = node.transactions().txStart();){
            cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
            try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
                DdlTransactionSelfTest.assertNotNull((Object)cur);
                List rows = cur.getAll();
                DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
                DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
            }
            DdlTransactionSelfTest.assertTrue((tx.state() == TransactionState.COMMITTED ? 1 : 0) != 0);
        }
        var4_4 = null;
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testTxIsCommittedOnDdlRequestMultinode() throws Exception {
        Ignite node = this.startGridsMultiThreaded(4);
        IgniteCache cache = node.cache("default");
        try (Transaction tx = node.transactions().txStart();){
            cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
            try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
                DdlTransactionSelfTest.assertNotNull((Object)cur);
                List rows = cur.getAll();
                DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
                DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
            }
            DdlTransactionSelfTest.assertTrue((tx.state() == TransactionState.COMMITTED ? 1 : 0) != 0);
        }
        var4_4 = null;
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testTxIsCommittedOnDdlRequest() throws Exception {
        Ignite node = this.startGrid();
        IgniteCache cache = node.cache("default");
        try (Transaction tx = node.transactions().txStart();){
            cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
            try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
                DdlTransactionSelfTest.assertNotNull((Object)cur);
                List rows = cur.getAll();
                DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
                DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
            }
            DdlTransactionSelfTest.assertTrue((tx.state() == TransactionState.COMMITTED ? 1 : 0) != 0);
        }
        var4_4 = null;
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testDdlRequestWithoutTxMultinodeClient() throws Exception {
        List rows;
        this.startGridsMultiThreaded(4, false);
        this.client = true;
        IgniteEx node = this.startGrid(4);
        this.awaitPartitionMapExchange();
        IgniteCache cache = node.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
            DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));
        var4_4 = null;
        try {
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var4_4 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testDdlRequestWithoutTxMultinode() throws Exception {
        List rows;
        Ignite node = this.startGridsMultiThreaded(4);
        IgniteCache cache = node.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
            DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));
        var4_4 = null;
        try {
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var4_4 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testDdlRequestWithoutTx() throws Exception {
        List rows;
        Ignite node = this.startGrid();
        IgniteCache cache = node.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("CREATE TABLE     person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))WITH     \"template=PARTITIONED,atomicity=TRANSACTIONAL,affinity_key=city\"").setSchema("PUBLIC"));){
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)1, (int)rows.size());
            DdlTransactionSelfTest.assertEquals((Object)0L, ((List)rows.get(0)).get(0));
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM person").setSchema("PUBLIC"));
        var4_4 = null;
        try {
            DdlTransactionSelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            DdlTransactionSelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var4_4 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        DdlTransactionSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        DdlTransactionSelfTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        DdlTransactionSelfTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }
}

