/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheRandomOperationsMultithreadedTest
extends GridCommonAbstractTest {
    private static final int KEYS = 1000;
    private static final int NODES = 4;
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        this.client = true;
        this.startGrid(3);
        super.beforeTestsStarted();
    }

    @Test
    public void testAtomicOffheapEviction() throws Exception {
        CacheConfiguration<Object, Object> ccfg = this.cacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, (EvictionPolicy<Object, Object>)new LruEvictionPolicy(10), false);
        this.randomOperations(ccfg);
    }

    @Test
    public void testAtomicOffheapEvictionIndexing() throws Exception {
        CacheConfiguration<Object, Object> ccfg = this.cacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, (EvictionPolicy<Object, Object>)new LruEvictionPolicy(10), true);
        this.randomOperations(ccfg);
    }

    @Test
    public void testTxOffheapEviction() throws Exception {
        CacheConfiguration<Object, Object> ccfg = this.cacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, (EvictionPolicy<Object, Object>)new LruEvictionPolicy(10), false);
        this.randomOperations(ccfg);
    }

    @Test
    public void testTxOffheapEvictionIndexing() throws Exception {
        CacheConfiguration<Object, Object> ccfg = this.cacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, (EvictionPolicy<Object, Object>)new LruEvictionPolicy(10), true);
        this.randomOperations(ccfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void randomOperations(final CacheConfiguration<Object, Object> ccfg) throws Exception {
        this.ignite(0).createCache(ccfg);
        try {
            final long stopTime = U.currentTimeMillis() + 30000L;
            final boolean indexing = !F.isEmpty((Object[])ccfg.getIndexedTypes()) || !F.isEmpty((Collection)ccfg.getQueryEntities());
            GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                public void apply(Integer idx) {
                    Ignite ignite = CacheRandomOperationsMultithreadedTest.this.ignite(idx % 4);
                    IgniteCache cache = ignite.cache(ccfg.getName());
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    while (U.currentTimeMillis() < stopTime) {
                        CacheRandomOperationsMultithreadedTest.this.randomOperation(rnd, (IgniteCache<Object, Object>)cache, indexing);
                    }
                }
            }, (int)1, (String)"test-thread");
        }
        finally {
            this.ignite(0).destroyCache(ccfg.getName());
        }
    }

    private void randomOperation(ThreadLocalRandom rnd, IgniteCache<Object, Object> cache, boolean indexing) {
        int r0 = rnd.nextInt(100);
        if (r0 == 0) {
            cache.clear();
        } else if (r0 == 1) {
            cache.size(new CachePeekMode[0]);
        }
        switch (rnd.nextInt(14)) {
            case 0: {
                cache.put(this.key(rnd), this.value(rnd));
                break;
            }
            case 1: {
                cache.getAndPut(this.key(rnd), this.value(rnd));
                break;
            }
            case 2: {
                cache.get(this.key(rnd));
                break;
            }
            case 3: {
                cache.remove(this.key(rnd));
                break;
            }
            case 4: {
                cache.getAndRemove(this.key(rnd));
                break;
            }
            case 5: {
                TreeMap<Object, Object> map = new TreeMap<Object, Object>();
                for (int i = 0; i < 50; ++i) {
                    map.put(this.key(rnd), this.value(rnd));
                }
                cache.putAll(map);
                break;
            }
            case 6: {
                cache.getAll(this.keys(50, rnd));
                break;
            }
            case 7: {
                cache.removeAll(this.keys(50, rnd));
                break;
            }
            case 8: {
                cache.putIfAbsent(this.key(rnd), this.value(rnd));
                break;
            }
            case 9: {
                cache.getAndPutIfAbsent(this.key(rnd), this.value(rnd));
                break;
            }
            case 10: {
                cache.replace(this.key(rnd), this.value(rnd));
                break;
            }
            case 11: {
                cache.getAndReplace(this.key(rnd), this.value(rnd));
                break;
            }
            case 12: {
                ScanQuery qry = new ScanQuery();
                qry.setFilter((IgniteBiPredicate)new TestFilter());
                List res = cache.query((Query)qry).getAll();
                CacheRandomOperationsMultithreadedTest.assertTrue((res.size() >= 0 ? 1 : 0) != 0);
                break;
            }
            case 13: {
                if (!indexing) break;
                SqlQuery qry = new SqlQuery(TestData.class, "where val1 > ?");
                qry.setArgs(new Object[]{500});
                List res = cache.query((Query)qry).getAll();
                CacheRandomOperationsMultithreadedTest.assertTrue((res.size() >= 0 ? 1 : 0) != 0);
                break;
            }
            default: {
                CacheRandomOperationsMultithreadedTest.fail();
            }
        }
    }

    private Set<Object> keys(int cnt, ThreadLocalRandom rnd) {
        TreeSet<Object> keys = new TreeSet<Object>();
        for (int i = 0; i < cnt; ++i) {
            keys.add(this.key(rnd));
        }
        return keys;
    }

    private Object key(ThreadLocalRandom rnd) {
        return new TestKey(rnd.nextInt(1000), rnd);
    }

    private Object value(ThreadLocalRandom rnd) {
        return new TestData(rnd);
    }

    private CacheConfiguration<Object, Object> cacheConfiguration(CacheMode cacheMode, CacheAtomicityMode atomicityMode, @Nullable EvictionPolicy<Object, Object> evictionPlc, boolean indexing) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setAtomicityMode(atomicityMode);
        ccfg.setCacheMode(cacheMode);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setEvictionPolicy(evictionPlc);
        ccfg.setOnheapCacheEnabled(evictionPlc != null);
        if (cacheMode == CacheMode.PARTITIONED) {
            ccfg.setBackups(1);
        }
        if (indexing) {
            ccfg.setIndexedTypes(new Class[]{TestKey.class, TestData.class});
        }
        return ccfg;
    }

    static class TestData
    implements Serializable {
        @QuerySqlField(index=true)
        private int val1;
        private long val2;
        @QuerySqlField(index=true)
        private String val3;
        private byte[] val4;

        public TestData(ThreadLocalRandom rnd) {
            this.val1 = rnd.nextInt();
            this.val2 = this.val1;
            this.val3 = String.valueOf(this.val1);
            this.val4 = new byte[rnd.nextInt(1024)];
        }
    }

    static class TestKey
    implements Serializable,
    Comparable<TestKey> {
        private int key;
        private byte[] byteVal;

        @Override
        public int compareTo(TestKey o) {
            return Integer.compare(this.key, o.key);
        }

        public TestKey(int key, ThreadLocalRandom rnd) {
            this.key = key;
            this.byteVal = new byte[rnd.nextInt(100)];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey testKey = (TestKey)o;
            return this.key == testKey.key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    static class TestFilter
    implements IgniteBiPredicate<Object, Object> {
        TestFilter() {
        }

        public boolean apply(Object key, Object val) {
            return ThreadLocalRandom.current().nextInt(10) == 0;
        }
    }
}

