/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheQueryFilterExpiredTest
extends GridCommonAbstractTest {
    @Test
    public void testFilterExpired() throws Exception {
        try (IgniteEx ignite = this.startGrid(0);){
            this.checkFilterExpired((Ignite)ignite, CacheAtomicityMode.ATOMIC, false);
            this.checkFilterExpired((Ignite)ignite, CacheAtomicityMode.ATOMIC, true);
            this.checkFilterExpired((Ignite)ignite, CacheAtomicityMode.TRANSACTIONAL, false);
            this.checkFilterExpired((Ignite)ignite, CacheAtomicityMode.TRANSACTIONAL, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFilterExpired(Ignite ignite, CacheAtomicityMode atomicityMode, boolean eagerTtl) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setAtomicityMode(atomicityMode);
        ccfg.setEagerTtl(eagerTtl);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        final IgniteCache cache = ignite.createCache(ccfg);
        try {
            IgniteCache expCache = cache.withExpiryPolicy((ExpiryPolicy)new TouchedExpiryPolicy(new Duration(0L, 2000L)));
            for (int i = 0; i < 10; ++i) {
                IgniteCache cache0 = i % 2 == 0 ? cache : expCache;
                cache0.put((Object)i, (Object)i);
            }
            CacheQueryFilterExpiredTest.assertEquals((int)10, (int)cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll().size());
            CacheQueryFilterExpiredTest.assertEquals((int)10, (int)cache.query(new SqlFieldsQuery("select _key, _val from Integer")).getAll().size());
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    return cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll().size() == 5 && cache.query(new SqlFieldsQuery("select _key, _val from Integer")).getAll().size() == 5;
                }
            }, (long)5000L);
            CacheQueryFilterExpiredTest.assertEquals((int)5, (int)cache.query((Query)new SqlQuery(Integer.class, "1=1")).getAll().size());
            CacheQueryFilterExpiredTest.assertEquals((int)5, (int)cache.query(new SqlFieldsQuery("select _key, _val from Integer")).getAll().size());
        }
        finally {
            ignite.destroyCache(ccfg.getName());
        }
    }
}

