/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.TreeMap;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheOffheapBatchIndexingBaseTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheOffheapBatchIndexingSingleTypeTest
extends CacheOffheapBatchIndexingBaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchRemove() throws Exception {
        IgniteEx ignite = this.grid(0);
        CacheConfiguration<Object, Object> ccfg = this.cacheConfiguration(new Class[]{Integer.class, CacheOffheapBatchIndexingBaseTest.Organization.class});
        IgniteCache cache = ignite.createCache(ccfg);
        try {
            int iterations = 50;
            while (iterations-- >= 0) {
                int total = 1000;
                for (int id = 0; id < total; ++id) {
                    cache.put((Object)id, (Object)new CacheOffheapBatchIndexingBaseTest.Organization(id, "Organization " + id));
                }
                cache.invoke((Object)0, (CacheEntryProcessor)new CacheEntryProcessor<Object, Object, Object>(){

                    public Object process(MutableEntry<Object, Object> entry, Object ... args) {
                        entry.remove();
                        return null;
                    }
                }, new Object[0]);
                FieldsQueryCursor q = cache.query(new SqlFieldsQuery("select _key,_val from Organization where id=0"));
                CacheOffheapBatchIndexingSingleTypeTest.assertEquals((int)0, (int)q.getAll().size());
                q = cache.query(new SqlFieldsQuery("select _key,_val from Organization where id=1"));
                CacheOffheapBatchIndexingSingleTypeTest.assertEquals((int)1, (int)q.getAll().size());
                CacheOffheapBatchIndexingSingleTypeTest.assertEquals((int)(total - 1), (int)cache.size(new CachePeekMode[0]));
                cache.removeAll();
            }
        }
        finally {
            cache.destroy();
        }
    }

    @Test
    public void testPutAllAndStreamer() {
        this.doStreamerBatchTest(50, 1000, new Class[]{Integer.class, CacheOffheapBatchIndexingBaseTest.Organization.class}, true);
    }

    @Test
    public void testPuAllSingleEntity() {
        this.doStreamerBatchTest(50, 1000, new Class[]{Integer.class, CacheOffheapBatchIndexingBaseTest.Organization.class}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStreamerBatchTest(int iterations, int entitiesCnt, Class<?>[] entityClasses, boolean preloadInStreamer) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.createCache(this.cacheConfiguration(entityClasses));
        try {
            if (preloadInStreamer) {
                this.preload(cache.getName());
            }
            while (iterations-- >= 0) {
                TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization> putMap1 = new TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization>();
                for (int i = 0; i < entitiesCnt; ++i) {
                    putMap1.put(i, new CacheOffheapBatchIndexingBaseTest.Organization(i, String.valueOf(i)));
                }
                cache.putAll(putMap1);
                TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization> putMap2 = new TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization>();
                for (int i = entitiesCnt / 2; i < entitiesCnt * 3 / 2; ++i) {
                    cache.remove((Object)i);
                    putMap2.put(i, new CacheOffheapBatchIndexingBaseTest.Organization(i, String.valueOf(i)));
                }
                cache.putAll(putMap2);
            }
        }
        finally {
            cache.destroy();
        }
    }
}

