/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheIteratorScanQueryTest
extends GridCommonAbstractTest {
    private boolean client = false;
    private CacheConfiguration[] ccfgs = null;

    public CacheIteratorScanQueryTest() {
        super(false);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.client = false;
    }

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.setClientMode(this.client);
        cfg.setCacheConfiguration(this.ccfgs);
        return cfg;
    }

    @Test
    public void testScanQuery() throws Exception {
        IgniteEx server = this.startGrid(0);
        this.client = true;
        this.ccfgs = new CacheConfiguration[]{new CacheConfiguration("test-cache-replicated").setCacheMode(CacheMode.REPLICATED).setNodeFilter((IgnitePredicate)new AlwaysFalseCacheFilter()), new CacheConfiguration("test-cache-partitioned").setCacheMode(CacheMode.PARTITIONED).setNodeFilter((IgnitePredicate)new AlwaysFalseCacheFilter())};
        IgniteEx client = this.startGrid(1);
        CacheIteratorScanQueryTest.assertEquals((int)2, (int)server.cluster().nodes().size());
        CacheIteratorScanQueryTest.assertEquals((int)1, (int)server.cluster().forServers().nodes().size());
        CacheIteratorScanQueryTest.assertEquals((int)1, (int)server.cluster().forClients().nodes().size());
        CacheIteratorScanQueryTest.assertEquals((int)2, (int)client.cluster().nodes().size());
        CacheIteratorScanQueryTest.assertEquals((int)1, (int)client.cluster().forServers().nodes().size());
        CacheIteratorScanQueryTest.assertEquals((int)1, (int)client.cluster().forClients().nodes().size());
        for (CacheConfiguration cfg : this.ccfgs) {
            IgniteCache cache = client.cache(cfg.getName());
            CacheIteratorScanQueryTest.assertNotNull((Object)cache);
            CacheIteratorScanQueryTest.assertNotNull((Object)cache.iterator());
            CacheIteratorScanQueryTest.assertFalse((boolean)cache.iterator().hasNext());
        }
    }

    @Test
    public void testQueryGetAllClientSide() throws Exception {
        IgniteEx server = this.startGrid(0);
        IgniteCache cache = server.getOrCreateCache("default");
        this.client = true;
        IgniteEx client = this.startGrid(1);
        IgniteCache cliCache = client.cache("default");
        for (int i = 0; i < 100000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        ScanQuery qry = new ScanQuery();
        qry.setPageSize(100);
        try (QueryCursor cur = cliCache.query((Query)qry);){
            List res = cur.getAll();
            CacheIteratorScanQueryTest.assertEquals((int)100000, (int)res.size());
            Collections.sort(res, (e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey()));
            int exp = 0;
            for (Cache.Entry e : res) {
                CacheIteratorScanQueryTest.assertEquals((int)exp, (int)((Integer)e.getKey()));
                CacheIteratorScanQueryTest.assertEquals((int)exp, (int)((Integer)e.getValue()));
                ++exp;
            }
        }
    }

    public static class AlwaysFalseCacheFilter
    implements IgnitePredicate<ClusterNode> {
        public boolean apply(ClusterNode node) {
            return false;
        }
    }
}

