/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMetricsAdapter;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CacheAbstractQueryMetricsSelfTest
extends GridCommonAbstractTest {
    protected int gridCnt;
    protected CacheMode cacheMode;

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(this.gridCnt);
        IgniteCache cacheA = this.grid(0).cache("A");
        IgniteCache cacheB = this.grid(0).cache("B");
        for (int i = 0; i < 100; ++i) {
            cacheA.put((Object)i, (Object)String.valueOf(i));
            cacheB.put((Object)i, (Object)String.valueOf(i));
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cacheCfg1 = CacheAbstractQueryMetricsSelfTest.defaultCacheConfiguration();
        cacheCfg1.setName("A");
        cacheCfg1.setCacheMode(this.cacheMode);
        cacheCfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg1.setIndexedTypes(new Class[]{Integer.class, String.class});
        cacheCfg1.setStatisticsEnabled(true);
        CacheConfiguration cacheCfg2 = CacheAbstractQueryMetricsSelfTest.defaultCacheConfiguration();
        cacheCfg2.setName("B");
        cacheCfg2.setCacheMode(this.cacheMode);
        cacheCfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg2.setIndexedTypes(new Class[]{Integer.class, String.class});
        cacheCfg2.setStatisticsEnabled(true);
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg1, cacheCfg2});
        return cfg;
    }

    @Test
    public void testSqlFieldsQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, false);
    }

    @Test
    public void testSqlFieldsQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from UNKNOWN");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testScanQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery();
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testScanQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery();
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testScanQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery(Integer.MAX_VALUE);
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("String", "from String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("String", "from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testSqlQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("Long", "from Long");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testTextQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("String", "1");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testTextQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("String", "1");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testTextQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("Unknown", "zzz");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, false);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"G\".String");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testQueryMetricsMultithreaded() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ArrayList<Worker> workers = new ArrayList<Worker>();
        int repeat = 100;
        for (int i = 0; i < repeat; ++i) {
            workers.add(new Worker((IgniteCache)cache, (Query)new SqlFieldsQuery("select * from String limit " + i)));
            workers.add(new Worker((IgniteCache)cache, (Query)new SqlQuery("String", "from String")));
            workers.add(new Worker((IgniteCache)cache, (Query)new ScanQuery()));
            workers.add(new Worker((IgniteCache)cache, (Query)new TextQuery("String", "1")));
        }
        for (Worker worker : workers) {
            worker.start();
        }
        for (Worker worker : workers) {
            worker.join();
        }
        this.checkMetrics((IgniteCache<Integer, String>)cache, repeat * 4, repeat * 4, 0, false);
    }

    private void checkMetrics(IgniteCache<Integer, String> cache, int execs, int completions, int failures, boolean first) {
        GridCacheQueryMetricsAdapter m = (GridCacheQueryMetricsAdapter)cache.queryMetrics();
        CacheAbstractQueryMetricsSelfTest.assertNotNull((Object)m);
        this.info("Metrics: " + m);
        CacheAbstractQueryMetricsSelfTest.assertEquals((String)"Executions", (int)execs, (int)m.executions());
        CacheAbstractQueryMetricsSelfTest.assertEquals((String)"Completions", (int)completions, (int)m.completedExecutions());
        CacheAbstractQueryMetricsSelfTest.assertEquals((String)"Failures", (int)failures, (int)m.fails());
        CacheAbstractQueryMetricsSelfTest.assertTrue((m.averageTime() >= 0.0 ? 1 : 0) != 0);
        CacheAbstractQueryMetricsSelfTest.assertTrue((m.maximumTime() >= 0L ? 1 : 0) != 0);
        CacheAbstractQueryMetricsSelfTest.assertTrue((m.minimumTime() >= 0L ? 1 : 0) != 0);
        if (first) {
            CacheAbstractQueryMetricsSelfTest.assertTrue((String)"On first execution minTime == maxTime", (m.minimumTime() == m.maximumTime() ? 1 : 0) != 0);
        }
    }

    private void checkQueryMetrics(IgniteCache<Integer, String> cache, Query qry) {
        cache.query(qry).getAll();
        this.checkMetrics(cache, 1, 1, 0, true);
        cache.query(qry).getAll();
        this.checkMetrics(cache, 2, 2, 0, false);
    }

    private void checkQueryNotFullyFetchedMetrics(IgniteCache<Integer, String> cache, Query qry, boolean waitingForCompletion) throws IgniteInterruptedCheckedException {
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            CacheAbstractQueryMetricsSelfTest.waitingForCompletion(cache, 1);
        }
        this.checkMetrics(cache, 1, 1, 0, true);
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            CacheAbstractQueryMetricsSelfTest.waitingForCompletion(cache, 2);
        }
        this.checkMetrics(cache, 2, 2, 0, false);
    }

    private void checkQueryFailedMetrics(IgniteCache<Integer, String> cache, Query qry) {
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(cache, 1, 0, 1, true);
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(cache, 2, 0, 2, true);
    }

    private static void waitingForCompletion(final IgniteCache<Integer, String> cache, final int exp) throws IgniteInterruptedCheckedException {
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                GridCacheQueryMetricsAdapter m = (GridCacheQueryMetricsAdapter)cache.queryMetrics();
                return m.completedExecutions() == exp;
            }
        }, (long)5000L);
    }

    private static class Worker
    extends Thread {
        private final IgniteCache cache;
        private final Query qry;

        Worker(IgniteCache cache, Query qry) {
            this.cache = cache;
            this.qry = qry;
        }

        @Override
        public void run() {
            this.cache.query(this.qry).getAll();
        }
    }
}

