/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CacheAbstractQueryDetailMetricsSelfTest
extends GridCommonAbstractTest {
    private static final int QRY_DETAIL_METRICS_SIZE = 3;
    protected int gridCnt;
    protected CacheMode cacheMode;

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(this.gridCnt);
        IgniteCache cacheA = this.grid(0).cache("A");
        IgniteCache cacheB = this.grid(0).cache("B");
        for (int i = 0; i < 100; ++i) {
            cacheA.put((Object)i, (Object)String.valueOf(i));
            cacheB.put((Object)i, (Object)String.valueOf(i));
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private CacheConfiguration<Integer, String> configureCache(String cacheName) {
        CacheConfiguration ccfg = CacheAbstractQueryDetailMetricsSelfTest.defaultCacheConfiguration();
        ccfg.setName(cacheName);
        ccfg.setCacheMode(this.cacheMode);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        ccfg.setStatisticsEnabled(true);
        ccfg.setQueryDetailMetricsSize(3);
        return ccfg;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.configureCache("A"), this.configureCache("B")});
        return cfg;
    }

    @Test
    public void testSqlFieldsQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, false);
    }

    @Test
    public void testSqlFieldsQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from UNKNOWN");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testQueryMetricsEviction() throws Exception {
        int i;
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        cache.query(new SqlFieldsQuery("select * from String")).getAll();
        Thread.sleep(100L);
        cache.query(new SqlFieldsQuery("select count(*) from String")).getAll();
        Thread.sleep(100L);
        cache.query(new SqlFieldsQuery("select * from String limit 1")).getAll();
        Thread.sleep(100L);
        cache.query(new SqlFieldsQuery("select * from String limit 2")).getAll();
        Thread.sleep(100L);
        cache.query((Query)new ScanQuery()).getAll();
        Thread.sleep(100L);
        cache.query((Query)new SqlQuery("String", "from String")).getAll();
        CacheAbstractQueryDetailMetricsSelfTest.waitingFor((IgniteCache<Integer, String>)cache, "size", 3);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.checkMetrics((IgniteCache<Integer, String>)cache, 3, i2, 1, 1, 0, false);
        }
        Collection metrics = cache.queryDetailMetrics();
        String lastMetrics = "";
        for (QueryDetailMetrics m : metrics) {
            lastMetrics = lastMetrics + m.queryType() + " " + m.query() + ";";
        }
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((boolean)lastMetrics.contains("SQL_FIELDS select * from String limit 2;"));
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((boolean)lastMetrics.contains("SCAN A;"));
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((boolean)lastMetrics.contains("SQL from String;"));
        cache = this.grid(0).context().cache().jcache("B");
        cache.query(new SqlFieldsQuery("select * from String")).getAll();
        cache.query(new SqlFieldsQuery("select count(*) from String")).getAll();
        cache.query(new SqlFieldsQuery("select * from String limit 1")).getAll();
        cache.query(new SqlFieldsQuery("select * from String limit 2")).getAll();
        cache.query((Query)new ScanQuery()).getAll();
        cache.query((Query)new SqlQuery("String", "from String")).getAll();
        CacheAbstractQueryDetailMetricsSelfTest.waitingFor((IgniteCache<Integer, String>)cache, "size", 3);
        for (i = 0; i < 3; ++i) {
            this.checkMetrics((IgniteCache<Integer, String>)cache, 3, i, 1, 1, 0, false);
        }
        if (this.gridCnt > 1) {
            cache = this.grid(1).context().cache().jcache("A");
            cache.query(new SqlFieldsQuery("select * from String")).getAll();
            cache.query(new SqlFieldsQuery("select count(*) from String")).getAll();
            cache.query(new SqlFieldsQuery("select * from String limit 1")).getAll();
            cache.query(new SqlFieldsQuery("select * from String limit 2")).getAll();
            cache.query((Query)new ScanQuery()).getAll();
            cache.query((Query)new SqlQuery("String", "from String")).getAll();
            CacheAbstractQueryDetailMetricsSelfTest.waitingFor((IgniteCache<Integer, String>)cache, "size", 3);
            for (i = 0; i < 3; ++i) {
                this.checkMetrics((IgniteCache<Integer, String>)cache, 3, i, 1, 1, 0, false);
            }
            cache = this.grid(1).context().cache().jcache("B");
            cache.query(new SqlFieldsQuery("select * from String")).getAll();
            cache.query(new SqlFieldsQuery("select count(*) from String")).getAll();
            cache.query(new SqlFieldsQuery("select * from String limit 1")).getAll();
            cache.query(new SqlFieldsQuery("select * from String limit 2")).getAll();
            cache.query((Query)new ScanQuery()).getAll();
            cache.query((Query)new SqlQuery("String", "from String")).getAll();
            CacheAbstractQueryDetailMetricsSelfTest.waitingFor((IgniteCache<Integer, String>)cache, "size", 3);
            for (i = 0; i < 3; ++i) {
                this.checkMetrics((IgniteCache<Integer, String>)cache, 3, i, 1, 1, 0, false);
            }
        }
    }

    @Test
    public void testQueryMetricsMultithreaded() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ArrayList<Worker> workers = new ArrayList<Worker>();
        int repeat = 10;
        for (int k = 0; k < repeat; ++k) {
            for (int i = 1; i <= 3; ++i) {
                workers.add(new Worker((IgniteCache)cache, (Query)new SqlFieldsQuery("select * from String limit " + i)));
            }
        }
        for (Worker worker : workers) {
            worker.start();
        }
        for (Worker worker : workers) {
            worker.join();
        }
        for (int i = 0; i < 3; ++i) {
            this.checkMetrics((IgniteCache<Integer, String>)cache, 3, i, repeat, repeat, 0, false);
        }
    }

    @Test
    public void testScanQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery();
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testScanQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery();
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testScanQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        ScanQuery qry = new ScanQuery(Integer.MAX_VALUE);
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("String", "from String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("String", "from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testSqlQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlQuery qry = new SqlQuery("Long", "from Long");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testTextQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("String", "1");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testTextQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("String", "1");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, true);
    }

    @Test
    public void testTextQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        TextQuery qry = new TextQuery("Unknown", "zzz");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        this.checkQueryMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryNotFullyFetchedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((IgniteCache<Integer, String>)cache, (Query)qry, false);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryFailedMetrics() throws Exception {
        IgniteCacheProxy cache = this.grid(0).context().cache().jcache("A");
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"G\".String");
        this.checkQueryFailedMetrics((IgniteCache<Integer, String>)cache, (Query)qry);
    }

    private void checkMetrics(IgniteCache<Integer, String> cache, int sz, int idx, int execs, int completions, int failures, boolean first) {
        Collection metrics = cache.queryDetailMetrics();
        CacheAbstractQueryDetailMetricsSelfTest.assertNotNull((Object)metrics);
        CacheAbstractQueryDetailMetricsSelfTest.assertEquals((int)sz, (int)metrics.size());
        QueryDetailMetrics m = (QueryDetailMetrics)new ArrayList(metrics).get(idx);
        this.info("Metrics: " + m);
        CacheAbstractQueryDetailMetricsSelfTest.assertEquals((String)"Executions", (int)execs, (int)m.executions());
        CacheAbstractQueryDetailMetricsSelfTest.assertEquals((String)"Completions", (int)completions, (int)m.completions());
        CacheAbstractQueryDetailMetricsSelfTest.assertEquals((String)"Failures", (int)failures, (int)m.failures());
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((m.averageTime() >= 0.0 ? 1 : 0) != 0);
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((m.maximumTime() >= 0L ? 1 : 0) != 0);
        CacheAbstractQueryDetailMetricsSelfTest.assertTrue((m.minimumTime() >= 0L ? 1 : 0) != 0);
        if (first) {
            CacheAbstractQueryDetailMetricsSelfTest.assertTrue((String)"On first execution minTime == maxTime", (m.minimumTime() == m.maximumTime() ? 1 : 0) != 0);
        }
    }

    private void checkQueryMetrics(IgniteCache<Integer, String> cache, Query qry) {
        cache.query(qry).getAll();
        this.checkMetrics(cache, 1, 0, 1, 1, 0, true);
        cache.query(qry).getAll();
        this.checkMetrics(cache, 1, 0, 2, 2, 0, false);
    }

    private void checkQueryNotFullyFetchedMetrics(IgniteCache<Integer, String> cache, Query qry, boolean waitingForCompletion) throws IgniteInterruptedCheckedException {
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            CacheAbstractQueryDetailMetricsSelfTest.waitingFor(cache, "completions", 1);
        }
        this.checkMetrics(cache, 1, 0, 1, 1, 0, true);
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            CacheAbstractQueryDetailMetricsSelfTest.waitingFor(cache, "completions", 2);
        }
        this.checkMetrics(cache, 1, 0, 2, 2, 0, false);
    }

    private void checkQueryFailedMetrics(IgniteCache<Integer, String> cache, Query qry) {
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(cache, 1, 0, 1, 0, 1, true);
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(cache, 1, 0, 2, 0, 2, true);
    }

    private static void waitingFor(final IgniteCache<Integer, String> cache, final String cond, final int exp) throws IgniteInterruptedCheckedException {
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                Collection metrics = cache.queryDetailMetrics();
                switch (cond) {
                    case "size": {
                        return metrics.size() == exp;
                    }
                    case "completions": {
                        int completions = 0;
                        for (QueryDetailMetrics m : metrics) {
                            completions += m.completions();
                        }
                        return completions == exp;
                    }
                }
                return true;
            }
        }, (long)5000L);
    }

    private static class Worker
    extends Thread {
        private final IgniteCache cache;
        private final Query qry;

        Worker(IgniteCache cache, Query qry) {
            this.cache = cache;
            this.qry = qry;
        }

        @Override
        public void run() {
            this.cache.query(this.qry).getAll();
        }
    }
}

