/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryReflectiveSerializer;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BinarySerializationQuerySelfTest
extends GridCommonAbstractTest {
    private Ignite ignite;
    private IgniteCache<Integer, Object> cache;

    protected void beforeTest() throws Exception {
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setLocalHost("127.0.0.1");
        TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
        discoSpi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true));
        cfg.setDiscoverySpi((DiscoverySpi)discoSpi);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        if (this.useReflectiveSerializer()) {
            BinaryTypeConfiguration binTypCfg1 = new BinaryTypeConfiguration(EntityPlain.class.getName());
            BinaryTypeConfiguration binTypCfg2 = new BinaryTypeConfiguration(EntitySerializable.class.getName());
            BinaryTypeConfiguration binTypCfg3 = new BinaryTypeConfiguration(EntityExternalizable.class.getName());
            BinaryTypeConfiguration binTypCfg4 = new BinaryTypeConfiguration(EntityBinarylizable.class.getName());
            BinaryTypeConfiguration binTypCfg5 = new BinaryTypeConfiguration(EntityWriteReadObject.class.getName());
            binTypCfg1.setSerializer((BinarySerializer)new BinaryReflectiveSerializer());
            binTypCfg2.setSerializer((BinarySerializer)new BinaryReflectiveSerializer());
            binTypCfg3.setSerializer((BinarySerializer)new BinaryReflectiveSerializer());
            binTypCfg4.setSerializer((BinarySerializer)new BinaryReflectiveSerializer());
            binTypCfg5.setSerializer((BinarySerializer)new BinaryReflectiveSerializer());
            ArrayList<BinaryTypeConfiguration> binTypCfgs = new ArrayList<BinaryTypeConfiguration>();
            binTypCfgs.add(binTypCfg1);
            binTypCfgs.add(binTypCfg2);
            binTypCfgs.add(binTypCfg3);
            binTypCfgs.add(binTypCfg4);
            binTypCfgs.add(binTypCfg5);
            BinaryConfiguration binCfg = new BinaryConfiguration();
            binCfg.setTypeConfigurations(binTypCfgs);
            cfg.setBinaryConfiguration(binCfg);
        }
        CacheConfiguration cacheCfg = new CacheConfiguration("default");
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        ArrayList<QueryEntity> queryEntities = new ArrayList<QueryEntity>();
        queryEntities.add(BinarySerializationQuerySelfTest.entityForClass(EntityPlain.class));
        queryEntities.add(BinarySerializationQuerySelfTest.entityForClass(EntitySerializable.class));
        queryEntities.add(BinarySerializationQuerySelfTest.entityForClass(EntityExternalizable.class));
        queryEntities.add(BinarySerializationQuerySelfTest.entityForClass(EntityBinarylizable.class));
        queryEntities.add(BinarySerializationQuerySelfTest.entityForClass(EntityWriteReadObject.class));
        cacheCfg.setQueryEntities(queryEntities);
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        this.ignite = Ignition.start((IgniteConfiguration)cfg);
        this.cache = this.ignite.cache("default");
    }

    private static QueryEntity entityForClass(Class cls) {
        QueryEntity entity = new QueryEntity(Integer.class.getName(), cls.getName());
        entity.addQueryField("val", Integer.class.getName(), null);
        entity.setIndexes(Collections.singletonList(new QueryIndex("val", true)));
        return entity;
    }

    protected void afterTest() throws Exception {
        G.stopAll((boolean)true);
        this.ignite = null;
        this.cache = null;
    }

    @Test
    public void testPlain() throws Exception {
        this.check(EntityPlain.class);
    }

    @Test
    public void testSerializable() throws Exception {
        this.check(EntitySerializable.class);
    }

    @Test
    public void testExternalizable() throws Exception {
        this.check(EntityExternalizable.class);
    }

    @Test
    public void testBinarylizable() throws Exception {
        this.check(EntityBinarylizable.class);
    }

    @Test
    public void testWriteReadObject() throws Exception {
        this.check(EntityWriteReadObject.class);
    }

    private void check(Class cls) throws Exception {
        this.cache.put((Object)1, BinarySerializationQuerySelfTest.createInstance(cls, 10));
        this.cache.put((Object)2, BinarySerializationQuerySelfTest.createInstance(cls, 20));
        this.cache.put((Object)3, BinarySerializationQuerySelfTest.createInstance(cls, 30));
        Iterator iter = this.cache.query((Query)new SqlQuery(cls, "val=20")).iterator();
        assert (iter.hasNext());
        Cache.Entry res = (Cache.Entry)iter.next();
        BinarySerializationQuerySelfTest.assertEquals((Object)2, (Object)res.getKey());
        BinarySerializationQuerySelfTest.assertEquals((Object)20, (Object)U.field((Object)res.getValue(), (String)"val"));
        assert (!iter.hasNext());
        iter = this.cache.query(new SqlFieldsQuery("SELECT p.val FROM " + cls.getSimpleName() + " p WHERE p.val=20")).iterator();
        assert (iter.hasNext());
        List fieldsRes = (List)iter.next();
        BinarySerializationQuerySelfTest.assertEquals((Object)20, fieldsRes.get(0));
        assert (!iter.hasNext());
    }

    private static Object createInstance(Class cls, int val) {
        if (cls.equals(EntityPlain.class)) {
            return new EntityPlain(val);
        }
        if (cls.equals(EntitySerializable.class)) {
            return new EntitySerializable(val);
        }
        if (cls.equals(EntityExternalizable.class)) {
            return new EntityExternalizable(val);
        }
        if (cls.equals(EntityBinarylizable.class)) {
            return new EntityBinarylizable(val);
        }
        return new EntityWriteReadObject(val);
    }

    protected boolean useReflectiveSerializer() {
        return false;
    }

    private static class EntityWriteReadObject
    implements Serializable {
        public int val;

        public EntityWriteReadObject() {
        }

        public EntityWriteReadObject(int val) {
            this.val = val;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeInt(this.val);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.val = s.readInt();
        }
    }

    private static class EntityBinarylizable
    implements Binarylizable {
        public int val;

        public EntityBinarylizable() {
        }

        public EntityBinarylizable(int val) {
            this.val = val;
        }

        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.writeInt("val", this.val);
        }

        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.val = reader.readInt("val");
        }
    }

    private static class EntityExternalizable
    implements Externalizable {
        public int val;

        public EntityExternalizable() {
        }

        public EntityExternalizable(int val) {
            this.val = val;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.val);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.val = in.readInt();
        }
    }

    private static class EntitySerializable
    implements Serializable {
        public int val;

        public EntitySerializable() {
        }

        public EntitySerializable(int val) {
            this.val = val;
        }
    }

    private static class EntityPlain {
        public int val;

        public EntityPlain() {
        }

        public EntityPlain(int val) {
            this.val = val;
        }
    }
}

