/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.function.Function;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.Config;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class SecurityTest {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    private static final String IGNITE_HOME = U.getIgniteHome();

    @Before
    public void beforeEach() throws IgniteCheckedException {
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
    }

    @Test
    public void testEncryption() throws Exception {
        IgniteConfiguration srvCfg = Config.getServerConfiguration();
        SslContextFactory sslCfg = new SslContextFactory();
        Function<String, String> rsrcPath = rsrc -> Paths.get(IGNITE_HOME == null ? "." : IGNITE_HOME, "modules", "core", "src", "test", "resources", rsrc).toString();
        sslCfg.setKeyStoreFilePath(rsrcPath.apply("/server.jks"));
        sslCfg.setKeyStorePassword("123456".toCharArray());
        sslCfg.setTrustStoreFilePath(rsrcPath.apply("/trust.jks"));
        sslCfg.setTrustStorePassword("123456".toCharArray());
        srvCfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setSslEnabled(true).setSslClientAuth(true));
        srvCfg.setSslContextFactory((Factory)sslCfg);
        ClientConfiguration clientCfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"});
        try (Ignite ignored = Ignition.start((IgniteConfiguration)srvCfg);){
            boolean failed;
            Throwable throwable;
            IgniteClient client;
            try {
                client = Ignition.startClient((ClientConfiguration)clientCfg);
                throwable = null;
                try {
                    client.cache("default").put((Object)1, (Object)"1");
                    failed = false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client != null) {
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            client.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                failed = true;
            }
            Assert.assertTrue((String)"Client connection without SSL must fail", (boolean)failed);
            client = Ignition.startClient((ClientConfiguration)clientCfg.setSslMode(SslMode.REQUIRED).setSslClientCertificateKeyStorePath(rsrcPath.apply("/client.jks")).setSslClientCertificateKeyStoreType("JKS").setSslClientCertificateKeyStorePassword("123456").setSslTrustCertificateKeyStorePath(rsrcPath.apply("/trust.jks")).setSslTrustCertificateKeyStoreType("JKS").setSslTrustCertificateKeyStorePassword("123456").setSslKeyAlgorithm("SunX509").setSslTrustAll(false).setSslProtocol(SslProtocol.TLS));
            throwable = null;
            try {
                client.cache("default").put((Object)1, (Object)"1");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (client != null) {
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            client = Ignition.startClient((ClientConfiguration)clientCfg.setSslMode(SslMode.REQUIRED).setSslContextFactory((Factory)sslCfg));
            throwable = null;
            try {
                client.cache("default").put((Object)1, (Object)"1");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (client != null) {
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
    }

    @Test
    public void testInvalidUserAuthentication() {
        Exception authError = null;
        try (Ignite ignored = SecurityTest.igniteWithAuthentication(new AbstractMap.SimpleEntry[0]);
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserName("JOE").setUserPassword("password"));){
            client.getOrCreateCache("testAuthentication");
        }
        catch (Exception e) {
            authError = e;
        }
        Assert.assertNotNull((String)"Authentication with invalid credentials succeeded", (Object)authError);
        Assert.assertTrue((String)"Invalid type of authentication error", (boolean)(authError instanceof ClientAuthenticationException));
    }

    @Test
    public void testValidUserAuthentication() throws Exception {
        String USER = "joe";
        String PWD = "password";
        try (Ignite ignored = SecurityTest.igniteWithAuthentication(new AbstractMap.SimpleEntry<String, String>("joe", "password"));
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserName("joe").setUserPassword("password"));){
            client.getOrCreateCache("testAuthentication");
        }
    }

    @Test
    public void testUserCannotCreateUser() throws Exception {
        String USER = "joe";
        String PWD = "password";
        try (Ignite ignored = SecurityTest.igniteWithAuthentication(new AbstractMap.SimpleEntry<String, String>("joe", "password"));
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserName("joe").setUserPassword("password"));){
            Exception authError = null;
            try {
                client.query(new SqlFieldsQuery(String.format("CREATE USER \"%s\" WITH PASSWORD '%s'", "joe2", "password"))).getAll();
            }
            catch (Exception e) {
                authError = e;
            }
            Assert.assertNotNull((String)"User created another user", (Object)authError);
        }
    }

    @SafeVarargs
    private static Ignite igniteWithAuthentication(AbstractMap.SimpleEntry<String, String> ... users) throws Exception {
        Ignite ignite = Ignition.start((IgniteConfiguration)Config.getServerConfiguration().setAuthenticationEnabled(true).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))));
        ignite.cluster().active(true);
        for (AbstractMap.SimpleEntry<String, String> u : users) {
            SecurityTest.createUser(u.getKey(), u.getValue());
        }
        return ignite;
    }

    private static void createUser(String user, String pwd) throws Exception {
        try (IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserName("ignite").setUserPassword("ignite"));){
            client.query(new SqlFieldsQuery(String.format("CREATE USER \"%s\" WITH PASSWORD '%s'", user, pwd))).getAll();
        }
    }
}

