/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.Config;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class FunctionalQueryTest {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testQueries() throws Exception {
        IgniteConfiguration srvCfg = Config.getServerConfiguration();
        srvCfg.setBinaryConfiguration(new BinaryConfiguration().setTypeConfigurations(Arrays.asList(new BinaryTypeConfiguration(this.getClass().getName()), new BinaryTypeConfiguration(SerializedLambda.class.getName()))));
        try (Ignite ignored = Ignition.start((IgniteConfiguration)srvCfg);
             IgniteClient client = Ignition.startClient((ClientConfiguration)FunctionalQueryTest.getClientConfiguration());){
            ClientCache cache = client.getOrCreateCache("default");
            Map<Integer, Person> data = IntStream.rangeClosed(1, 100).boxed().collect(Collectors.toMap(i -> i, i -> new Person(i, String.format("Person %s", i))));
            cache.putAll(data);
            int minId = data.size() / 2 + 1;
            int pageSize = (data.size() - minId) / 3;
            int expSize = data.size() - minId + 1;
            Map<Integer, Person> exp = data.entrySet().stream().filter(e -> (Integer)e.getKey() >= minId).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<Query> queries = Arrays.asList(new ScanQuery((IgniteBiPredicate & Serializable)(i, p) -> p.getId() >= minId).setPageSize(pageSize), new SqlQuery(Person.class, "id >= ?").setArgs(new Object[]{minId}).setPageSize(pageSize));
            for (Query qry : queries) {
                QueryCursor cur = cache.query(qry);
                Throwable throwable = null;
                try {
                    List res = cur.getAll();
                    Assert.assertEquals((String)String.format("Unexpected number of rows from %s", qry.getClass().getSimpleName()), (long)expSize, (long)res.size());
                    Map<Integer, Person> act = res.stream().collect(Collectors.toMap(Cache.Entry::getKey, Cache.Entry::getValue));
                    Assert.assertEquals((String)String.format("unexpected rows from %s", qry.getClass().getSimpleName()), exp, act);
                }
                catch (Throwable res) {
                    throwable = res;
                    throw res;
                }
                finally {
                    if (cur == null) continue;
                    if (throwable != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable res) {
                            throwable.addSuppressed(res);
                        }
                        continue;
                    }
                    cur.close();
                }
            }
            SqlFieldsQuery qry = new SqlFieldsQuery("select id, name from Person where id >= ?").setArgs(new Object[]{minId}).setPageSize(pageSize);
            try (FieldsQueryCursor cur = cache.query(qry);){
                List res = cur.getAll();
                Assert.assertEquals((long)expSize, (long)res.size());
                Map<Integer, Person> act = res.stream().collect(Collectors.toMap(r -> Integer.parseInt(r.get(0).toString()), r -> new Person(Integer.valueOf(Integer.parseInt(r.get(0).toString())), r.get(1).toString())));
                Assert.assertEquals(exp, act);
            }
        }
    }

    @Test
    public void testSql() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (id INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s\"", Person.class.getName())).setSchema("PUBLIC")).getAll();
            int key = 1;
            Person val = new Person(Integer.valueOf(key), "Person 1");
            client.query(new SqlFieldsQuery("INSERT INTO Person(id, name) VALUES(?, ?)").setArgs(new Object[]{val.getId(), val.getName()}).setSchema("PUBLIC")).getAll();
            Object cachedName = ((List)client.query(new SqlFieldsQuery("SELECT name from Person WHERE id=?").setArgs(new Object[]{key}).setSchema("PUBLIC")).getAll().iterator().next()).iterator().next();
            Assert.assertEquals((Object)val.getName(), cachedName);
        }
    }

    @Test
    public void testGettingEmptyResultWhenQueryingEmptyTable() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            String TBL = "Person";
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (id INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s\"", Person.class.getName())).setSchema("PUBLIC")).getAll();
            List res = client.query(new SqlFieldsQuery("SELECT * FROM Person")).getAll();
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((long)0L, (long)res.size());
            ClientCache cache = client.cache("SQL_PUBLIC_" + "Person".toUpperCase());
            res = cache.query(new SqlFieldsQuery("SELECT * FROM Person")).getAll();
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((long)0L, (long)res.size());
            List<Query> queries = Arrays.asList(new ScanQuery(), new SqlQuery(Person.class, "1 = 1"));
            for (Query qry : queries) {
                QueryCursor cur = cache.query(qry);
                Throwable throwable = null;
                try {
                    List res2 = cur.getAll();
                    Assert.assertNotNull((Object)res2);
                    Assert.assertEquals((long)0L, (long)res2.size());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cur == null) continue;
                    if (throwable != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cur.close();
                }
            }
        }
    }

    private static ClientConfiguration getClientConfiguration() {
        return new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setSendBufferSize(0).setReceiveBufferSize(0);
    }
}

